c***************************************************************
c* This is a Fortran 77 retrieval code to read and print the   *               c* Carbon Dioxide concentrations data in surface water and     * 
c* atmosphere: PMEL cruises 1986-1989                          *
c***************************************************************


c*Defines variables*

       INTEGER day, year 
       CHARACTER cruis*19, month*3, flag*1
       REAL daygmt, lat, long, dist, temp, warm, sal, apre
       REAL xco2a, xco2sw, fco2a, fco2sw
       OPEN (unit=1, file='file.in')
       OPEN (unit=2, file='file.out')
       write (2, 5)

c*Writes out column labels*

 5     format (8X,'CRUISE NAME',2X,'CRUISE DATE',2X,'DAY GMT',3X,
     1 'LATIT',5X,'LONGIT',2X,'DISTAN',4X,'TEMP',1X,'WARMING',2X,
     2 'SALINITY',1X,'ATM.PRE',1X,'X(CO2)a',1X,'X(CO2)w',1X,
     3 'f(CO2)a',1x,'f(CO2)w',1X,'QF',/,20X,'day mon year',10X,
     4 'dec.deg',4X,'dec.deg',6X,'km',3X,'deg.C',3X,'deg.C',7X,
     5 'ppt',4X,'mbar',5X,'ppm',5X,'ppm',4X,'uatm',4X,'uatm',//)

c*Sets up a loop to read and format all the data in the file*

 7     CONTINUE    
       read (1, 10, end=999) cruis, day, month, year, daygmt, lat, 
     1 long, dist, temp, warm, sal, apre, xco2a, xco2sw, fco2a, 
     2 fco2sw, flag
 10    format (A19, 2X, I2, 1X, A3, 1X, I4, 2X, F7.3, 1X, F7.3, 3X,
     1 F8.3, 1X, F7.1, 1X, F7.2, 1X, F7.2, 2X, F8.3, 2X, F6.1, 1X,
     2 F7.2, 1X, F7.2, 1X, F7.2, 1X, F7.2, 2X, A1)
  
       write (2, 20) cruis, day, month, year, daygmt, lat, 
     1 long, dist, temp, warm, sal, apre, xco2a, xco2sw, fco2a, 
     2 fco2sw, flag
 20    format (A19, 2X, I2, 1X, A3, 1X, I4, 2X, F7.3, 1X, F7.3, 3X,
     1 F8.3, 1X, F7.1, 1X, F7.2, 1X, F7.2, 2X, F8.3, 2X, F6.1, 1X,
     2 F7.2, 1X, F7.2, 1X, F7.2, 1X, F7.2, 2X, A1)
       
       GOTO 7
999    close(unit=1)    
       close(unit=2)
       stop
       end
 
