/*---------------------------------------------
   program name :eview.c
   argument     :filename
   author       :Yoshiaki Kanno ( JMA )
   machine      :MS-DOS (executable)
                :UNIX   (source)
   history      :1996.2.23   ver 1.0

   Platform     :MS-DOS (TURBO-C v1.5/v2.0)
                 MS-DOS (MS-C v5.1; option "/F 3F00" required)
                 SunOS 4.1.3 (SPARCompiler C 3.0.1)
                 FreeBSD 2.0R (gcc 2.6.2)
----------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <math.h>

struct   cruise_info
   {
         char  ver[4];
         char  cruise[5];
         char  period[10];
         char  area[98];
         char  total_st[5];
         char  shipflg[3];
         char  emark[3];
   };
struct   station_info
   {
         char  station[8];
         char  lat[8];
         char  lon[9];
         char  start_time[11];
         char  end_time[11];
         char  depth[6];
         char  w_color[3];
         char  trns[6];
         char  space[39];
         char  bt[7];
         char  acm[7];
         char  sbnum[6];
         char  anual[4];
         char  emark[3];
   } ;
struct   station_news
   {
         char  station[8];
         char  news[82];
       char  special_obs[35];
         char  emark[3];
   }     ;
struct   data_set
   {
         char  station[8];
         char  time[5];
         char  angl[3];
         char  btl_depth[4];
         char  btl_temp[7];
         char  btl_sal[7];
         char  d_oxy[4];
         char  PO3[5];
         char  total_P[5];
         char  NO3[5];
         char  NO2[5];
         char  NH3[5];
         char  pH[5];
         char  chlor[7];
         char  phaeo[7];
         char  spcl_obs[11];
         char  std_depth[5];
         char  std_temp[6];
         char  std_sal[11];
         char  d_st[5];
         char  d_D[5];
         char  emark[3];
   } ;

float bt2f(char *s,int n)
{
         char dm[20];
         strncpy(dm,s,n); dm[n]='\0';
         return (float)atof(dm);
}

int bt2i(char *s,int n)
{
         char dm[20];
         strncpy(dm,s,n); dm[n]='\0';
         return atoi(dm);
}

char *bt2a(char *s,int n)
{
         static char dm[100];
         strncpy(dm,s,n); dm[n]='\0';
         return dm;
}

void usage_exec()
{
     printf("this program needs an argument for file name to browse,\n");
     printf(" eview < filename >\n\n");
     printf("for example, $ eview /cdrom/ship/1994/ry9405/ry9405.e (on Unix)\n");
     printf("         or  > eview g:\\ship\\1994\\ry9405\\ry9405.e (on MS-DOS).\n\n");
     exit(0);
}

void file_err(char *s)
{
     printf("[%s] is not found\n",s);
     exit(0);
}
usage_com()
{

     printf("\n  b  :view bottle sampled  data\n");
     printf("  s  :view standard deapth data\n");
     printf("  n  :read next station\n");
     printf("  c  :cruise information\n");
     printf("  i  :station information\n");
     printf("  q  :quit this browser\n");
     printf("  u  :print this usage\n");
     return 0;
}
main(int argc,char *argv[])
{
         FILE  *fp;
         int i,j,c;
         struct   cruise_info    h0;
         struct   station_info   h1;
         struct   station_news   h2;
         struct   data_set    dt[100];

         if(argc<2)  usage_exec();
         if((fp=fopen(argv[1],"rb"))==NULL)  file_err(argv[1]);

         fread((char *)&h0,sizeof(h0),1,fp);

         do{
          fread((char *)&h1,sizeof(h1),1,fp);
          fread((char *)&h2,sizeof(h2),1,fp);
          for(i=0;i<100;i++){

          fread((char *)&dt[i],sizeof(dt[i]),1,fp);
           if(emark_chk(dt[i]))  break;
                   }
          do{
            input_mess(h1);
            c=getchr();
               printf("%c",c);
            switch(tolower(c)){
            case 'b':  btl_head();
                         for(j=0;j<=i && j<22;j++) dsp_btldt(dt[j]);
                         if(i>=22){
                 printf("\n----more----");
                    getchr();
                         btl_head();
                         for(j=22;j<=i;j++) dsp_btldt(dt[j]);  }
                         break;
            case 's':  std_head();
                         for(j=0;j<=i && j<22;j++) dsp_stddt(dt[j]);
                         if(i>=22){
                 printf("\n----more----");   getchr();
                         for(j=22;j<=i;j++) dsp_stddt(dt[j]);  }
                         break;
            case 'c':   dsp_cruise_info( h0 )  ;    break;
            case 'i':   dsp_station_info(h1,h2);    break;
            case 'n':   break;
            case 'u':   usage_com(); break;
            case 'q':   exit(0);
                   }
            }while(c!='n') ;
         }while(!feof(fp));
      fclose(fp);

        return 0;
}
getchr()
{
#if defined(__MSDOS__) || defined(MSDOS)
      return getch();
#else
    char c;

    system("stty raw -echo");
    c=getchar();
    system("stty -raw echo");
    return c;
#endif
}

emark_chk(struct data_set dt)
{
     char mark[10];
     strcpy(mark,bt2a(dt.emark,sizeof(dt.emark)));
     if(mark[0]=='=') return 0;
     return 1;
}
input_mess(struct station_info h)
{
     printf("\ninput command for %s"
         , bt2a( h.station,sizeof(h.station )));
     printf("(%s",  bt2a( h.lat    ,sizeof(h.lat )));
     printf("%s",   bt2a( h.lon    ,sizeof(h.lon )));
     printf("%s),'u' to usage>>"         , bt2a( h.start_time,sizeof(h.start_time )));
     return 0;
}

dsp_cruise_info(struct cruise_info h)
{
     printf("\n\n[[ cruise infomation  %s ]]",
               bt2a( h.cruise,sizeof(h.cruise )));
     printf("\nFile format version:");
     printf("%s\n", bt2a( h.ver,sizeof(h.ver )));

     printf("cruise period      : ");
     printf("%s\n", bt2a( h.period,sizeof(h.period )));

     printf("observed area      :");
     printf("%s\n", bt2a( h.area ,sizeof(h.area )));
     printf("total station number:");
     printf("%s\n", bt2a( h.total_st ,sizeof(h.total_st)));
     printf("flag of each vessel: ");
     printf("%s\n", bt2a( h.shipflg ,sizeof(h.shipflg )));
     return 0;
}
dsp_station_info(struct station_info h,struct station_news h1)
{
     printf("\n\n[[ station  infomation %s ]]\n",
                       bt2a( h.station,sizeof(h.station )));

     printf("position            :");
     printf("%s"  , bt2a( h.lat  ,sizeof(h.lat  )));
     printf("%s\n", bt2a( h.lon  ,sizeof(h.lon  )));

     printf("begin and end   time:");
     printf("%s",   bt2a( h.start_time ,sizeof(h.start_time )));
     printf("%s\n", bt2a( h.end_time   ,sizeof(h.end_time   )));

     printf("Topographical depth :");
     printf("%s\n", bt2a( h.depth      ,sizeof(h.depth   )));

     printf("water color ,transparency and angle: ");
     printf("%s",   bt2a( h.w_color  ,sizeof(h.w_color )));
     printf("%s\n", bt2a( h.trns     ,sizeof(h.trns )));

     printf("same time observation:");
     printf("%s",   bt2a( h.bt    ,sizeof(h.bt   )));
     printf("%s\n", bt2a( h.acm   ,sizeof(h.acm  )));
     printf("supplement number    :");
     printf("%s\n", bt2a( h.sbnum ,sizeof(h.sbnum )));

     printf("cruise name          :");
     printf("%s\n", bt2a( h.anual ,sizeof(h.anual )));
     printf("remark:\n");
     printf("%s\n", bt2a( h1.news ,sizeof(h1.news )));
     printf("special observation: ");
     printf("%s\n", bt2a( h1.special_obs  ,sizeof(h1.special_obs )));
     return 0;
}

std_head()
{
     printf("\nDEP(m) TEMP(deg) SAL(psu) D_st(m3/kg) d_D(m2/sec2)");
     return 0;
}
dsp_stddt(struct  data_set dt)
{
     printf("\n");
     printf("%s"     , bt2a( dt.std_depth ,sizeof(dt.std_depth)));
     printf("  %s"   , bt2a( dt.std_temp  ,sizeof(dt.std_temp)));
     printf("    %s" , bt2a( dt.std_sal   ,sizeof(dt.std_sal )));
     printf("  %s"   , bt2a( dt.d_st      ,sizeof(dt.d_st  )));
     printf("   %s"  , bt2a( dt.d_D       ,sizeof(dt.d_D    )));
     return 0;
}

btl_head()
{
     printf("\nTime Depth Temp  Sal   DO  PO4   T-P  NO3");
     printf(" NO2   PH    CHL    PHA  special.obs");
     return 0;
}

dsp_btldt(struct  data_set dt)
{
     printf("\n");
     printf("%s", bt2a( dt.time      ,sizeof(dt.time     )));
     printf("%s", bt2a( dt.btl_depth ,sizeof(dt.btl_depth)));
     printf("%s", bt2a( dt.btl_temp  ,sizeof(dt.btl_temp )));
     printf("%s", bt2a( dt.btl_sal   ,sizeof(dt.btl_sal  )));
     printf("%s", bt2a( dt.d_oxy     ,sizeof(dt.d_oxy    )));
     printf("%s", bt2a( dt.PO3       ,sizeof(dt.PO3      )));
     printf("%s", bt2a( dt.total_P   ,sizeof(dt.total_P  )));
     printf("%s", bt2a( dt.NO3       ,sizeof(dt.NO3      )));
     printf("%s", bt2a( dt.NO2       ,sizeof(dt.NO2      )));
/*   printf("%s", bt2a( dt.NH3       ,sizeof(dt.NH3      )));
*/   printf("%s", bt2a( dt.pH        ,sizeof(dt.pH       )));
     printf("%s", bt2a( dt.chlor     ,sizeof(dt.chlor    )));
     printf("%s", bt2a( dt.phaeo     ,sizeof(dt.phaeo    )));
     printf("%s", bt2a( dt.spcl_obs  ,sizeof(dt.spcl_obs )));
     return 0;
}
