      SUBROUTINE DATAINPUT(cc,nlevels,iyear,month,iday,time,
     *     rlat,rlon,icruise,bmiss,ifirst,ifn,ifnum,jj,ifileend,
     *     iheadsig,iaccess)

C    SISMER CONVERTS DATA IN SISMER FORMAT TO OCL FORMAT

c*****************************************************************
c     --- STANDARD PARAMETERS ---

c      maxlevel - maximum number of depth levels
c      maxcalc - maximum number of measured and calculated parameters
c      nprobe - maximum number of probe types
c      maxparm - maximum number of measured parameters
c      nsize - size of character record
c      numvars - number of global character types
c      nfoutmax - maximum number of flags which need
c                not be recorded
c
c*****************************************************************

      parameter (maxlevel=6000, maxcalc=200, nprobe=100)
      parameter (maxparm=100, nsize=500, maxship=83)
      parameter (maxacc=50000, numvars=6, maxcc=200)
      parameter (nfoutmax=10)
      parameter (maxvalue=500)
	  parameter (maxpival=2000)

c*****************************************************************
c     --- STANDARD CHARACTERS ---
c      cc - country code for each profile
c      filein - input files name
c      origc - originators cruise code
c      origclast - used to identify new cruises
c      record - data read in
c
c      added the following;
c        plat, platsave - used to identify NODC platform codes
c        pheader - used to identify new header

c*****************************************************************

      character*2 cc, plat, dcc, dplat,ncc(maxcc),crui, ccc
      character*9 firsttime
      character*17 origc, origclast, dorigc
      character*500 record
      character*500 carray
      character*80 hflag,gflag,pflag,g3parm
	  character*40 piname(maxpival)
      character*13 headname(maxpival)
	  character*28 projname(maxvalue)
	  character*28 projnamef
	  character*40 pinamef
      character*17 origs
      character*80 filein
      character*6 platsave
      character*13 pheader
      character*15 citf(maxparm)
      character*4 parn(maxvalue)

c*****************************************************************
c
c     --- STANDARD ARRAYS ---
c     temp - parameter data
c     depth - observed depths
c     ifnum - information storage files
c     iheadsig - number of significant figures in:
c      1. latitude
c      2. longitude
c      3. time
c     iacc - all NODC access numbers
c     iproj - all NODC project codes
c     iinst - all NODC institute codes
c     iccr - cruise codes + country codes
c
c     itemp - variable identifier from G3 code list (param.txt)
c     pmiss - missing value identifier
c     iflag - paramter flag
c     ipflag - global parameter flag
c     icomma - reads space delimited arrays (1=starting byte,2=
c              number of bytes)
c      ifout - flag values which need not be recorded
c      iflag - originators flag information
c              1. parameter of flag
c              2. depth number of flag
c              3. value of flag
c
c*****************************************************************

      dimension temp(maxlevel,maxcalc), depth(maxlevel)
      dimension ifnum(nprobe), iheadsig(3)
      dimension isignif2(maxlevel,maxcalc)
      dimension iacc(maxacc), iproj(maxacc), iinst(maxacc)
      dimension iccr(maxacc), iallcruise(maxacc)
      dimension itemp(maxvalue),ipval(maxvalue),iunit(maxvalue) 
	  dimension ipicode(maxpival), iorgcode(maxpival)
	  dimension ircode(maxvalue)
      dimension iind(maxpival)
      dimension itempu(maxvalue)
      dimension icomma(maxparm,2)
      dimension pmiss(maxparm)
      dimension iflag((maxparm+1)*maxlevel,3),ifout(nfoutmax)
      dimension irtc(maxpival), irsc(maxpival),iroc(maxpival)

c*****************************************************************
c
c     --- STANDARD COMMON ---
c     thedata - the data
c     numeach - the number of each category of parameter
c      Common eachparm contains the number of each category of
c      parameter that is listed in probefile.d
c
c      numeach:
c      1. number of measured parameters + one for second header
c      2. number of calculated parameters
c      3. number of specific second header parameters
c      4. number of specific biological parameters
c      5. number of taxonomic variables
c         numtot2 - first possible parameter code minus one of
c                   second header parameters
c         numtot3 - first possible parameter code minus one of
c                   biological parameters
c         ntaxa - number of taxa in individual profiles
c      Z - input files name
c      significant - contains isignif, the number of significant
c                    figures in a data value.
c     chardata  - contains information on character tyoes:
c             itype - type of information to be placed in
c             global C variable:
c              1. area codes
c              2. NODC ship codes and ship names
c              3. NODC institute codes and institute names
c              4. Project names
c              5. Primary investigator names
c              The appropriate array position is set to one if
c              the character type is desired
c              irecnum - starting position in global C array of
c               each character type
c              jtype - requested character type(s)
c      accnums - contains iacc,iproj, and iinst,
c                the access numbers, project codes, and
c                institute codes associated with each cruise code
c
c*****************************************************************

      common /thedata/ depth,temp
      common /significant/ isignif(maxlevel,maxcalc)
      common /eachparm/ numeach(6),numtot2,numtot3,ntaxa,numsecset
      common /accnums/ iacc,iproj,iinst,iccr
      common /chardata/ itype(numvars),irecnum(numvars+1),
     *     jtype(numvars)
      common /Z/ filein
      common /countryc/ ncc
      common /statorig/origs
      common /oflag/iorigsflag
      common /parnames/ citf
      common /theflags/ntotflag,iflag

c***********************************************************
c
c     itype is set to one for requested variables.
c     Set ship codes as requested variable
c              1. area codes
c              2. NODC ship codes and ship names
c              3. NODC institute codes and institute names
c              4. Project names
c              5. Primary investigator names
c***********************************************************
     
      data itype/0,1,0,0,0,0/
      
c*****************************************************************
c
c     --- STANDARD SAVEs ---
c      itime - set to one at first run through subroutine
c      incruise - current cruise number
c      ntaxbase -  base number for taxonomic sets = the
c                  base number for biological parameters + 100
c      isiga - number of significant figures in access number
c      xinst,nisig - institute code and number of sig figures
c      xproj,npsig - project code and number of sig figures
c      dcode,dsig - platform code and number of sig figures
c      ifilenow - present file number
c      record - record type for line read in
c      ccode - country code
c
c*****************************************************************
      
      save record
      save ntaxbase,isiga,xaccess,ipval,npval,iunit
      save firsttime,parn
	  save piname,ipicode,iorgcode,npiorgval,iind
      save headname, projname, ircode, irtc, irsc, iroc
      save npinstval, npprojval
c*****************************************************************
c
c NEW SAVE
c
c*****************************************************************

      save iFILEdone,origclast
      save dcode,dorigc,dplat,dcc
      save pheader, icruisex, icruiselast
      save ncomma, icomma, rproj, ipi
      save nfout, ifout, rinst, ro, rt, rs
 
c*****************************************************************
c
c FIRST RUN INITIALIZATION SECTION
c  Allocate space for C character array which will hold
c  input data.
c
c  charalloc:  nsize - space allocated for character array
c  ntaxbase:   set base number for taxa sets
c
c  Read in all ship codes
c   extraglobal:
c
c  Common Block used: chardata (variable itype)
c  Common Block set: chardata (variables irecnum and jtype)
c   itype - type of information to be placed in global C variable:
c           1. area codes
c           2. NODC ship codes and ship names
c           3. NODC institute codes and institute names
c           4. Project names
c           5. Primary investigator names
c
c*****************************************************************
c one time, first run only
c read header line
c*****************************************************************
      deb=5
      if ( firsttime .ne. 'datainput' ) then
       firsttime='datainput'
	   
c       if (iter.eq.0) then
       call arrayinit(ipval,1,maxvalue)
       call arrayinit(iunit,1,maxvalue)
	   call arrayinit(ipicode,1,maxpival)
	   call arrayinit(iorgcode,1,maxpival)
	   call arrayinit(iind,1,maxpival)
	   call arrayinit(irtc,1,maxpival)
	   call arrayinit(irsc,1,maxpival)
	   call arrayinit(iroc,1,maxpival)
	   call arrayinit(ircode,1,maxpival)
       call parcodes(ipval,iunit,parn,maxvalue,npval,"paramu.txt\0")
	   call piorgcodes(piname,ipicode,iorgcode,iind,maxpival,
     *       npiorgval,"piorg.out\0")
	   call projcodes(projname,ircode,maxvalue,npprojval,"proj.out\0")
       call instcodes(headname,irtc,irsc,iroc,maxpival,
     *     npinstval,"instcodes.txt\0")
c       endif

       if (deb.eq.1) then       
c      print *, ircode
c     print *, iunit
c     print *, npval
	   endif

       call charalloc(nsize)

       xaccess = iaccess



       ntaxbase=100+numtot3
       call extraglobal
       ifirst=1

       nfout=5
       ifout(1)=0
       ifout(2)=1
       ifout(3)=2
       ifout(4)=5
       ifout(5)=9
       
c**************************************************************

      endif

 
       call findsignif(isiga,0,xaccess)	    
      
c*****************************************************************
c
c     MAIN PROCESSING LOOP
c
c*****************************************************************
c read in another line of file, if necessary, until
c a new profile header is encountered.  A line is not read in
c ifirst - instructions for main program:
c          0 - no profile sent - beginning of file
c          1 - end of file reached
c          2 - good profile sent
c         >2 - bad profile sent, do not record
c
c conread:
c  ifn - file identification number of ASCII data file
c  1 - starting position to write data into global array
c  nchar - number of characters to read into array, zero
c          means read until return is found
c  iend - set to -1 if ASCII file has been completely read in,
c         else set to number of characters read in

c*****************************************************************
c read first line of file and save input
c origc, cc, plat

c extractc
c  1 - number of characters to extract
c  10 - starting point in global array for reading data
c  record - character array accepting data (record type)
c*****************************************************************



      if (ifirst .eq. 1 ) then
       call conread(ifn,1,0,iend)
       call extractc(iend,1,record)
	  if (deb.eq.1) then
      write(*,*) record(1:iend)
	  endif
c*****************************************************************
c Profile header identifier - pheader
c Originators cruise - 10:14        
c*****************************************************************

       if (record(1:1) .eq. '*') then
        pheader = record(2:14)
        call clearstring(dorigc,17)
        dorigc(1:15) = record(16:30)
	   
	    if (deb.eq.1) then
        print *, 'dorigc=  ', dorigc
	    print *, 'pheader=  ', pheader
	    endif

		sst = 0.
	    sss = 0.
        sso = 0.

	    do 14 ipp = 1,npinstval

		if (pheader .eq. headname(ipp)) then
	    sst = irtc(ipp)
	    if (sst.eq.9999 .or. sst .le. 0 ) sst = 0.
	    sss = irsc(ipp)
		if (sss.eq.9999 .or. sss .le. 0 ) sss = 0.
	    sso = iroc(ipp)
	    if (sso.eq.9999 .or. sso .le. 0 ) sso = 0.
	    
	    endif	
 
 14     continue

 		rt = sst
		rs = sss
	    ro = sso
		
c*************************************************************
c     [3] Platform - (51:52)
c*************************************************************

        dplat=record(51:52)
	    if (deb.eq.1) then
        print *,'dplat =',  dplat
	    endif

        crui=record(49:50)
c*****************************************************************
c ASSIGN CRUISE NUMBER  
c*************************************************************

        origc(1:15)=dorigc(1:15)

        if (origc(1:15) .ne. origclast(1:15)) then
         origclast = origc
         icruisex = icruisex + 1
        endif

       endif 

c*****************************************************************
c Read third line of header to get country code (3:4) and
c institute 
c*****************************************************************

       call conread(ifn,1,0,iend)
       call extractc(iend,1,record)
      if (deb.eq.1) then
      write(*,*) 'third line ',record(1:iend)
	  endif

       call conread(ifn,1,0,iend)
       call extractc(iend,1,record)

       if (deb.eq.1) then
      write(*,*) 'fourth line',record(1:iend)
       endif

       if (record(1:2) .eq. 'XX') then
        dcc='99'
       else
        dcc=record(1:2)
       endif

       if (record (4:10) .eq. 'UNKNOWN') then
        rinst = 0.
       endif

 
c*****************************************************************

c*****************************************************************
c Read the fifth line of header to get PROJECT NAME  and
c PI name 
c*****************************************************************
	
	  call conread(ifn,1,0,iend)
      call extractc(iend,1,record)
 	  
 	  pinamef=record(1:40)
	  projnamef=record(50:77)
	  ss0 = 0.
          print *,  pinamef
c Obtain the pi codes from piorg.out file
         do 144 ipp = 1,npiorgval
		 
		 if (pinamef .eq. piname(ipp)) then
		   ipi = ipicode(ipp)
	       ss = iorgcode(ipp)
		   if (ss.eq.9999) ss = 0.
	       if (ipi.eq.9999) ipi =0
           ss0 = max(ss,ss0)
		endif

 144     continue

         rinst = ss0
         print *, 'rinst, ipi=', rinst , ipi     

		 ssa =0.
	     do 145 ipp = 1,npprojval
		 
		 if (projnamef .eq. projname(ipp)) then
		   ssa = ircode(ipp)
		   if (ssa.eq.9999) ssa = 0.
		endif

 145  continue

         rproj = ssa
	    
	 
	 
	  if (deb.eq.1) then
	  write(*,*) 'pinamef, projnamef  ', pinamef, projnamef
      print *, 'rproj =' , rproj
	  endif

      endif
      ifirst = 0
       ival=0
 
c*****************************************************************
c BEGIN MAIN LOOP
c*****************************************************************

      do 50 ii = 1,2000000     
       
c Read from the datafile
       if (ifirst .le. 1) then 
        if ( iend .ge. 0 ) call conread(ifn,1,0,iend)
        if ( iend .gt. 0 ) call extractc(iend,1,record)
	   
	    if (deb.eq.1) then
       write(*,*) ii, 'record', record(1:iend)
	    endif
        
c handle empty line case

        if (iend.gt.-1 .and. iend.lt.5) goto 50
 
c*****************************************************************
c If the end of a file has been reached, add one to the
c number of files read in, set ifirst to 1 to denote end of
c file, and return to main program to open the next file.
c*****************************************************************
          
        if (iend .lt. 0) iFILEdone = 1
          
        if (iFILEdone .eq. 1) then 
         iFILEdone = 0
         ifirst = 1       
         ifileend = ifileend + 1 
         print *, 'ifileend',ifileend  
         iend=0
         return                          
        endif                

c******************************.s***********************************
c NEW PROFILE CHECK
c read last line of each profile 
c*****************************************************************
        
        if (record(1:6).eq.'-999.9'.or.record(3:8).eq.'-999.9' .or.
     $       record(1:6).eq.'9999.9'.or.record(1:5).eq.'-99.9') then 
c       if (record(2:14).eq. pheader) then
         ifirst=2      
         ival= 0
         return
        endif                
          
       endif              

c*************************************************************
c     Reset ifirst to zero, for no profile read yet
c*************************************************************

       ifirst = 0
       
c*********************************************************************
c BEGIN HEADERS
c*********************************************************************
c SKIP IF OCL OR NODC ARE SOURCE OF DATA
c*****************************************************************

c      if (record(16:18).eq.'OCL'.or.record(16:19).eq.'NODC')goto 50

c************************************************************
c Read originator's station code (position 15:19)
c************************************************************

       if (record(2:14) .eq. pheader) then
	      if (deb.eq.1) then
          print *, ' orig station code', record(15:19)
	      endif
        call writeconv(1,7,temp,depth,15,5,ihere,jj,bmiss,bmiss,
     *  '\0',isignif,maxlevel,maxcalc,-1,0,0,0,0.)
c        print *, ihere,jj,bmiss,bmiss
c*************************************************************
c    If originator station ID is present, write out to file
c*************************************************************

        if (ihere .le. 0) then
         origs(1:5) = '     '
         origs(1:5) = record(15:19)
         call addCend(origs,5,1)
         if (origs(1:2) .ne. '  ') iorisgflag = 1
        endif
       endif

	    if (deb.eq.1) then
        print *, record   
	    endif     
c************************************************************
c     Read in date,position, time, depth
c************************************************************

      if (record(1:6) .eq. '*DATE=' .and. record(9:9)
     *    .ne. '/')then

       
c************************************************************
c DATE
c year -  positions 11:14, error code 5
c day -   positions 7:8, error code 7
c month - positions 9:10, error code 6
c no missing values
c*********************************************************************

       call extracti(jj,5,4,11,isig,'\0',iyear,ihere)
       call extracti(jj,6,2,9,isig,'\0',month,ihere)
       call extracti(jj,7,2,7,isig,'\0',iday,ihere)

c*********************************************************************
c TIME 
c hours:   positions 21:22, 0 implicit decimals, error code 8
c minutes: position 23:24, error code 9
c*********************************************************************


c      SUBROUTINE POSITION(jj,i1,it1,is1,iexpl1,cm1,
c     *                       i2,it2,is2,iexpl2,cm2,
c     *                       i3,it3,is3,iexpl3,cm3,
c     *                       itype0,ipos,val,ihere,isignif)

c     CALCULATES POSITION OR TIME

c*************************************************************
c
c    Passed Variables:
c
c     jj - profile number
c     i1 - error code of first parameter, either degrees of position
c          or hours in time
c     it1 - number of characters in first parameter
c     is1 - starting position in character array of first parameter
c     iexpl1 - number of implicit decimals, zero if explicit, in
c             first parameter
c     cm1 - character missing value for first parameter
c     i2 - error code of second parameter, either minutes of position
c          or minutes in time
c     it2 - number of characters in second parameter
c     is2 - starting position in character array of second parameter
c     iexpl2 - number of implicit decimals, zero if explicit, in
c             second parameter
c     cm2 - character missing value for second parameter
c     i3 - error code of third parameter, either seconds of position
c          or seconds in time
c     it3 - number of characters in third parameter
c     is3 - starting position in character array of third parameter
c     iexpl3 - number of implicit decimals, zero if explicit, in
c             third parameter
c     cm3 - character missing value for third parameter
c     itype0 - type of lat/lon storage: 0=time being input or position
c             explicit (negative =south or west, 1=N:S for latitude,
c             W:E for longitude, 2=WMO quadrants, 3=ICES quadrants.
c             A negative value means the seconds are actually
c             the values for minutes left of the decimal
c     ipos - position of type variable
c     val - returned value, either position or time
c     ihere - extraction indicator:
c             -1 - value not extracted due to error
c              0 - value not extracted due to missing value
c              1 - value extracted
c     isignif - number of significant figures in returned value




       call position(jj,8,2,21,0,'99\0',9,2,23,0,'99\0',
     * 13,0,0,0,'\0',0,0,time,ihere,iheadsig(3))

c******************************************************************
c latitude:  hemisphere (30:30)
c            degrees (31:32)
c            minutes (33:38)
c            error code 1 for degrees,2 for minutes, 11 for seconds
c*********************************************************************

       call position(jj,1,2,31,0,'\0',2,5,33,0,'\0',
     * 11,0,0,0,'\0',1,30,rlat,ihere,iheadsig(1))
 
c*********************************************************************
c longitude:  hemisphere (44:44) itype0 = 1
c             degrees    (45:47)
c             minutess   (48:53)
c             error code 3 for degrees,4 for minutes, 12 for seconds
c*********************************************************************

       call position(jj,3,3,45,0,'\0',4,6,48,0,'\0',
     * 12,0,0,0,'\0',1,44,rlon,ihere,iheadsig(2))

c*****************************************************************
c [10] Water Depth (61:66)         
c*****************************************************************
          
       call writeconv(0,10,temp,depth,61,6,ihere,jj,bmiss,bmiss,
     * '999999\0',isignif,maxlevel,maxcalc,-1,0,0,0,0.)

c*******************************************************************
c Header Flags
c   date and time: byte 71 - assigned flag -5
c   latitude:  byte 72 - assigned flag -1
c   longitude: byte 73 - assigned flag -3
c   bottom depth: byte 74

c Flags are:
c   0 = no QC performed
c   1 = element correct
c   2 = inconsistent with statistics
c   3 = questionable
c   4 = bad
c   5 = changed (interpolated after QC)
c   9 = missing value

c origflag:
c     ihere - set to 2 if user defined flag value is to be used
c             otherwise, 1 denotes value read in, zero denotes
c             no value read in, -1 denotes error encountered
c             attempting to read
c     jj - sequential station number
c     nstart - starting position for flag
c     nchar - number of characters
c     ntotflag - total number of flags for this station
c     iflag - 1 : parameter of flag
c             2 : depth of flag
c             3 : flag value
c     nout - number of values of flag which need not be recorded
c     iout - values of flag which need not be recorded
c     noutmax - maximum number of flag values which need not be recorded
c     nparm - parameter recorded in array: user defined
c     nlevel - the depth recorded in array: user defined
c     nval - the character recorded in array: user defined if ihere=2


c*******************************************************************

c        if (record(68:70) .eq. 'QC=') then
c         call origflag(ihere,jj,71,1,ntotflag,iflag,nfout,ifout,
c     * nfoutmax, 0,-5,nval)
c         call origflag(ihere,jj,72,1,ntotflag,iflag,nfout,ifout,
c     * nfoutmax, 0,-1,nval)
c         call origflag(ihere,jj,73,1,ntotflag,iflag,nfout,ifout,
c     * nfoutmax, 0,-3,nval)
c        endif

      endif

c*******************************************************************
c Convert platform to OCL code
c    shipcheck:
c    irecnum(2) - starting array number for ship codes
c    irecnum(3) - number of existing ship codes
c    platsave - present profile ship code
c    ncode - OCL ship code
c
c*******************************************************************

        ncode = 0

        plat='  '
        plat=dplat
        ccc = crui
        cc =  dcc

        if ( plat .ne. '  ' .and. plat .ne. 'XX' ) then
         if ( plat.eq.'BV' .and. ccc .eq. '90') plat = 'VC'
         if ( plat.eq.'CR' .and. ccc .eq. '90') plat = 'MU'
         if ( plat.eq.'X2' .and. ccc .eq. '79') ccc = '76'

         platsave= ccc//plat//'\0'
         

         call shipcheck(irecnum(2),irecnum(3),platsave,ncode)
c         if (jj.eq.1) then 
c         print *, 'cc, plat, platsave, ncode =', cc, '  ', 
c     *        plat, '  ',platsave, '  ',ncode
c         endif		 
         if ( ncode .gt. 0 ) then
          dcode = ncode
          call findsignif(idsignif,0,dcode)
          call writeconv(0,3,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     *  '\0',isignif,maxlevel,maxcalc,-1,0,0,idsignif,dcode)
         endif
        endif
		  

c*****************************************************************
c STORE ORIGINATORS CRUISE CODE 
c*************************************************************
C     CRUISECON TAKES A COUNTRY CODE AND A CRUISE CODE AND COMBINES
C     THEM TO CREAT A UNIQUE CODE.  THE LAST 6 DIGITS ARE THE CRUISE
C     CODE, THE 1,000,000 PLACE ON UP IS THE COUNTRY CODE NUMBER
c     cc - country code
c     icruise - cruise code
c     icnum - combined integer code

         icruise = icruisex

c         print *, icruise, icruisex, icruiselast, jj
         if (icruise .ne. icruiselast) then
          icruiselast = icruise
	     
c         call metapi(piname,ipi)
 
c         if (origc(1:5).ne.'00000' .or. origc(1:5).ne.'     ')then 
           call cruisecon(cc,icruise,icrcon)
c           call origcrec(cc,icruise,0,0,origc,ifnum(1))

	       call writecmask(icrcon,origc(1:15)//'\0',ifnum(1))

		   if ( ipi .ne. 0 ) then
           call writetomask3(icrcon,idum,ifnum(4),ipi,0)  
	       endif
c pinum,param_num (0 = all parms)
c entire data set; 1=temperature data only; 2=salinity data only, etc.
c         call addCend(origc,15,1)
c         call writecmask(icrcon,origc,ifnum(1))


c         endif
         endif

c*****************************************************************
c     S  E  C  O  N  D  A  R  Y     H  E  A  D  E  R  S
c*****************************************************************
c extracti:
c   jj - profile number
c   ierr - error code for parameter
c   nchar - number of characters to extract
c   nstart - starting position of value in global array
c   isig - number of significant figures in value 
c   cmiss - character missing value marker
c   value - extracted value
c   ihere -  extraction indicator:
c            -1 - not extracted due to error
c             0 - not extracted due to missing value
c             1 - value extracted 
c*************************************************************
c     [1] Accession number
c*************************************************************
          
      call writeconv(0,1,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     *         '\0',isignif,maxlevel,maxcalc,-1,0,0,isiga,xaccess)
          
c*************************************************************
c     [2] Project
c*************************************************************
          
      rrproj = rproj
	  if (rrproj .gt. 0.)then
     	call writeconv(0,2,temp,depth,0,0,ihere,
     *     jj,bmiss,bmiss,'\0',isignif,maxlevel,maxcalc,
     *     -1,0,0,3,rproj)
	  endif
          
c*************************************************************
c     [4] Institute 
c*************************************************************
          
      rrinst = rinst

c      if (rrinst .gt. 0.)then
       call findsignif(isig,0,rrinst) 
       call writeconv(0,4,temp,depth,0,0,ihere,
     *     jj,bmiss,bmiss,'\0',isignif,maxlevel,maxcalc,
     *     -1,0,0,isig,rrinst)
c      endif
          
c*************************************************************
c     [6] Station number (OCL, SET TO ZERO!)
c*************************************************************
          
      call writeconv(0,6,temp,depth,0,0,ihere,
     *     jj,bmiss,bmiss,'\0',isignif,maxlevel,maxcalc,
     *     -1,0,0,1,0.)
          
c*************************************************************
c     [8] Depth Precision (1) - set to zero
c*************************************************************
          
      call writeconv(0,8,temp,depth,0,0,ihere,
     *     jj,bmiss,bmiss,'\0',isignif,maxlevel,maxcalc,
     *     -1,0,0,0,0.)

          
c*************************************************************
c [29] TS probe - Unknown CTD         
c*****************************************************************

c    The instrument codes
c Use 4 for ctd and 7 for bottle

	   call writeconv(0,29,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     * '\0',isignif,maxlevel,maxcalc,-1,0,0,1,4.)

c      CTD type UNKNOWN


       if (rt.ne.0) then
       call findsignif(isig,0,rt) 
       call writeconv(0,5,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     * '\0',isignif,maxlevel,maxcalc,-4,0,1,isig,rt)
	   endif 

       if (rs.ne.0) then
	   call findsignif(isig,0,rs) 
	   call writeconv(0,5,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     * '\0',isignif,maxlevel,maxcalc,-4,0,2,isig,rs)
       endif

       if (ro.ne.0) then
       call findsignif(isig,0,ro) 
	   call writeconv(0,5,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     * '\0',isignif,maxlevel,maxcalc,-4,0,3,isig,ro)
		endif	


c   Nitrite + Nitrate
       
c       call findsignif(isig,0,1.) 
c       call writeconv(0,23,temp,depth,0,0,ihere,jj,bmiss,bmiss,
c     * '\0',isignif,maxlevel,maxcalc,-4,0,0,isig,0.)


       	if ( record(1:9) .eq. '* ** Vent' .and. 
     *       record(22:23).ne.'SB') then 
c          print *, 'aaaa', record
	      if (record(11:15) .eq. 'force') then
          print *, 'rrr', record(22:23)
c       WIND FORCE [19] knots
          call writeconv(2,19,temp,depth,22,2,ihere,jj,bmiss,bmiss,
     * ' \0',isignif,maxlevel,maxcalc,-1,0,0,0,0.) 
          endif

          if (record(11:19) .eq. 'direction')then
           print *, 'ssss', record(22:24)
c       WIND DIRECTION [21] knots
          call writeconv(2,21,temp,depth,22,3,ihere,jj,bmiss,bmiss,
     * ' \0',isignif,maxlevel,maxcalc,-1,0,0,0,0.) 
          endif     


	    endif


c      [28] Cloud Cover

       if ( record(1:15) .eq. '* ** Nebulosite' .and. 
     *       record(18:21) .ne. 'nuit') then 
          print *, 'xxxx', record(18:18)
          if (record(18:18) .ne. 'o') then
		  call writeconv(0,19,temp,depth,18,1,ihere,jj,bmiss,bmiss,
     * ' \0',isignif,maxlevel,maxcalc,-1,0,0,0,0.) 
          endif
          endif


c      [18] Sea State

       if ( record(1:8) .eq. '* ** Mer') then
 		 print *, 'pppp', record(11:20)
	     if ( record(11:16) .eq. 'Agitee') then
c    Large Seas
         call writeconv(0,18,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     * ' \0',isignif,maxlevel,maxcalc,-1,0,0,1,7.) 
         elseif ( record(11:20) .eq. 'Peu agitee') then
c    Moderate Seas
         call writeconv(0,18,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     * ' \0',isignif,maxlevel,maxcalc,-1,0,0,1,4.) 
         elseif ( record(11:15) .eq. 'Belle'.or.
     *         record(11:15) .eq. 'belle') then
c    Calm Seas
         call writeconv(0,18,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     * ' \0',isignif,maxlevel,maxcalc,-1,0,0,1,0.) 
      endif 
	  endif	

      if ( record(1:13) .eq. '* ** Pression' ) then
c     [23] Barometric pressure
       call writeconv(0,23,temp,depth,19,6,ihere,jj,bmiss,bmiss,
     * '       \0',isignif,maxlevel,maxcalc,-1,0,0,0,0.)
      endif

      if ( record(1:19) .eq. '* ** Temperature de' ) then
c     [24]  Air Temperature
       call writeconv(0,24,temp,depth,28,4,ihere,jj,bmiss,bmiss,
     * '     \0',isignif,maxlevel,maxcalc,-1,0,0,0,0.)
      endif      

c*******************************************************************
c NB list the number of parameters
c lines lists the number of data lines for each profile
c*************************************************************

        if ( record(2:3) .eq. 'NB') 
     *  call extracti(jj,32,2,16,isig,'\0',nb,ihere)
        
        if ( record(26:30) .eq. 'LINES') 
     *  call extracti(jj,33,5,32,isig,'\0',lines,ihere)

c******************************************************************
c DATA 
c  NB = number of parameters
c  variable length for parameters based on formula:
c       bp(p) = nlen(1)+..+nlen(p-1)+p
c
c*************************************************************
c Identify variables in the profiles
c read parameter codes and names
c pmiss= parameter missing value
c**************************************************************

        iresultc =0
        iresultf =0
        iresult =0
        iresultn=0
        iresultp=0

c	     irs =0
c         irsn=0
c         irscl=0
c         irsf=0
c         irsp=0

        do 132 ipr = 1,npval

         if(parn(ipr) .eq. 'PRES') then

          if(record(11:14) .eq. parn(ipr)) then
           ival=ival+1
           itemp(ival) = ipval(ipr)
           itempu(ival)=iunit(ipr)
           call extract(jj,135,7,73,isig,0,'\0',pmiss(ival),ihere)
c          print *, 'ival,ipr',ival, ipr, '  ', record(2:5)
          endif

         elseif(parn(ipr) .ne. 'PRES') then

          if(parn(ipr) .eq. record(2:5) .and. 
     *       record(1:1) .eq. '*') then
           ival=ival+1
           itemp(ival) = ipval(ipr)
           itempu(ival)=iunit(ipr)
           call extract(jj,135,7,73,isig,0,'\0',pmiss(ival),ihere) 
c           print *, 'ival,ipr',ival, ipr, '  ', record(2:5)

         endif
c       end of if(parn(ipr) .eq. 'PRES') 
          endif
c       end of  if(parn(ipr) .eq. record(2:5)

 132      continue

c USE DOX1 whenever available

c Find the position that contains DOX2 DOX3 or DOXY

		  if (record(2:5) .eq. 'DOX2' .or. record(2:5) .eq. 'DOX3'
     *         .or. record(2:5) .eq. 'DOXY' ) then

 
		  if (irs.ne. 1) then
		  iresult = 1
	      else
          iresult = 2
          ipostdox = 44
		  endif
		  
          elseif (record(2:5) .eq. 'DOX1') then

          if (iresult.ne.1) then
		  irs = 1
		  else
	      irs = 1
          ipostdox = 44
          endif
          
 		  endif
c       end of  if (record(2:5) .eq. 'DOX2'   


c Find the position that contains DOX2 DOX3 or DOXY

		  if (record(2:5) .eq. 'NTRA' .or. record(2:5) .eq. 'NTAW'
     *         ) then


		  if (irsn.ne. 1) then
		  iresultn = 1
	      else
          iresultn = 2
          ipostdn = 44
		  endif
c USE nitrate + nitrite whenever present		  
          elseif (record(2:5) .eq. 'NTRZ' .or. 
     *         record(2:5) .eq. 'NTZW') then
          if (iresultn.ne.1) then
		  irsn = 1
		  else
	      irsn = 1
          ipostdn = 44
          endif
		  
          
 		  endif
c       end of  if ( record(2:5) .eq. 'NTRI' 



		  if (record(2:5) .eq. 'PHEA') then


		  if (irsp.ne. 1) then
		  iresultp = 1
	      else
          iresultp = 2
          ipostdp = 44
		  endif
c USE nitrate + nitrite whenever present		  
          elseif (record(2:5) .eq. 'PHEO' .or. 
     *      record(2:5) .eq. 'PHTP') then
          if (iresultp.ne.1) then
		  irsp = 1
		  else
	      irsp = 1
          ipostdp = 44
          endif
		  
          
 		  endif
c       end of  if ( record(2:5) .eq. 'NTRI' 


          if (record(2:5) .eq. 'FLU2' .or. record(2:5) .eq. 'FLUO' 
     *           .or. record(2:5) .eq. 'FLU1') then

          if (irsf.ne. 1) then
		  iresultf = 1
	      else
          iresultf = 2
          ipostdf = 44
		  endif

c           print *,'1,irsf, ipostdf, iresultf=', irsf, ipostdf, irsultf
c USE chlorophyll whenever present		  
          elseif (record(2:5) .eq. 'CPHL' .or. record(2:5) .eq. 'CHLT'
     *     .or. record(2:5) .eq. 'CPH2' .or. record(2:5) .eq. 'CH1T' 
     *      .or. record(2:5) .eq. 'CPH1' ) then
		  
          if (iresultf.ne.1) then
		  irsf = 1
		  else
	      irsf = 1
          ipostdf = 44
          endif
           
c          print *,'2,irsf, ipostdf, iresultf=', irsf, ipostdf, irsultf

	      if (record(2:5) .eq. 'CPH2' .or. record(2:5) .eq. 'CPH1' 
     *         .or. record(2:5) .eq. 'CPHL') then

	      if (irscl.ne. 1) then
		  iresultc = 1
	      else
          iresultc = 2
          ipostdc = 44
		  endif

c          print *,'1,irscl, ipostdc, iresultc=', irscl, ipostdc,iresultc
c USE chlorophyll instead of chlorophyll-a whenever present		  
          elseif (record(2:5) .eq. 'CHLT'
     *     .or. record(2:5) .eq. 'CH1T') then
		  if (iresultc.ne.1) then
		  irscl = 1
		  else
	      irscl = 1
          ipostdc = 44
          endif
c          print *,'2,irscl, ipostdc, iresultc=', irscl, ipostdc,iresultc
          endif
c         end of if (record(2:5) .eq. 'CPH2' 
          

 		  endif
c         end of if (record(2:5) .eq. 'FLU2'



c         print *,'4,irscl=',irscl
c	     print *,'4,irsf=',irsf
c*************************************************************
c begin data loop - skip header line then read data
c nb + 1 to take into accont flags
c icomma(parameter,1) = number of bytes
c icomma(parameter,2) = starting position for value
c*************************************************************

        if (record(1:9) .ne. '*PRES SEA' .and. record(1:5)
     *      .eq. '*PRES')then

         if ( nb .ne. ival ) then
          write(6,*) 'value mismatch'
          call extractc(iend,1,carray)
          write(6,*) carray(1:iend)
          write(6,*) 'nb',nb,ival
          ival=nb
         endif
         do 60 kk = 1, lines      
          call conslate(iend,1)
          call conread(ifn,1,0,iend)

          if (iend .gt. 0)then
           call extractc(iend,1,record)
           if (record(1:6).eq.'-999.9'.or. record(1:5).eq.'-99.9' .or.
     *      record(3:8).eq.'-999.9' .or. record(1:6).eq.'9999.9') then 
            ifirst=2      
            ival= 0
            return
           endif                
           call spacefind(iend,maxparm,ncomma,icomma)
	      if (jj.eq.1) then
c          print *, 'ncomma=', ncomma
c          print *, 'icomma=', icomma
	      endif
          else
           goto 50
          endif

c*************************************************************

          n = nlevels + 1
          nx= n
          indepth=0
    
          if ( n .le. maxlevel ) then
           np=0
           ic=n
          else
           call overmax(maxlevel,numeach(1),n,0,ic,np)
          endif

          do 505 n22=1,nb

           iflagpos=icomma(ncomma,1)+n22-1
           call extracti(jj,0,1,iflagpos,isigf,'\0',iflagx,ihere) 
           if(itemp(n22) .gt. 0 .and. iflagx .ne. 9 ) then

c*************************************************************
c READ DATA
c indepth used to only write to file profiles with data
c*************************************************************
      
           call extractc(icomma(n22,2),icomma(n22,1),record)
	      if (deb.eq.1) then
		  print *,record(1:42)
	      endif


           if (ipostdox .eq. 44) then	       
	       itemp(ipostdox) = 99
           ipostdox = 0
	       endif

	       if (ipostdn .eq. 44) then	       
	       itemp(ipostdn) = 99
           ipostdn = 0
	       endif

	       if (ipostdc .eq. 44) then	       
	       itemp(ipostdc) = 99
           ipostdn = 0
	       endif

	       if (ipostdf .eq. 44) then	       
	       itemp(ipostdf) = 99
           ipostdf = 0
	       endif

	       if (ipostdp .eq. 44) then	       
	       itemp(ipostdp) = 99
           ipostdp = 0
	       endif

           if (itemp(n22) .ne. 99) then
           call writeconv(itempu(n22),n,temp,depth,icomma(n22,1),
     *     icomma(n22,2),ihere,jj,pmiss(n22),bmiss,"\0",
     *     isignif,maxlevel,maxcalc,itemp(n22),0,0,0,0.)
 	
           if (irscl.ne.1.and.itemp(n22).eq.11) then
c           print *, '3,irscl =', irscl
c      Chlorophyll-A [11] needs variable second header 17
           call writeconv(0,17,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     *       '\0',isignif,maxlevel,maxcalc,-4,0,11,1,1.)
           endif

           if (irsf.ne.1.and.itemp(n22).eq.11) then
c      use  Fluorometer uncalibrated if used as chlorophyll [11]
c            print *, '3,irsf =', irsf
           call writeconv(0,16,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     *       '\0',isignif,maxlevel,maxcalc,-4,0,11,1,1.)
           endif


           if (irsp.ne.1.and.itemp(n22).eq.12) then
c      Phaeophytin-A [12] needs variable second header 17
c         
           call writeconv(0,17,temp,depth,0,0,ihere,jj,bmiss,bmiss,
     *       '\0',isignif,maxlevel,maxcalc,-4,0,12,1,1.)
           endif

           
	       endif


           
          
           if (ihere .gt. 0 .and.
     *      itemp(n22) .ne. 25 .and. itemp(n22) .ne. 99)
     *       indepth = indepth + 1

c*************************************************************
c Depth
c convert from pressure to depth
c*************************************************************

          if (temp(n,25) .gt. bmiss) then
           depth(n)= fdepth(temp(n,25),rlat)
           call writeconv(0,8,temp,depth,0,0,ihere,jj,bmiss,0.,
     *     '\0',isignif,maxlevel,maxcalc,-1,0,0,1,1.)

c remove duplicate depths and inversions

           if (n .gt. 1 .and. depth(n) .le. depth(n-1)) then
            n= n-1
           endif

          endif

c*************************************************************
c Set position for reading flags (after last value is read)
c*************************************************************

           if (n22 .eq. nb)then
            is=icomma(n22+1,1) 
            is=is-1
c            do n23=1,nb
c             call origflag(ihere,jj,is+n23,1,ntotflag,iflag,nfout,
c     *       ifout,nfoutmax,itemp(n23),n,nval)
c            enddo

           endif

          endif



 505     continue

c*************************************************************

          if (indepth.gt.0 .and. nx.eq.n) nlevels= nlevels+1

 60      continue   

        endif  

 50   continue

c******************************************************************

      return
      end
      

      subroutine instcodes(headname,irtc,irsc,iroc,maxvalue,
     *    npval,g3parm)
	  parameter(ifn6=71)
      character*13 headname(maxvalue)
	  dimension irtc(maxvalue),irsc(maxvalue),iroc(maxvalue)
	  character*80 parrec 
      character*(*) g3parm

c open file which contains parameter names

      open(ifn6,file=g3parm,status='old',form='formatted')

      do 77 ip = 1,maxvalue
c	   print *, ip
       call clearstring(headname(ip),13)    
	    read(ifn6,'(a80)',end=78 )parrec
		headname(ip)=parrec(1:13)
		read(parrec(16:19),'(i4)')ipval
       irtc(ip) = ipval
	   read(parrec(22:25),'(i4)')ipval
       irsc(ip) = ipval
       read(parrec(29:32),'(i4)')ipval
       iroc(ip)=ipval
       npval=npval+1
 77   continue
 78   continue

      close(ifn6)
	   
	   return 

       end 




      subroutine piorgcodes(piname,ipicode,iorgcode,iind,
     *   maxvalue,npval,g3parm)

      parameter(ifn6=61)
      dimension ipicode(maxvalue),iorgcode(maxvalue), iind(maxvalue)
      character*80 parrec
      character*40 piname(maxvalue)
      character*(*) g3parm

c open file which contains parameter names

      open(ifn6,file=g3parm,status='old',form='formatted')

c read parameter codes from file
       
      npval=0
      do 77 ip = 1,maxvalue
       call clearstring(piname(ip),40)
       read(ifn6,'(a80)',end=78 )parrec
c	   print *, parrec
       piname(ip)=parrec(1:40)
c	   print *, piname(ip)
       read(parrec(41:44),'(i4)')ipval
       ipicode(ip) = ipval
	   read(parrec(48:48),'(i1)')ipval
       iind(ip) = ipval
       read(parrec(73:76),'(i4)')ipval
       iorgcode(ip)=ipval
       npval=npval+1
 77   continue
 78   continue

      close(ifn6)

      return
      end


      subroutine projcodes(projname,ircode,maxvalue,npval,g3parm)

      parameter(ifn6=63)
      dimension ircode(maxvalue)
      character*80 parrec
      character*28 projname(maxvalue)
      character*(*) g3parm

c open file which contains parameter names

      open(ifn6,file=g3parm,status='old',form='formatted')

c read parameter codes from file
       
      npval=0
      do 77 ip = 1,maxvalue
       call clearstring(projname(ip),28)
       read(ifn6,'(a80)',end=78 )parrec
c	   print *, parrec
       projname(ip)=parrec(1:28)
c	   print *, projname(ip)
	   read(parrec(39:43),'(i5)')ipval
       ircode(ip) = ipval
       npval=npval+1
 77   continue
 78   continue

      close(ifn6)

      return
      end







      subroutine parcodes(itemp,iunit,parn,maxvalue,npval,g3parm)

      parameter(ifn6=51)
      dimension itemp(maxvalue),iunit(maxvalue)
      character*80 parrec
      character*4 parn(maxvalue)
      character*(*) g3parm

c open file which contains parameter names

      open(ifn6,file=g3parm,status='old',form='formatted')

c read parameter codes from file
       
      npval=0
      do 50 ip = 1,maxvalue
       call clearstring(parn(ip),4)
       itemp(ip)=0
       read(ifn6,'(a80)',end=55 )parrec
       parn(ip)=parrec(1:4)
       read(parrec(8:9),'(i2)')ipval
       itemp(ip) = ipval
       read(parrec(11:13),'(i3)')ipval
       iunit(ip)=ipval
       npval=npval+1
50    continue
55    continue

      close(ifn6)

      return
      end


