%%% this is a script, called by newday.prl, expecting two scripts to be called 
%%% first: "asetup" and "aflagit_setup"  (both written by adcptree.prl)

asetup; 
aflagit_setup; 

config.start_dd = 252.17505787;
config.end_dd = 252.618946759;
config.ddrange = config.end_dd - config.start_dd   ;

%now call 
[data, config] = agetmat(config);
if (~isempty(data))
  

  %%% (note that aflagit_setup sets up the flagging defaults in a structure
  %%% "pfc.cfg".  If we're running quick_adcp.py with automatic 
  %%% editing and want to override the defaults, write them in 
  %%% "override_flagit.m" as pfc.cfg.parameter = newdefault

   if exist('override_flagit.m','file')
      override_flagit
   end

   flagged = aflagit(data, config, pfc);

   pflags.yearbase = config.yearbase;
   pflags.dday = data.dday;
   pflags.flagged = flagged;
   pflags = setfield(pflags, 'flag', aflagit);

   flagfile = 'autoflagged.mat';
   fprintf('saving flags to %s\n',flagfile)
   eval(sprintf('save %s pflags',flagfile))

   flagfiles.name = flagfile;
end


%%% delete asc files and write with new suffix
if (exist('abottom_tmp.asc', 'file')),    delete('abottom_tmp.asc'), end
if (exist('abadbin_tmp.asc', 'file')),    delete('abadbin_tmp.asc'), end
if (exist('abadprf_tmp.asc', 'file')),    delete('abadprf_tmp.asc'), end

%%% fill them up again
alistit(flagfiles, '_tmp');
