#!/usr/bin/python

from netCDF4 import Dataset
import sys

try:
    print "Reading %s" % sys.argv[1]
    print "Writing %s.csv" % sys.argv[1]
except:
    print "usage: nc2csv.py filename.nc"
    sys.exit(1)

file = Dataset(sys.argv[1], 'r')

data, vals = {}, 0

for v in file.variables: 
    data[v] = []
    for val in file.variables[v]:
        data[v].append(val.tolist())
    data[v] = (str(data[v][0])).translate(None, '[]').split(',')
    if len(data[v]) > vals: vals = len(data[v])


# write csv
f = open(sys.argv[1] + '.csv', 'wb')

f.write(','.join(data.keys()) + '\n')

cur = 0
while cur < vals:
    row = []
    for key in data:
        try:  row.append(data[key][cur])
        except:  row.append(data[key][0])
    f.write(','.join(row) + '\n')
    cur += 1

f.close()