CDF       
      time     
timeSeries        depth            Q   
gts_ingest        true   ioos_ingest       true   infoUrl       http://data.gcoos.org      wmo_platform_code                Conventions       ECF-1.7, ACDD-1.3, IOOS-1.2, GCMD Earth Science Keywords Version 9.1.5      id        $gcoos_ioos-station-DISL-KATA_2018_05   license       Creative Common (CC) 0     naming_authority      	org.gcoos      
references        http://data.gcoos.org      standard_name_vocabulary      CF Standard Name Table v73     summary       Z2018/05 time series data for ioos-station-DISL-KATA platform served via GCOOS Data Portal.     cdm_timeseries_variables      platform   contributor_email         lhu@disl.org   contributor_name      DISL   contributor_role      
originator     contributor_role_vocabulary       0https://vocab.nerc.ac.uk/collection/G04/current/   contributor_url       https://arcos.disl.org/    creator_name      Felimon Gayanilo   creator_institution       Texas AM Corpus Christi    creator_address       6300 Ocean Drive   creator_city      Corpus Christi     
creator_state         TX     creator_postalcode        78412      creator_country       USA    
creator_email         felimon.gayanilo@tamucc.edu    
creator_phone         (361) 825-3454     creator_sector        academic   creator_type      person     creator_url       $http://orcid.org/0000-0003-0520-5737   institution       5Gulf of Mexico Coastal Ocean Observing System (GCOOS)      publisher_name        5Gulf of Mexico Coastal Ocean Observing System (GCOOS)      publisher_institution         5Gulf of Mexico Coastal Ocean Observing System (GCOOS)      publisher_address         6300 Ocean Drive   publisher_city        Corpus Christi     publisher_state       TX     publisher_postalcode      78412      publisher_country         USA    publisher_email       data@gcoos.org     publisher_phone       (361) 825-3454     publisher_type        institution    
publisher_url         https://gcoos.org      ncei_template_version         /NCEI_NetCDF_TimeSeries_Orthogonal_Template_v2.0    history       
V1 2020-12-24      source        $SFTP push, OGC SOS/WAF pull to GCOOS   processing_level      1Data ingested as provided and QC following QARTOD      comment       2Data generated from GCOOS near-realtime repository     date_created      
2020-12-24     project       5Gulf of Mexico Coastal Ocean Observing System (GCOOS)      geospatial_bounds_crs         	EPSG:4979      geospatial_bounds_vertical_crs        	EPSG:4979      sea_name      Gulf of Mexico     program       &NOAA Integrated Ocean Observing System     geospatial_lat_units      
degrees_north      geospatial_lon_units      degrees_east   geospatial_vertical_units         	EPSG:4979      
date_modified         
2020-12-24     date_metadata_modified        
2020-12-24     product_version       Ver. 1.0   platform      ioos-station-DISL-KATA     platform_id       KATA1      
platform_name         Katrina Cut, AL    platform_vocabulary       #https://mmisw.org/ont/ioos/platform    instrument_vocabulary         FCF Standard Name Table v73, GCMD Earth Science Keywords. Version 9.1.5     acknowledgement       Financial support from NOAA Integrated Ocean Observing System; Texas A&M University and Harte Research Institute for the development and maintenance of the data portal    geospatial_lat_min        @>B䎊   geospatial_lat_max        @>B䎊   geospatial_lon_min        V
n.   geospatial_lon_max        V
n.   geospatial_bounds         POINT (30.2583 -88.2131)   geospatial_vertical_min                  geospatial_vertical_max                  geospatial_vertical_positive      down   title         6Data for ioos-station-DISL-KATA for the period 2018/05     
instrument       Water level sensor - Water temperature probe - Anemometer - Acoustic Doppler Current Profiler - Electric conductivity probe - Barometric pressure sensor - Air temperature probe - Spectroflourometer - DO sensor - Humidity probe - Turbidity optical sensor - Dew point transmitter      keywords     MEARTH SCIENCE > OCEANS > COASTAL PROCESSES > SEA SURFACE HEIGHT, EARTH SCIENCE > OCEANS > OCEAN TEMPERATURE > WATER TEMPERATURE, EARTH SCIENCE > ATMOSPHERE > ATMOSPHERIC WINDS > LOCAL WINDS, EARTH SCIENCE > OCEANS > OCEAN CIRCULATION > OCEAN CURRENTS, EARTH SCIENCE > OCEANS > SALINITY/DENSITY  > SALINITY, EARTH SCIENCE > ATMOSPHERE > ATMOSPHERIC PRESSURE, EARTH SCIENCE > ATMOSPHERE > ATMOSPHERIC TEMPERATURE, EARTH SCIENCE > OCEANS > OCEAN CHEMISTRY > CHLOROPHYLL, EARTH SCIENCE > TERRESTRIAL HYDROSPHERE > WATER QUALITY/WATER CHEMISTRY > OCEAN CHEMISTRY > GASES > DISSOLVED OXYGEN, EARTH SCIENCE > ATMOSPHERE > ATMOSPHERIC WATER VAPOR > WATER VAPOR INDICATORS > HUMIDITY > RELATIVE HUMIDITY, EARTH SCIENCE > OCEANS > OCEAN OPTICS > TURBIDITY, EARTH SCIENCE > ATMOSPHERE > ATMOSPHERIC TEMPERATURE > SURFACE TEMPERATURE > DEW POINT TEMPERATURE      time_coverage_start       2018-05-01 00:00:00    time_coverage_end         2018-05-31 23:57:00.000003     time_coverage_duration        P30DT23H57M    time_coverage_resolution      PT30M      
cdm_data_type         
TimeSeries     featureType       
timeSeries           time                
_FillValue        Ç       	long_name         Time   
standard_name         time   units         %seconds since 1970-01-01 00:00:00 UTC      calendar      julian     axis      T      
missing_value         Ç         X8    lat              	long_name         Latitude   
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min         ´     	valid_max         B            lon              	long_name         	Longitude      
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         4     	valid_max         C4             platform               	ncei_code         147F   	ioos_code         ioos-station-DISL-KATA     cf_role       
timeseries_id      	long_name         Katrina Cut, AL        $   crs              grid_mapping_name         latitude_longitude     	epsg_code         	EPSG:4326      semi_major_axis        aR   inverse_flattening        @rtm       (   depth                  
_FillValue        <    	long_name         Depth      
standard_name         depth      units         m      axis      Z      positive      down   
missing_value         <        ,   water_level_instrument_1             	long_name         Water level sensor     
vocabulary        #GCMD Science Keywords Version 9.1.5        0   water_temperature_instrument_1               	long_name         Water temperature probe    
vocabulary        #GCMD Science Keywords Version 9.1.5        4   wind_instrument_1                	long_name         
Anemometer     
vocabulary        #GCMD Science Keywords Version 9.1.5        8   ocean_currents_instrument_1              	long_name         !Acoustic Doppler Current Profiler      
vocabulary        #GCMD Science Keywords Version 9.1.5        <   salinity_instrument_1                	long_name         Electric conductivity probe    
vocabulary        #GCMD Science Keywords Version 9.1.5        @   air_pressure_instrument_1                	long_name         Barometric pressure sensor     
vocabulary        #GCMD Science Keywords Version 9.1.5        D   air_temperature_instrument_1             	long_name         Air temperature probe      
vocabulary        #GCMD Science Keywords Version 9.1.5        H   chlorophyll_instrument_1             	long_name         Spectroflourometer     
vocabulary        #GCMD Science Keywords Version 9.1.5        L   oxygen_instrument_1              	long_name         	DO sensor      
vocabulary        #GCMD Science Keywords Version 9.1.5        P   relative_humidity_instrument_1               	long_name         Humidity probe     
vocabulary        #GCMD Science Keywords Version 9.1.5        T   turbidity_instrument_1               	long_name         Turbidity optical sensor   
vocabulary        #GCMD Science Keywords Version 9.1.5        X   dew_point_instrument_1               	long_name         Dew point transmitter      
vocabulary        #GCMD Science Keywords Version 9.1.5        \   sea_surface_height_1                
_FillValue        <    source        Local Data Node    
gts_ingest        true   	long_name         sea surface height     
standard_name         sea_surface_height     	ncei_name         sea_surface_height     units         m      
missing_value         <    	valid_min                	valid_max         A      coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        Jhttps://mmisw.org/ont/cf/parameter/sea_surface_height_above_mean_sea_level     cell_methods      !time: point lat: point lon: point      ancillary_variables       water_level_instrument_1 platform water_level_qc_1_agg water_level_qc_1_gap water_level_qc_1_syn water_level_qc_1_loc water_level_qc_1_rng water_level_qc_1_clm water_level_qc_1_spk water_level_qc_1_rtc water_level_qc_1_flt     platform      platform   
instrument        water_level_instrument_1   standard_name_url         Jhttps://mmisw.org/ont/cf/parameter/sea_surface_height_above_mean_sea_level       , `   water_level_qc_1_agg             	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        water_level_1_agg      
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , |   water_level_qc_1_gap             	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        water_level_1_gap      
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , B   water_level_qc_1_syn             	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        water_level_1_syn      
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , n   water_level_qc_1_loc             	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        water_level_1_loc      
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    water_level_qc_1_rng             	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        water_level_1_rng      
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    water_level_qc_1_clm             	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        water_level_1_clm      
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    water_level_qc_1_spk             	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        water_level_1_spk      
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , $   water_level_qc_1_rtc             	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        water_level_1_rtc      
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , K@   water_level_qc_1_flt             	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        water_level_1_flt      
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , w\   sea_surface_temperature_1                   
_FillValue        <    source        Local Data Node    
instrument        water_temperature_instrument_1     
gts_ingest        true   	long_name         sea surface temperature    
standard_name         sea_surface_temperature    	ncei_name         sea_surface_temperature    units         degree_Celsius     
missing_value         <    	valid_min               	valid_max         B     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        6https://mmisw.org/ont/ioos/parameter/water_temperature     cell_methods      !time: point lat: point lon: point      ancillary_variables      water_temperature_instrument_1 platform sea_surface_temp_qc_1_agg sea_surface_temp_qc_1_gap sea_surface_temp_qc_1_syn sea_surface_temp_qc_1_loc sea_surface_temp_qc_1_rng sea_surface_temp_qc_1_clm sea_surface_temp_qc_1_spk sea_surface_temp_qc_1_rtc sea_surface_temp_qc_1_flt      platform      platform   standard_name_url         8https://mmisw.org/ont/cf/parameter/sea_water_temperature     , x   sea_surface_temp_qc_1_agg                	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        sea_surface_temp_qc_1_agg      
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , ϔ   sea_surface_temp_qc_1_gap                	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        sea_surface_temp_qc_1_gap      
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        ,    sea_surface_temp_qc_1_syn                	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        sea_surface_temp_qc_1_syn      
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , '   sea_surface_temp_qc_1_loc                	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        sea_surface_temp_qc_1_loc      
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , S   sea_surface_temp_qc_1_rng                	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        sea_surface_temp_qc_1_rng      
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        ,    sea_surface_temp_qc_1_clm                	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        sea_surface_temp_qc_1_clm      
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        ,     sea_surface_temp_qc_1_spk                	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        sea_surface_temp_qc_1_spk      
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , <   sea_surface_temp_qc_1_rtc                	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        sea_surface_temp_qc_1_rtc      
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , X   sea_surface_temp_qc_1_flt                	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        sea_surface_temp_qc_1_flt      
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , 0t   wind_speed_1                
_FillValue        <    
instrument        wind_instrument_1      
gts_ingest        true   source        Local Data Node    	long_name         
wind speed     
standard_name         
wind_speed     	ncei_name         
wind_speed     units         m s-1      
missing_value         <    	valid_min                	valid_max         B     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        /https://mmisw.org/ont/ioos/parameter/wind_speed    cell_methods      !time: point lat: point lon: point      ancillary_variables       wind_instrument_1 platform wind_speed_1_agg wind_speed_1_gap wind_speed_1_syn wind_speed_1_loc wind_speed_1_rng wind_speed_1_clm wind_speed_1_spk wind_speed_1_rtc wind_speed_1_flt    platform      platform   standard_name_url         -https://mmisw.org/ont/cf/parameter/wind_speed        , \   wind_speed_1_agg             	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        wind_speed_1_agg   
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_speed_1_gap             	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        wind_speed_1_gap   
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_speed_1_syn             	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        wind_speed_1_syn   
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_speed_1_loc             	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        wind_speed_1_loc   
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 
    wind_speed_1_rng             	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        wind_speed_1_rng   
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 9   wind_speed_1_clm             	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        wind_speed_1_clm   
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , e8   wind_speed_1_spk             	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        wind_speed_1_spk   
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , T   wind_speed_1_rtc             	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        wind_speed_1_rtc   
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , p   wind_speed_1_flt             	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        wind_speed_1_flt   
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_direction_1                
_FillValue        <    
gts_ingest        true   
instrument        wind_instrument_1      source        Local Data Node    	long_name         wind direction     
standard_name         wind_to_direction      	ncei_name         wind_direction     units         degree     
missing_value         <    	valid_min                	valid_max         C    coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        6https://mmisw.org/ont/ioos/parameter/wind_to_direction     cell_methods      !time: point lat: point lon: point      ancillary_variables       wind_instrument_1 platform wind_dir_1_agg wind_dir_1_gap wind_dir_1_syn wind_dir_1_loc wind_dir_1_rng wind_dir_1_clm wind_dir_1_spk wind_dir_1_rtc wind_dir_1_flt      platform      platform   standard_name_url         4https://mmisw.org/ont/cf/parameter/wind_to_direction     ,    wind_dir_1_agg               	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        wind_dir_1_agg     
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , A   wind_dir_1_gap               	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        wind_dir_1_gap     
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , m   wind_dir_1_syn               	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        wind_dir_1_syn     
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_dir_1_loc               	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        wind_dir_1_loc     
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_dir_1_rng               	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        wind_dir_1_rng     
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 4   wind_dir_1_clm               	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        wind_dir_1_clm     
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , P   wind_dir_1_spk               	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        wind_dir_1_spk     
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , Jl   wind_dir_1_rtc               	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        wind_dir_1_rtc     
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , v   wind_dir_1_flt               	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        wind_dir_1_flt     
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_gust_1                 
_FillValue        <    
gts_ingest        true   
instrument        wind_instrument_1      source        Local Data Node    	long_name         	wind gust      
standard_name         wind_speed_of_gust     	ncei_name         	wind_gust      units         m s-1      
missing_value         <    	valid_min                	valid_max         B     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        .https://mmisw.org/ont/ioos/parameter/wind_gust     cell_methods      !time: point lat: point lon: point      ancillary_variables       wind_instrument_1 platform wind_gust_1_agg wind_gust_1_gap wind_gust_1_syn wind_gust_1_loc wind_gust_1_rng wind_gust_1_clm wind_gust_1_spk wind_gust_1_rtc wind_gust_1_flt     platform      platform   standard_name_url         5https://mmisw.org/ont/cf/parameter/wind_speed_of_gust        ,    wind_gust_1_agg              	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        wind_gust_1_agg    
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    wind_gust_1_gap              	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        wind_gust_1_gap    
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 	&   wind_gust_1_syn              	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        wind_gust_1_syn    
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 	S   wind_gust_1_loc              	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        wind_gust_1_loc    
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 	0   wind_gust_1_rng              	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        wind_gust_1_rng    
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 	L   wind_gust_1_clm              	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        wind_gust_1_clm    
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 	h   wind_gust_1_spk              	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        wind_gust_1_spk    
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 
   wind_gust_1_rtc              	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        wind_gust_1_rtc    
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 
/   wind_gust_1_flt              	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        wind_gust_1_flt    
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 
[   sea_water_speed_1                      
_FillValue        <    
instrument        ocean_currents_instrument_1    source        Local Data Node    
gts_ingest        true   	long_name         sea water speed    
standard_name         sea_water_speed    	ncei_name         sea_water_speed    units         cm s-1     
missing_value         <    	valid_min                	valid_max         C4     coordinates       time lat lon depth     coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        5https://mmisw.org/ont/ioos/parameter/current_velocity      cell_methods      .time: point lat: point lon: point depth: point     ancillary_variables      ocean_currents_instrument_1 platform sea_water_speed_qc_1_agg sea_water_speed_qc_1_gap sea_water_speed_qc_1_syn sea_water_speed_qc_1_loc sea_water_speed_qc_1_rng sea_water_speed_qc_1_clm sea_water_speed_qc_1_spk sea_water_speed_qc_1_rtc sea_water_speed_qc_1_flt      platform      platform   standard_name_url         2https://mmisw.org/ont/cf/parameter/sea_water_speed       , 
   sea_water_speed_qc_1_agg                	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        sea_water_speed_qc_1_agg   
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 
   sea_water_speed_qc_1_gap                	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        sea_water_speed_qc_1_gap   
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 
   sea_water_speed_qc_1_syn                	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        sea_water_speed_qc_1_syn   
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , ,   sea_water_speed_qc_1_loc                	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        sea_water_speed_qc_1_loc   
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 8H   sea_water_speed_qc_1_rng                	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        sea_water_speed_qc_1_rng   
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , dd   sea_water_speed_qc_1_clm                	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        sea_water_speed_qc_1_clm   
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        ,    sea_water_speed_qc_1_spk                	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        sea_water_speed_qc_1_spk   
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        ,    sea_water_speed_qc_1_rtc                	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        sea_water_speed_qc_1_rtc   
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        ,    sea_water_speed_qc_1_flt                	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        sea_water_speed_qc_1_flt   
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        ,    sea_water_direction_1                      
_FillValue        <    
instrument        ocean_currents_instrument_1    source        Local Data Node    
gts_ingest        true   	long_name         sea water to direction     
standard_name         sea_water_to_direction     	ncei_name         sea_water_direction    units         degree     
missing_value         <    	valid_min                	valid_max         C    coordinates       time lat lon depth     coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        9https://mmisw.org/ont/ioos/parameter/current_to_direction      cell_methods      .time: point lat: point lon: point depth: point     ancillary_variables      )ocean_currents_instrument_1 platform sea_water_direction_qc_1_agg sea_water_direction_qc_1_gap sea_water_direction_qc_1_syn sea_water_direction_qc_1_loc sea_water_direction_qc_1_rng sea_water_direction_qc_1_clm sea_water_direction_qc_1_spk sea_water_direction_qc_1_rtc sea_water_direction_qc_1_flt      platform      platform   standard_name_url         9https://mmisw.org/ont/cf/parameter/sea_water_to_direction        , @   sea_water_direction_qc_1_agg                	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        sea_water_direction_qc_1_agg   
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , m   sea_water_direction_qc_1_gap                	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        sea_water_direction_qc_1_gap   
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , (   sea_water_direction_qc_1_syn                	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        sea_water_direction_qc_1_syn   
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , D   sea_water_direction_qc_1_loc                	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        sea_water_direction_qc_1_loc   
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , `   sea_water_direction_qc_1_rng                	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        sea_water_direction_qc_1_rng   
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 
|   sea_water_direction_qc_1_clm                	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        sea_water_direction_qc_1_clm   
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 
I   sea_water_direction_qc_1_spk                	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        sea_water_direction_qc_1_spk   
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 
u   sea_water_direction_qc_1_rtc                	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        sea_water_direction_qc_1_rtc   
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 
   sea_water_direction_qc_1_flt                	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        sea_water_direction_qc_1_flt   
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , 
   upward_sea_water_velocity_1                    
_FillValue        <    
instrument        ocean_currents_instrument_1    source        Local Data Node    
gts_ingest        true   	long_name         upward sea water velocity      
standard_name         upward_sea_water_velocity      	ncei_name         upward_sea_water_velocity      units         cm s-1     
missing_value         <    	valid_min         z     	valid_max         B     coordinates       time lat lon depth     coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        5https://mmisw.org/ont/ioos/parameter/vertical_current      cell_methods      .time: point lat: point lon: point depth: point     ancillary_variables      _ocean_currents_instrument_1 platform sea_water_upward_velocity_qc_1_agg sea_water_upward_velocity_qc_1_gap sea_water_upward_velocity_qc_1_syn sea_water_upward_velocity_qc_1_loc sea_water_upward_velocity_qc_1_rng sea_water_upward_velocity_qc_1_clm sea_water_upward_velocity_qc_1_spk sea_water_upward_velocity_qc_1_rtc sea_water_upward_velocity_qc_1_flt    platform      platform   standard_name_url         <https://mmisw.org/ont/cf/parameter/upward_sea_water_velocity     , 
   "sea_water_upward_velocity_qc_1_agg                  	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        "sea_water_upward_velocity_qc_1_agg     
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , &$   "sea_water_upward_velocity_qc_1_gap                  	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        "sea_water_upward_velocity_qc_1_gap     
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , R@   "sea_water_upward_velocity_qc_1_syn                  	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        "sea_water_upward_velocity_qc_1_syn     
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , ~\   "sea_water_upward_velocity_qc_1_loc                  	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        "sea_water_upward_velocity_qc_1_loc     
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , x   "sea_water_upward_velocity_qc_1_rng                  	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        "sea_water_upward_velocity_qc_1_rng     
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , ֔   "sea_water_upward_velocity_qc_1_clm                  	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        "sea_water_upward_velocity_qc_1_clm     
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        ,    "sea_water_upward_velocity_qc_1_spk                  	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        "sea_water_upward_velocity_qc_1_spk     
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , .   "sea_water_upward_velocity_qc_1_rtc                  	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        "sea_water_upward_velocity_qc_1_rtc     
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        , Z   "sea_water_upward_velocity_qc_1_flt                  	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        "sea_water_upward_velocity_qc_1_flt     
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        .https://ioos.noaa.gov/ioos-in-action/currents/     units         1        ,    sea_water_practical_salinity_1                  
_FillValue        <    
gts_ingest        true   source        Local Data Node    	long_name         sea water practical salinity   
standard_name         sea_water_practical_salinity   	ncei_name         sea_water_practical_salinity   units         1e-3   
missing_value         <    	valid_min                	valid_max         BH     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        5https://mmisw.org/ont/cf/parameter/sea_water_salinity      cell_methods      !time: point lat: point lon: point      ancillary_variables       salinity_instrument_1 platform sal_qc_1_agg sal_qc_1_gap sal_qc_1_syn sal_qc_1_loc sal_qc_1_rng sal_qc_1_clm sal_qc_1_spk sal_qc_1_rtc sal_qc_1_flt    platform      platform   
instrument        salinity_instrument_1      standard_name_url         5https://mmisw.org/ont/cf/parameter/sea_water_salinity        ,     sal_qc_1_agg             	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        sal_qc_1_agg   
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , <   sal_qc_1_gap             	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        sal_qc_1_gap   
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , X   sal_qc_1_syn             	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        sal_qc_1_syn   
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , 7t   sal_qc_1_loc             	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        sal_qc_1_loc   
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , c   sal_qc_1_rng             	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        sal_qc_1_rng   
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        ,    sal_qc_1_clm             	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        sal_qc_1_clm   
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        ,    sal_qc_1_spk             	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        sal_qc_1_spk   
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        ,    sal_qc_1_rtc             	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        sal_qc_1_rtc   
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        ,     sal_qc_1_flt             	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        sal_qc_1_flt   
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        :https://ioos.noaa.gov/ioos-in-action/temperature-salinity/     units         1        , @    air_pressure_at_mean_sea_level_1                
_FillValue        <    
gts_ingest        true   source        Local Data Node    	long_name         air pressure at mean sea level     
standard_name         air_pressure_at_mean_sea_level     	ncei_name         air_pressure_at_mean_sea_level     units         mbar   
missing_value         <    	valid_min         DY    	valid_max         D    coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        1https://mmisw.org/ont/ioos/parameter/air_pressure      cell_methods      !time: point lat: point lon: point      ancillary_variables       air_pressure_instrument_1 platform air_pressure_qc_1_agg air_pressure_qc_1_gap air_pressure_qc_1_syn air_pressure_qc_1_loc air_pressure_qc_1_rng air_pressure_qc_1_clm air_pressure_qc_1_spk air_pressure_qc_1_rtc air_pressure_qc_1_flt   platform      platform   
instrument        air_pressure_instrument_1      standard_name_url         /https://mmisw.org/ont/cf/parameter/air_pressure      , l8   air_pressure_qc_1_agg                	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        air_pressure_qc_1_agg      
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , T   air_pressure_qc_1_gap                	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        air_pressure_qc_1_gap      
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , p   air_pressure_qc_1_syn                	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        air_pressure_qc_1_syn      
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    air_pressure_qc_1_loc                	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        air_pressure_qc_1_loc      
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    air_pressure_qc_1_rng                	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        air_pressure_qc_1_rng      
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , H   air_pressure_qc_1_clm                	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        air_pressure_qc_1_clm      
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , t   air_pressure_qc_1_spk                	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        air_pressure_qc_1_spk      
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    air_pressure_qc_1_rtc                	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        air_pressure_qc_1_rtc      
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    air_pressure_qc_1_flt                	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        air_pressure_qc_1_flt      
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 4   air_temperature_1                   
_FillValue        <    
gts_ingest        true   source        Local Data Node    	long_name         air temperature    
standard_name         air_temperature    	ncei_name         air_temperature    units         degree_Celsius     
missing_value         <    	valid_min               	valid_max         BH     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        4https://mmisw.org/ont/ioos/parameter/air_temperature   cell_methods      !time: point lat: point lon: point      ancillary_variables       air_temperature_instrument_1 platform air_temp_qc_1_agg air_temp_qc_1_gap air_temp_qc_1_syn air_temp_qc_1_loc air_temp_qc_1_rng air_temp_qc_1_clm air_temp_qc_1_spk air_temp_qc_1_rtc air_temp_qc_1_flt    platform      platform   
instrument        air_temperature_instrument_1   standard_name_url         2https://mmisw.org/ont/cf/parameter/air_temperature       , %P   air_temp_qc_1_agg                	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        air_temp_qc_1_agg      
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , Ql   air_temp_qc_1_gap                	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        air_temp_qc_1_gap      
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , }   air_temp_qc_1_syn                	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        air_temp_qc_1_syn      
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    air_temp_qc_1_loc                	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        air_temp_qc_1_loc      
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    air_temp_qc_1_rng                	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        air_temp_qc_1_rng      
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    air_temp_qc_1_clm                	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        air_temp_qc_1_clm      
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , -   air_temp_qc_1_spk                	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        air_temp_qc_1_spk      
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , Z   air_temp_qc_1_rtc                	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        air_temp_qc_1_rtc      
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 0   air_temp_qc_1_flt                	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        air_temp_qc_1_flt      
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , L   0mass_concentration_of_chlorophyll_in_sea_water_1                
_FillValue        <    source        Local Data Node    
gts_ingest        true   	long_name         .mass concentration of chlorophyll in sea water     
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     	ncei_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug L-1     
missing_value         <    	valid_min                	valid_max         BH     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        Qhttps://mmisw.org/ont/cf/parameter/mass_concentration_of_chlorophyll_in_sea_water      cell_methods      !time: point lat: point lon: point      ancillary_variables       chlorophyll_instrument_1 platform chloro_qc_1_agg chloro_qc_1_gap chloro_qc_1_syn chloro_qc_1_loc chloro_qc_1_rng chloro_qc_1_clm chloro_qc_1_spk chloro_qc_1_rtc chloro_qc_1_flt      platform      platform   
instrument        chlorophyll_instrument_1   standard_name_url         Qhttps://mmisw.org/ont/cf/parameter/mass_concentration_of_chlorophyll_in_sea_water        , h   chloro_qc_1_agg              	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        chloro_qc_1_agg    
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 
   chloro_qc_1_gap              	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        chloro_qc_1_gap    
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 6   chloro_qc_1_syn              	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        chloro_qc_1_syn    
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , b   chloro_qc_1_loc              	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        chloro_qc_1_loc    
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    chloro_qc_1_rng              	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        chloro_qc_1_rng    
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    chloro_qc_1_clm              	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        chloro_qc_1_clm    
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    chloro_qc_1_spk              	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        chloro_qc_1_spk    
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , ,   chloro_qc_1_rtc              	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        chloro_qc_1_rtc    
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , ?H   chloro_qc_1_flt              	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        chloro_qc_1_flt    
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , kd   +mass_concentration_of_oxygen_in_sea_water_1                 
_FillValue        <    
gts_ingest        true   source        Local Data Node    	long_name         )mass concentration of oxygen in sea water      
standard_name         )mass_concentration_of_oxygen_in_sea_water      	ncei_name         )mass_concentration_of_oxygen_in_sea_water      units         ug L-1     
missing_value         <    	valid_min                	valid_max         Ap     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        Lhttps://mmisw.org/ont/cf/parameter/mass_concentration_of_oxygen_in_sea_water   cell_methods      !time: point lat: point lon: point      ancillary_variables       oxygen_instrument_1 platform oxygen_qc_1_agg oxygen_qc_1_gap oxygen_qc_1_syn oxygen_qc_1_loc oxygen_qc_1_rng oxygen_qc_1_clm oxygen_qc_1_spk oxygen_qc_1_rtc oxygen_qc_1_flt   platform      platform   
instrument        oxygen_instrument_1    standard_name_url         Lhttps://mmisw.org/ont/cf/parameter/mass_concentration_of_oxygen_in_sea_water     ,    oxygen_qc_1_agg              	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        oxygen_qc_1_agg    
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , Ü   oxygen_qc_1_gap              	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        oxygen_qc_1_gap    
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    oxygen_qc_1_syn              	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        oxygen_qc_1_syn    
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    oxygen_qc_1_loc              	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        oxygen_qc_1_loc    
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , G   oxygen_qc_1_rng              	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        oxygen_qc_1_rng    
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , t   oxygen_qc_1_clm              	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        oxygen_qc_1_clm    
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , (   oxygen_qc_1_spk              	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        oxygen_qc_1_spk    
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , D   oxygen_qc_1_rtc              	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        oxygen_qc_1_rtc    
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , `   oxygen_qc_1_flt              	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        oxygen_qc_1_flt    
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , $|   relative_humidity_1                 
_FillValue        <    
gts_ingest        true   source        Local Data Node    	long_name         relative humidity      
standard_name         relative_humidity      	ncei_name         relative_humidity      units         1      
missing_value         <    	valid_min                	valid_max         B     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        4https://mmisw.org/ont/cf/parameter/relative_humidity   cell_methods      !time: point lat: point lon: point      ancillary_variables       relative_humidity_instrument_1 platform humidity_qc_1_agg humidity_qc_1_gap humidity_qc_1_syn humidity_qc_1_loc humidity_qc_1_rng humidity_qc_1_clm humidity_qc_1_spk humidity_qc_1_rtc humidity_qc_1_flt      platform      platform   
instrument        relative_humidity_instrument_1     standard_name_url         4https://mmisw.org/ont/cf/parameter/relative_humidity     , P   humidity_qc_1_agg                	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        humidity_qc_1_agg      
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , |   humidity_qc_1_gap                	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        humidity_qc_1_gap      
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    humidity_qc_1_syn                	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        humidity_qc_1_syn      
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    humidity_qc_1_loc                	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        humidity_qc_1_loc      
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    humidity_qc_1_rng                	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        humidity_qc_1_rng      
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , -$   humidity_qc_1_clm                	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        humidity_qc_1_clm      
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , Y@   humidity_qc_1_spk                	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        humidity_qc_1_spk      
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , \   humidity_qc_1_rtc                	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        humidity_qc_1_rtc      
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , x   humidity_qc_1_flt                	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        humidity_qc_1_flt      
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , ݔ   sea_water_turbidity_1                   
_FillValue        <    source        Local Data Node    
gts_ingest        true   	long_name         sea water turbidity    
standard_name         sea_water_turbidity    	ncei_name         sea_water_turbidity    units         1      
missing_value         <    	valid_min                	valid_max         Dz     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        6https://mmisw.org/ont/cf/parameter/sea_water_turbidity     cell_methods      !time: point lat: point lon: point      ancillary_variables       turbidity_instrument_1 platform turbidity_qc_1_agg turbidity_qc_1_gap turbidity_qc_1_syn turbidity_qc_1_loc turbidity_qc_1_rng turbidity_qc_1_clm turbidity_qc_1_spk turbidity_qc_1_rtc turbidity_qc_1_flt     platform      platform   
instrument        turbidity_instrument_1     standard_name_url         6https://mmisw.org/ont/cf/parameter/sea_water_turbidity       , 	   turbidity_qc_1_agg               	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        turbidity_qc_1_agg     
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , 5   turbidity_qc_1_gap               	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        turbidity_qc_1_gap     
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , a   turbidity_qc_1_syn               	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        turbidity_qc_1_syn     
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    turbidity_qc_1_loc               	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        turbidity_qc_1_loc     
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,     turbidity_qc_1_rng               	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        turbidity_qc_1_rng     
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , <   turbidity_qc_1_clm               	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        turbidity_qc_1_clm     
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , X   turbidity_qc_1_spk               	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        turbidity_qc_1_spk     
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , >t   turbidity_qc_1_rtc               	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        turbidity_qc_1_rtc     
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , j   turbidity_qc_1_flt               	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        turbidity_qc_1_flt     
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    dew_point_temperature_1                 
_FillValue        <    
gts_ingest        true   source        Local Data Node    	long_name         dew point temperature      
standard_name         dew_point_temperature      	ncei_name         dew_point_temperature      units         degree_Celsius     
missing_value         <    	valid_min               	valid_max         BH     coordinates       time lat lon   coverage_content_type         physicalMeasurement    grid_mapping      crs    
references        8https://mmisw.org/ont/cf/parameter/dew_point_temperature   cell_methods      !time: point lat: point lon: point      ancillary_variables       dew_point_instrument_1 platform dew_point_qc_1_agg dew_point_qc_1_gap dew_point_qc_1_syn dew_point_qc_1_loc dew_point_qc_1_rng dew_point_qc_1_clm dew_point_qc_1_spk dew_point_qc_1_rtc dew_point_qc_1_flt     platform      platform   
instrument        dew_point_instrument_1     standard_name_url         8https://mmisw.org/ont/cf/parameter/dew_point_temperature     ,    dew_point_qc_1_agg               	   
_FillValue           	long_name         (QARTOD Aggregate/Rollup Test (processed)   
short_name        dew_point_qc_1_agg     
standard_name         aggregate_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    dew_point_qc_1_gap               	   
_FillValue           	long_name         QARTOD Gap Test (processed)    
short_name        dew_point_qc_1_gap     
standard_name         gap_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,     dew_point_qc_1_syn               	   
_FillValue           	long_name         QARTOD Syntax Test (processed)     
short_name        dew_point_qc_1_syn     
standard_name         syntax_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , G   dew_point_qc_1_loc               	   
_FillValue           	long_name          QARTOD Location Test (processed)   
short_name        dew_point_qc_1_loc     
standard_name         location_test_quality_flag     coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , s8   dew_point_qc_1_rng               	   
_FillValue           	long_name         #QARTOD Gross Range Test (processed)    
short_name        dew_point_qc_1_rng     
standard_name         gross_range_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , T   dew_point_qc_1_clm               	   
_FillValue           	long_name         #QARTOD Climatology Test (processed)    
short_name        dew_point_qc_1_clm     
standard_name         climatology_test_quality_flag      coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , p   dew_point_qc_1_spk               	   
_FillValue           	long_name         QARTOD Spike Test (processed)      
short_name        dew_point_qc_1_spk     
standard_name         spike_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        ,    dew_point_qc_1_rtc               	   
_FillValue           	long_name         &QARTOD Rate of Change Test (processed)     
short_name        dew_point_qc_1_rtc     
standard_name          rate_of_change_test_quality_flag   coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , #   dew_point_qc_1_flt               	   
_FillValue           	long_name         !QARTOD Flat Line Test (processed)      
short_name        dew_point_qc_1_flt     
standard_name         flat_line_test_quality_flag    coverage_content_type         qualityInformation     
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
references        %https://ioos.noaa.gov/ioos-in-action/      units         1        , OAֹ   AֹB   Aֹn   Aֹ   Aֹ   Aֹ   Aֹ   Aֹ[   Aֹ   AֹJ   Aֹv   Aֹ   Aֹ   Aֹ   Aֹ   Aֹc   Aֹ   AֹR   Aֹ~   Aֹ   Aֹ   Aֹ   Aֺ    Aֺ k   Aֺ    AֺZ   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ
   Aֺs   Aֺ   Aֺ	b   Aֺ
   Aֺ
   Aֺ$   Aֺ   Aֺ   Aֺ{   Aֺ   Aֺj   Aֺ   Aֺ   Aֺ,   Aֺ   Aֺ   Aֺ   Aֺ   Aֺr   Aֺ   Aֺ   Aֺ4   Aֺ   Aֺ"   Aֺ   Aֺ   Aֺz   Aֺ   Aֺ    Aֺ <   Aֺ!   Aֺ#*   Aֺ#   Aֺ#   Aֺ%   Aֺ&   Aֺ'   Aֺ'D   Aֺ)   Aֺ*2   Aֺ*   Aֺ*   Aֺ,   Aֺ-   Aֺ.   Aֺ.L   Aֺ0   Aֺ1:   Aֺ1   Aֺ1   Aֺ3   Aֺ4   Aֺ5'   Aֺ5T   Aֺ7   Aֺ8B   Aֺ8   Aֺ8   Aֺ:   Aֺ;   Aֺ</   Aֺ<\   Aֺ>   Aֺ?J   Aֺ?   Aֺ?   AֺA   AֺB   AֺC7   AֺCd   AֺE&   AֺFR   AֺF   AֺF   AֺH   AֺI   AֺJ?   AֺJl   AֺL.   AֺMZ   AֺM   AֺM   AֺO   AֺP   AֺQG   AֺQt   AֺS6   AֺTb   AֺT   AֺT   AֺV   AֺW   AֺXO   AֺX|   AֺZ>   Aֺ[j   Aֺ[   Aֺ\    Aֺ]   Aֺ^   Aֺ_W   Aֺ_   AֺaF   Aֺbr   Aֺb   Aֺc   Aֺd   Aֺe   Aֺf_   Aֺf   AֺhN   Aֺiz   Aֺi   Aֺj   Aֺk   Aֺl   Aֺmg   Aֺm   AֺoV   Aֺp   Aֺp   Aֺq   Aֺr   Aֺt   Aֺto   Aֺt   Aֺv^   Aֺw   Aֺx    Aֺy   Aֺ{   Aֺ{w   Aֺ{   Aֺ}f   Aֺ~   Aֺ~   Aֺ(   Aֺ   Aֺ   Aֺ   Aֺ   Aֺn   Aֺ   Aֺ   Aֺ0   Aֺ   Aֺ   Aֺ   Aֺ   Aֺv   Aֺ   Aֺ   Aֺ8   Aֺ   Aֺ&   Aֺ   Aֺ   Aֺ~   Aֺ   Aֺ   Aֺ@   Aֺ   Aֺ.   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ   AֺH   Aֺ
   Aֺ6   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ#   AֺP   Aֺ   Aֺ>   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ+   AֺX   Aֺ   AֺF   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ3   Aֺ`   Aֺ"   AֺN   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ;   Aֺh   Aֺ*   AֺV   Aֺ   Aֺ   Aֺ   Aֺ   AֺC   Aֺp   Aֺ2   Aֺ^   Aֺ   Aֺ   Aֺö   Aֺ   AֺK   Aֺx   Aֺ:   Aֺf   Aֺ   Aֺ   Aֺʾ   Aֺ   AֺS   Àֺ   AֺB   Aֺn   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ[   Aֺӈ   AֺJ   Aֺv   Aֺ   Aֺ   Aֺ   Aֺ   Aֺc   Aֺڐ   AֺR   Aֺ~   Aֺ   Aֺ   Aֺ   Aֺ   Aֺk   Aֺ   AֺZ   Aֺ   Aֺ   Aֺ   Aֺ   Aֺ
   Aֺs   Aֺ   Aֺb   Aֺ   Aֺ   Aֺ$   Aֺ   Aֺ   Aֺ{   Aֺ   Aֺj   Aֺ   Aֺ   Aֺ,   Aֺ   Aֺ   Aֺ   Aֺ   Aֺr   Aֺ   Aֺ   Aֺ4   Aֺ   Aֺ"   Aֺ   Aֺ   Aֺz   Aֻ    Aֻ   Aֻ<   Aֻ   Aֻ*   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ   AֻD   Aֻ
   Aֻ2   Aֻ   Aֻ   Aֻ
   Aֻ   Aֻ   AֻL   Aֻ   Aֻ:   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ'   AֻT   Aֻ   AֻB   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ/   Aֻ\   Aֻ   Aֻ J   Aֻ    Aֻ    Aֻ"   Aֻ#   Aֻ$7   Aֻ$d   Aֻ&&   Aֻ'R   Aֻ'   Aֻ'   Aֻ)   Aֻ*   Aֻ+?   Aֻ+l   Aֻ-.   Aֻ.Z   Aֻ.   Aֻ.   Aֻ0   Aֻ1   Aֻ2G   Aֻ2t   Aֻ46   Aֻ5b   Aֻ5   Aֻ5   Aֻ7   Aֻ8   Aֻ9O   Aֻ9|   Aֻ;>   Aֻ<j   Aֻ<   Aֻ=    Aֻ>   Aֻ?   Aֻ@W   Aֻ@   AֻBF   AֻCr   AֻC   AֻD   AֻE   AֻF   AֻG_   AֻG   AֻIN   AֻJz   AֻJ   AֻK   AֻL   AֻM   AֻNg   AֻN   AֻPV   AֻQ   AֻQ   AֻR   AֻS   AֻU   AֻUo   AֻU   AֻW^   AֻX   AֻX   AֻY    AֻZ   Aֻ\   Aֻ\w   Aֻ\   Aֻ^f   Aֻ_   Aֻ_   Aֻ`(   Aֻa   Aֻc   Aֻc   Aֻc   Aֻen   Aֻf   Aֻg   Aֻg0   Aֻh   Aֻj   Aֻj   Aֻj   Aֻlv   Aֻm   Aֻn   Aֻn8   Aֻo   Aֻq&   Aֻq   Aֻq   Aֻs~   Aֻt   Aֻu   Aֻu@   Aֻw   Aֻx.   Aֻx   Aֻx   Aֻz   Aֻ{   Aֻ|   Aֻ|H   Aֻ~
   Aֻ6   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ#   AֻP   Aֻ   Aֻ>   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ+   AֻX   Aֻ   AֻF   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ3   Aֻ`   Aֻ"   AֻN   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ;   Aֻh   Aֻ*   AֻV   Aֻ   Aֻ   Aֻ   Aֻ   AֻC   Aֻp   Aֻ2   Aֻ^   Aֻ   Aֻ   Aֻ   Aֻ   AֻK   Aֻx   Aֻ:   Aֻf   Aֻ   Aֻ   Aֻ   Aֻ   AֻS   Aֻ   AֻB   Aֻn   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ[   Aֻ   AֻJ   Aֻv   Aֻ   Aֻ   Aֻ   Aֻ   Aֻc   Aֻ   AֻR   Aֻ~   Aֻ   Aֻ   Aֻ   Aֻ   AֻZ   Aֻņ   Aֻ   Aֻ   Aֻ   Aֻ
   Aֻs   Aֻɠ   Aֻb   Aֻ̎   Aֻ   Aֻ$   Aֻ   Aֻ   Aֻ{   AֻШ   Aֻj   AֻӖ   Aֻ   Aֻ,   Aֻ   Aֻ   Aֻ׃   Aֻװ   Aֻr   Aֻڞ   Aֻ   Aֻ4   Aֻ   Aֻ"   Aֻދ   Aֻ޸   Aֻz   Aֻ   Aֻ   Aֻ<   Aֻ   Aֻ*   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ   AֻD   Aֻ   Aֻ2   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ   AֻL   Aֻ   Aֻ:   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ'   AֻT   Aֻ   AֻB   Aֻ   Aֻ   Aֻ   Aֻ   Aֻ/   Aֻ\   Aּ    AּJ   Aּ   Aּ   Aּ   Aּ   Aּ7   Aּd   Aּ&   AּR   Aּ   Aּ   Aּ
   Aּ   Aּ?   Aּl   Aּ.   AּZ   Aּ   Aּ   Aּ   Aּ   AּG   Aּt   Aּ6   Aּb   Aּ   Aּ   Aּ   Aּ   AּO   Aּ|   Aּ>   Aּj   Aּ   Aּ    Aּ   Aּ    Aּ!W   Aּ!   Aּ#F   Aּ$r   Aּ$   Aּ%   Aּ&   Aּ'   Aּ(_   Aּ(   Aּ*N   Aּ+z   Aּ+   Aּ,   Aּ-   Aּ.   Aּ/g   Aּ/   Aּ1V   Aּ2   Aּ2   Aּ3   Aּ4   Aּ6   Aּ6o   Aּ6   Aּ8^   Aּ9   Aּ9   Aּ:    Aּ;   Aּ=   Aּ=w   Aּ=   Aּ?f   Aּ@   Aּ@   AּA(   AּB   AּD   AּD   AּD   AּFn   AּG   AּH   AּH0   AּI   AּK   AּK   AּK   AּMv   AּN   AּO   AּO8   AּP   AּR&   AּR   AּR   AּT~   AּU   AּV   AּV@   AּX   AּY.   AּY   AּY   Aּ[   Aּ\   Aּ]   Aּ]H   Aּ_
   Aּ`6   Aּ`   Aּ`   Aּb   Aּc   Aּd#   AּdP   Aּf   Aּg>   Aּg   Aּg   Aּi   Aּj   Aּk+   AּkX   Aּm   AּnF   Aּn   Aּn   Aּp   Aּq   Aּr3   Aּr`   Aּt"   AּuN   Aּu   Aּu   Aּw   Aּx   Aּy;   Aּyh   Aּ{*   Aּ|V   Aּ|   Aּ|   Aּ~   Aּ   AּC   Aּp   Aּ2   Aּ^   Aּ   Aּ   Aּ   Aּ   AּK   Aּx   Aּ:   Aּf   Aּ   Aּ   Aּ   Aּ   AּS   Aּ   AּB   Aּn   Aּ   Aּ   Aּ   Aּ   Aּ[   Aּ   AּJ   Aּv   Aּ   Aּ   Aּ   Aּ   Aּc   Aּ   AּR   Aּ~   Aּ   Aּ   Aּ   Aּ   Aּk   Aּ   AּZ   Aּ   Aּ   Aּ   Aּ   Aּ
   Aּs   Aּ   Aּb   Aּ   Aּ   Aּ$   Aּ   Aּ   Aּ{   Aּ   Aּj   Aּ   Aּ   Aּ,   Aּ   Aּ   Aּ   Aּ   Aּr   Aּ   Aּ   Aּ4   Aּ   Aּ"   Aּ|   Aּ   Aּz   Aּ¦   Aּ    Aּ<   Aּ   Aּ*   AּƄ   Aּ   AּȂ   Aּɮ   Aּ   AּD   Aּ   Aּ2   Aּ͛   Aּ   Aּϊ   Aּж   Aּ   AּL   Aּ   Aּ:   Aּԣ   Aּ   Aּ֒   Aּ׾   Aּ'   AּT   Aּ   AּB   Aּ۫   Aּ   Aּݚ   Aּ   Aּ/   Aּ\   Aּ   AּJ   Aּ   Aּ   Aּ   Aּ   Aּ7   Aּd   Aּ&   AּR   Aּ   Aּ   Aּ   Aּ   Aּ?   Aּl   Aּ.   AּZ   Aּ   Aּ   Aּ   Aּ   AּG   Aּt   Aּ6   Aּb   Aּ   Aּ   Aּ   Aּ   AּO   Aּ|   Aּ>   Aּj   Aּ   Aּ    Aֽ    Aֽ   AֽW   Aֽ   AֽF   Aֽr   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ	_   Aֽ	   AֽN   Aֽz   Aֽ   Aֽ
   Aֽ   Aֽ   Aֽg   Aֽ   AֽV   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ   Aֽo   Aֽ   Aֽ^   Aֽ   Aֽ   Aֽ    Aֽ   Aֽ   Aֽw   Aֽ   Aֽ f   Aֽ!   Aֽ!   Aֽ"(   Aֽ#   Aֽ%   Aֽ%   Aֽ%   Aֽ'n   Aֽ(   Aֽ)   Aֽ)0   Aֽ*   Aֽ,   Aֽ,   Aֽ,   Aֽ.v   Aֽ/   Aֽ0   Aֽ08   Aֽ1   Aֽ3&   Aֽ3   Aֽ3   Aֽ5~   Aֽ6   Aֽ7   Aֽ7@   Aֽ9   Aֽ:.   Aֽ:   Aֽ:   Aֽ<   Aֽ=   Aֽ>   Aֽ>H   Aֽ@
   AֽA6   AֽA   AֽA   AֽC   AֽD   AֽE#   AֽEP   AֽG   AֽH>   AֽH   AֽH   AֽJ   AֽK   AֽL+   AֽLX   AֽN   AֽOF   AֽO   AֽO   AֽQ   AֽR   AֽS3   AֽS`   AֽU"   AֽVN   AֽV   AֽV   AֽX   AֽY   AֽZ;   AֽZh   Aֽ\*   Aֽ]V   Aֽ]   Aֽ]   Aֽ_   Aֽ`   AֽaC   Aֽap   Aֽc2   Aֽd^   Aֽd   Aֽd   Aֽf   Aֽg   AֽhK   Aֽhx   Aֽj:   Aֽkf   Aֽk   Aֽk   Aֽm   Aֽn   AֽoS   Aֽo   AֽqB   Aֽrn   Aֽr   Aֽs   Aֽt   Aֽu   Aֽv[   Aֽv   AֽxJ   Aֽyv   Aֽy   Aֽz   Aֽ{   Aֽ|   Aֽ}c   Aֽ}   AֽR   Aֽ~   Aֽ   Aֽ   Aֽ   Aֽ   Aֽk   Aֽ   AֽZ   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ
   Aֽs   Aֽ   Aֽb   Aֽ   Aֽ   Aֽ$   Aֽ   Aֽ   Aֽ{   Aֽ   Aֽj   Aֽ   Aֽ   Aֽ,   Aֽ   Aֽ   Aֽ   Aֽr   Aֽ   Aֽ   Aֽ   Aֽ"   Aֽ   Aֽz   Aֽ   Aֽ   Aֽ   Aֽ*   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ2   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ   AֽL   Aֽ   Aֽ:   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ'   AֽT   Aֽ   AֽB   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ/   Aֽ\   Aֽ   AֽJ   Aֽó   Aֽ   AֽŢ   Aֽ   Aֽ7   Aֽd   Aֽ&   AֽR   Aֽʻ   Aֽ   Aֽ̪   Aֽ   Aֽ?   Aֽl   Aֽ.   AֽZ   Aֽ   Aֽ   AֽӲ   Aֽ   AֽG   Aֽt   Aֽ6   Aֽb   Aֽ   Aֽ   Aֽں   Aֽ   AֽO   Aֽ|   Aֽ>   Aֽj   Aֽ   Aֽ    Aֽ   Aֽ   AֽW   Aֽ   AֽF   Aֽr   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ_   Aֽ   AֽN   Aֽz   Aֽ   Aֽ   Aֽ   Aֽ   Aֽg   Aֽ   AֽV   Aֽ   Aֽ   Aֽ   Aֽ   Aֽ   Aֽo   Aֽ   Aֽ^   Aֽ   Aֽ   Aֽ    Aֽ   Aֽ   Aֽw   Aֽ   A־f   A־   A־   A־(   A־   A־   A־   A־   A־n   A־	   A־
   A־
0   A־   A־
   A־
   A־
   A־v   A־   A־   A־8   A־   A־&   A־   A־   A־~   A־   A־   A־@   A־   A־.   A־   A־   A־   A־   A־   A־H   A־!
   A־"6   A־"   A־"   A־$   A־%   A־&#   A־&P   A־(   A־)>   A־)   A־)   A־+   A־,   A־-+   A־-X   A־/   A־0F   A־0   A־0   A־2   A־3   A־43   A־4`   A־6"   A־7N   A־7   A־7   A־9   A־:   A־;;   A־;h   A־=*   A־>V   A־>   A־>   A־@   A־A   A־BC   A־Bp   A־D2   A־E^   A־E   A־E   A־G   A־H   A־IK   A־Ix   A־K:   A־Lf   A־L   A־L   A־N   A־O   A־PS   A־P   A־RB   A־Sn   A־S   A־T   A־U   A־V   A־W[   A־W   A־YJ   A־Zv   A־Z   A־[   A־\   A־]   A־^c   A־^   A־`R   A־a~   A־a   A־b   A־c   A־e   A־ek   A־e   A־gZ   A־h   A־h   A־i   A־j   A־l
   A־ls   A־l   A־nb   A־o   A־o   A־p$   A־q   A־s   A־s{   A־s   A־uj   A־v   A־v   A־w,   A־x   A־z   A־z   A־z   A־|r   A־}   A־~   A־~4   A־   A־"   A־   A־   A־z   A־   A־   A־<   A־   A־*   A־   A־   A־   A־   A־   A־D   A־   A־2   A־   A־   A־   A־   A־   A־L   A־   A־:   A־   A־   A־   A־   A־'   A־T   A־   A־B   A־   A־   A־   A־   A־/   A־\   A־   A־J   A־   A־   A־   A־   A־7   A־d   A־&   A־R   A־   A־   A־   A־   A־?   A־l   A־.   A־Z   A־   A־   A־   A־   A־G   A־t   A־6   A־b   A־   A־   A־   A־   A־O   A־|   A־>   A־j   A־   A־    A־   A־   A־W   A־Ą   A־F   A־r   A־   A־   A־   A־   A־_   A־ˌ   A־N   A־z   A־   A־   A־   A־   A־g   A־Ҕ   A־V   A־Ղ   A־   A־   A־   A־   A־o   A־ٜ   A־^   A־܊   A־   A־    A־   A־   A־w   A־   A־f   A־   A־   A־(   A־   A־   A־   A־   A־n   A־   A־   A־0   A־   A־   A־   A־   A־v   A־   A־   A־8   A־   A־&   A־   A־   A־~   A־   A־   A־@   A־   A־.   A־   A־   A־   A־   Aֿ    Aֿ H   Aֿ
   Aֿ6   Aֿ   Aֿ   Aֿ   Aֿ   Aֿ#   AֿP   Aֿ	   Aֿ
>   Aֿ
   Aֿ
   Aֿ   Aֿ
   Aֿ+   AֿX   Aֿ   AֿF   Aֿ   Aֿ   Aֿ   Aֿ   Aֿ3   Aֿ`   Aֿ"   Aֿ   Aֿ   Aֿh   Aֿ*   Aֿ   Aֿ!   Aֿ#p   Aֿ%2   Aֿ&   Aֿ(   Aֿ*x   Aֿ,:   Aֿ-   Aֿ/   Aֿ1   Aֿ3B   Aֿ5   Aֿ6   Aֿ8   Aֿ:J   Aֿ<   Aֿ=   Aֿ?   AֿAR   AֿC   AֿD   AֿF   AֿHZ   AֿJ   AֿK   AֿM   AֿOb   AֿQ$   AֿR   AֿT   AֿVj   AֿX,   AֿY   Aֿ[   Aֿ]r   Aֿ_4   Aֿ`   Aֿb   Aֿdz   Aֿf<   Aֿg   Aֿi   Aֿk   AֿmD   Aֿo   Aֿp   Aֿr   AֿtL   Aֿv   Aֿw   Aֿy   Aֿ{T   Aֿ}   Aֿ~   Aֿ   Aֿ\   Aֿ   Aֿ   Aֿ   Aֿd   Aֿ&   Aֿ   Aֿ   Aֿl   Aֿ.   Aֿ   Aֿ   Aֿt   Aֿ6   Aֿ   Aֿ   Aֿ|   Aֿ>   Aֿ    Aֿ   Aֿ   AֿF   Aֿ   Aֿ   Aֿ   AֿN   Aֿ   Aֿ   Aֿ   AֿV   Aֿ   Aֿ   Aֿ   Aֿ^   Aֿ    Aֿ   Aֿ   Aֿf   Aֿ(   Aֿ   AֿȬ   Aֿn   Aֿ0   Aֿ   Aֿ   Aֿχ   Aֿϴ   Aֿv   AֿҢ   Aֿ   Aֿ8   Aֿ   Aּֿ   Aֿ~   Aֿ@   Aֿ   Aֿ   Aֿ߆   AֿH   Aֿ
   Aֿ   Aֿ   AֿP   Aֿ   Aֿ   Aֿ   AֿX   Aֿ   Aֿ   Aֿ   Aֿ`   Aֿ"   Aֿ   Aֿ   Aֿh   Aֿ*   A    A   Ap   A2   A   A	   Ax   A
:   A   A   A   AS   A   AB   An   A   A   A   A   A[   A   AJ   Av   A   A   A   A   A c   A    A"R   A#~   A#   A$   A%   A'   A'k   A'   A)Z   A*   A*   A+   A,   A.
   A.s   A.   A0b   A1   A1   A2$   A3   A5   A5{   A5   A7j   A8   A8   A9,   A:   A<   A<   A<   A>r   A?   A@   A@4   AA   AC"   AC   AC   AEz   AF   AG   AG<   AH   AJ*   AJ   AJ   AL   AM   AN   AND   AP   AQ2   AQ   AQ   AS   AT   AU   AUL   AW   AX:   AX   AX   AZ   A[   A\'   A\T   A^   A_B   A_   A_   Aa   Ab   Ac/   Ac\   Ae   AfJ   Af   Af   Ah   Ai   Aj7   Ajd   Al&   AmR   Am   Am   Ao   Ap   Aq?   Aql   As.   AtZ   At   At   Av   Aw   AxG   Axt   Az6   A{b   A{   A{   A}   A~   AO   A|   A>   Aj   A   A    A   A   AW   A   AF   Ar   A   A   A   A   A_   A   AN   Az   A   A   A   A   Ag   A   AV   A   A   A   A   A   Ao   A   A^   A   A   A    A   A   Aw   A   Af   A   A   A(   A   A   A   A   An   A   A   A0   A   A   A   A   Av   A   A   A8   A   A&   A   A   A~   A   A   A@   A   A.   A   A   A   A   A   AH   A
   A6   Aş   A   Aǎ   AȺ   A#   AP   A   A>   A̧   A   AΖ   A   A+   AX   A   AF   Aӯ   A   A՞   A   A3   A`   A"   AN   Aڷ   A   Aܦ   A   A;   Ah   A*   AV   A   A   A   A   A4   Ap   A2   A^   A   A   A   A   A<   Ax   A:   Af   A   A   A   A   AD   A   AB   An   A   A   A   A   AL   A   AJ   Av   A   A   A   A    AT   A   AR   A~   A   A   A   A   A\   A   A
Z   A   A   A   A
   A
   Ad   A   Ab   A   A   A$   A   A   A{   A   A   A.   Aj   A,   A   A   Ar   A!4   A"   A$"   A$   A$   A&z   A'   A(   A(<   A)   A+*   A+   A+   A-   A.   A/   A/D   A1   A22   A2   A2   A4   A5   A6   A6L   A8   A9:   A9   A9   A;   A<   A='   A=T   A?   A@B   A@   A@   AB   AC   AD/   AD\   AF   AGJ   AG   AG   AI   AJ   AK7   AKd   AM&   ANR   AN   AN   AP   AQ   AR?   ARl   AT.   AUZ   AU   AU   AW   AX   AYG   AYt   A[6   A\b   A\   A\   A^   A_   A`O   A`|   Ab>   Acj   Ac   Ad    Ae   Af   AgW   Ag   AiF   Ajr   Aj   Ak   Al   Am   An_   An   ApN   Aqz   Aq   Ar   As   At   Aug   Au   AwV   Ax   Ax   Ay   Az   A|   A|o   A|   A~^   A   A   A    A   A   Aw   A   Af   A   A   A(   A   A   A   A   An   A   A   A0   A   A   A   A   Av   A   A   A8   A   A&   A   A   A~   A   A   A@   A   A.   A   A   A   A   A   AH   A
   A6   A   A   A   A   A#   AP   A   A>   A   A   A   A   A+   AX   A   AF   A   A   A   A   A3   A`   A"   A   A   A   A;   Ah   A*   AV   A¿   A   AĮ   A   AC   Ap   A2   A^   A   A   A˶   A   AK   Ax   A:   Af   A   A   AҾ   A   AS   AԀ   AB   An   A   A   A   A   A[   Aۈ   AJ   Av   A   A   A   A   Ac   A   AR   A~   A   A   A   A   Ak   A   AZ   A   A   A   A   A
   As   A   Ab   A   A   A$   A   A   A{   A   Aj   A   A   A,   A   A   A   A   A r   A   A   A4   A   A"   A   A   Az   A   A	   A	<   A
   A*   A   A   A   A   A   AD   A   A2   A   A   A   A   A   AL   A   A:   A   A   A   A   A'   AT   A    A!B   A!   A!   A#   A$   A%/   A%\   A'   A(J   A(   A(   A*   A+   A,7   A,d   A.&   A/R   A/   A/   A1   A2   A3?   A3l   A5.   A6Z   A6   A6   A8   A9   A:G   A:t   A<6   A=b   A=   A=   A?   A@   AAO   AA|   AC>   ADj   AD   AE    AF   AG   AHW   AH   AJF   AKr   AK   AL   AM   AN   AO_   AO   AQN   ARz   AR   AS   AT   AU   AVg   AV   AXV   AY   AY   AZ   A[   A]   A]o   A]   A_^   A`   A`   Aa    Ab   Ad   Adw   Ad   Aff   Ag   Ag   Ah(   Ai   Ak   Ak   Ak   Amn   An   Ao   Ao0   Ap   Ar   Ar   Ar   Atv   Au   Av   Av8   Aw   Ay&   Ay   Ay   A{~   A|   A}   A}@   A   A.   A   A   A   A   A   AH   A
   A6   A   A   A   A   A#   AP   A   A>   A   A   A   A   A+   AX   A   AF   A   A   A   A   A3   A`   A"   AN   A   A   A   A   A ;   A h   A¢*   A£V   A£   A£   A¥   A¦   A§C   A§p   A©2   Aª^   Aª   Aª   A¬   A­   A®K   A®x   A°:   A±f   A±   A±   A³   A´   AµS   Aµ   A·B   A¸n   A¸   A¹   Aº   A»   A¼[   A¼   A¾J   A¿v   A¿   A   A   A   Ac   AÐ   AR   A~   A   A   A   A   Ak   Aʘ   AZ   A͆   A   A   A   A
   As   AѠ   Ab   AԎ   A   A$   A   A   A{   Aب   Aj   Aۖ   A   A,   A   A   A߃   A߰   Ar   A   A   A4   A   A"   A   A   Az   A   A   A<   A   A*   A   A   A   A   A   AD   A   A2   A   A   A   A   A   AL   A   A:   A   A   A   A   A'   AT   A   AB   A   A   A   A   A/   A\   A   A	J   A	   A	   A   A   A
7   A
d   A&   AR   A   A   A   A   A?   Al   A.   AZ   A   A   A   A   AG   At   A6   Ab   A   A   A    A!   A"O   A"|   A$>   A%j   A%   A&    A'   A(   A)W   A)   A+F   A,r   A,   A-   A.   A/   A0_   A0   A2N   A3z   A3   A4   A5   A6   A7g   A7   A9V   A:   A:   A;   A<   A>   A>o   A>   A@^   AA   AA   AB    AC   AE   AEw   AE   AGf   AH   AH   AI(   AJ   AL   AL   AL   ANn   AO   AP   AP0   AQ   AS   AS   AS   AUv   AV   AW   AW8   AX   AZ&   AZ   AZ   A\~   A]   A^   A^@   A`   Aa.   Aa   Aa   Ac   Ad   Ae   AeH   Ag
   Ah6   Ah   Ah   Aj   Ak   Al#   AlP   An   Ao>   Ao   Ao   Aq   Ar   As+   AsX   Au   AvF   Av   Av   Ax   Ay   Az3   Az`   A|"   A}N   A}   A}   A   AÀ   AÁ;   AÁh   AÃ*   AÄV   AÄ   AÄ   AÆ   AÇ   AÈC   AÈp   AÊ2   AË^   AË   AË   AÍ   AÎ   AÏK   AÏx   AÑ:   AÒf   AÒ   AÒ   AÔ   AÕ   AÖS   AÖ   AØB   AÙn   AÙ   AÚ   AÛ   AÜ   AÝ[   AÝ   AßJ   Aàv   Aà   Aá   Aâ   Aã   Aäc   Aä   AæR   Aç~   Aç   Aè   Aé   Aë   Aëk   Aë   AíZ   Aî   Aî   Aï   Að   Aò
   Aòs   Aò   Aôb   Aõ   Aõ   Aö$   A÷   Aù   Aù{   Aù   Aûj   Aü   Aü   Aý,   Aþ   A   A   A   Ar   AÞ   A   A4   A   A"   Aǋ   AǸ   Az   Aʦ   A   A<   A   A*   AΓ   A   AЂ   AѮ   A   AD   A   A2   A՛   A   A׊   Aض   A   AL   A   A:   Aܣ   A   Aޒ   A߾   A'   AT   A   AB   A   A   A   A   A/   A\   A   AJ   A   A   A   A   A7   Ad   A&   AR   A   A   A   A   A?   Al   A.   AZ   A   A   A   A   AG   At   A6   Ab   A   A   A   A   AO   A|   A>   Aj   A   A    A   A	   A
W   A
   AF   A
r   A
   A   A   A   A_   A   AN   Az   A   A   A   A   Ag   A   AV   A   A   A   A   A   Ao   A   A!^   A"   A"   A °m          |  |  |  |  |  |  |  |  |  |  |  |  < @i< < < @i< < < @l(< < < @nR< < < @qG< < < @s33< < < @vff< < < @y< < < @|< < < @~R< < < @\)< < < @< < < @33< < < @< < < @
=< < < @
=< < < @R< < < @< < < @< < < @H< < < @=q< < < @Q< < < @zH< < < @s33< < < @nR< < < @n{< < < @p< < < @s33< < < @u< < < @w< < < @x< < < @{< < < @}p< < < @~{< < < @  < < < @< < < @=q< < < @(< < < @< < < @
=< < @\)< < < @ff< < < @ff< < < @p< < < @33< < < @< < < @zH< < < @u< < < @p< < < @o\)< < < @p< < < @r\< < < @w
=< < < @z=q< < < @z=q< < < @|(< < < @< < < @  < < < @< < < @H< < < @
< < < @p< < < @  < < < @< < < @< < < @G< < < @  < < < @\)< < < @p< < < @
< < < @  < < < @xQ< < < @vff< < < @qG< < < @p< < < @p  < < < @p  < < < @r\< < < @s33< < < @s
< < < @w
=< < < @{< < < @\)< < < @\< < < @H< < < @< < < @< < < @< < < @=q< < < @G< < < @  < < < @
=< < < @ff< < < @z< < < @33< < < @  < < < @|< < < @xQ< < < @s
< < < @q< < < @r\< < < @tz< < < @w
=< < < @xQ< < < @zH< < < @~R< < < @< < < @=q< < < @(< < < @< < < @
=< < < @< < < @Q< < < @< < < @< < < @  < < < @< < < @ff< < < @(< < < @< < < @\)< < < @y< < < @u< < < @u< < < @q< < < @n{< < < @mp< < < @nR< < < @tz< < < @vff< < < @xQ< < < @{< < < @~{< < < < < @< < < @33< < < @z< < < @< < < @{< < < @{< < < @p< < < @
< < < @=q< < < @< < < @{< < < @w< < < @qG< < < @nR< < < @l< < < @n{< < < @nR< < < @p  < < < @q< < < @u< < < @x< < < @zH< < < @~{< < < @Q< < < @< < < @33< < < @(< < < @< < < @p< < < @{< < < @< < < @< < < @< < < @33< < < @< < < @}p< < < @z=q< < < @w
=< < < @s33< < < @qG< < < @p  < < < @p  < < < @o\)< < < @o\)< < < @q< < < @tz< < < @vff< < < @y< < < @}p< < < @Q< < < @< < < @=q< < < @H< < < @< < < @(< < < @(< < < @< < < @\< < < @G< < < @  < < < @}p< < < @zH< < < @xQ< < < @u< < < @u< < < @u< < < @u< < < @xQ< < < @x< < < @zH< < < @|< < < @Q< < < @< < < @\< < < @=q< < < @< < < @< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @=q< < < @< < < @Q< < < @\)< < < @\)< < < @Q< < < @< < < @G< < < @< < < @< < < @< < < @< < < @Q< < < @\)< < < @}p< < < @|(< < < @{< < < @{< < < @|(< < < @}p< < < @\)< < < @Q< < < @G< < < @=q< < < @\< < < @< < < @< < < @\)< < < @~R< < < @\)< < < @  < < < @Q< < < @G< < < @< < < @< < < @< < < @\< < @< < @< < @=q< < @< < @< < @< < < @H< < < @< < < @33< < < @< < < @
< < < @< < < @H< < < @< < < @< < < @}p< < < @zH< < < @y< < < @zH< < < @|< < < @~{< < < @  < < < @Q< < < @< < < @< < < @H< < < @33< < < @\< < < @=q< < < @=q< < < @< < < @z< < < @< < < @< < < @p< < < @< < < @< < < @
< < < @=q< < < @  < < < @~{< < < @|(< < < @zH< < < @z=q< < < @|< < < @x< < < @zH< < < @|< < < @  < < < @=q< < < @H< < < @< < < @< < < @
< < < @< < < @  < < < @G< < < @< < < @G< < < @< < < @< < < @\)< < < @< < < @33< < < @< < < @}p< < < @xQ< < < @w
=< < < @tz< < < @u< < < @x< < < @{< < < @~R< < < @< < < @
< < < @< < < @R< < < @< < < @  < < < @G< < < @33< < < @p< < < @R< < < @{< < < @z< < < @H< < < @G< < < @\)< < < @z< < < @< < < @{< < < @xQ< < < @w< < < @w< < < @x< < < @z=q< < < @|(< < < @  < < < @=q< < < @z< < < @ff< < < @  < < < @< < < @H< < < @(< < < @ff< < < @  < < < @< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < @z< < < @H< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < @< < < @< < < @  < < < @R< < < @z< < < @H< < < @G< < < @
=< < < @(< < < @Q< < < @z=q< < < @tz< < < @p< < < @n{< < < @mp< < < @nR< < < @p  < < < @s
< < < @y< < < @~{< < < @< < < @H< < < @< < < @R< < < @Q< < < @< < < @H< < < @
< < < @33< < < @< < < @< < < @< < < @ff< < < @(< < < @< < < @zH< < < @w
=< < < @u< < < @w
=< < < @tz< < < @vff< < < @vff< < < @xQ< < < @  < < < @=q< < < @< < < @
< < < @< < < @\)< < < @G< < < @=q< < < @< < < @(< < < @H< < < @< < < @G< < < @< < < @{< < < @
< < < @G< < < @~R< < < @{< < < @xQ< < < @x< < < @y< < < @{< < < @\)< < < @< < < @H< < < @(< < < @p< < < @\)< < < @< < < @G< < < @< < @=q< < < < < < < < @=q< < < @G< < < @< < < @  < < < @R< < < @< < < @\< < < @< < < @}p< < < @|(< < < @~R< < < @Q< < < @< < < @G< < < @< < < @< < < @< < < @R< < < @
=< < < @{< < < @p< < < @p< < < @{< < < @R< < < @
=< < < @
=< < < @ff< < < @R< < < @R< < < @< < < @33< < < @33< < < @\< < < @=q< < < @\< < < @(< < < @< < < @(< < < @
< < < @< < < @{< < < @R< < < @ff< < < < < @< < < @
< < < @=q< < < @< < < @\< < < @33< < < @< < < @33< < < @H< < < @(< < < @=q< < < @< < < @Q< < < @\)< < < @G< < < @33< < < @z< < < @p< < < @< < < @< < < @p< < < @
=< < < @\)< < < @p< < < @
< < < @\< < < @< < < @  < < < @  < < < @Q< < < @< < < @< < < @G< < < @< < < @< < < @\< < < @< < < @< < < @< < < @< < < @< < < @G< < < @< < < @< < < @=q< < < @< < < @< < < @G< < < @R< < < @z< < < @
< < < @< < < @  < < < @< < < @=q< < < @(< < < @
< < < @(< < < @z< < < @< < < @\)< < < @  < < < @< < < @G< < < @\< < < @< < < @ff< < < @R< < < @ff< < < @p< < < @(< < < @=q< < < @G< < < @< < < @
=< < < @z< < < @H< < < @< < < @=q< < < @33< < < @\< < < @33< < < @(< < < @
< < < @z< < < @
=< < < @G< < < @\< < < @
< < < @p< < < @< < < @G< < < @\< < < @H< < < @< < < @  < < < @R< < < @< < < @33< < < @< < < @< < < @(< < < @H< < < @H< < < @< < < @\< < < @< < < @
< < < @ff< < < @Q< < < @=q< < < @\< < < @H< < < @z< < < @p< < < @< < < @=q< < < @< < < @H< < < @< < < @\)< < < @p< < < @< < < @G< < < @R< < < @z< < < @\< < < @< < < @=q< < < @< < < @< < < @< < < @< < < @p< < < @\)< < < @< < < @=q< < < @33< < < @z< < < @p< < < @  < < < @< < < @\< < < @< < < @{< < < @< < < @H< < < @Q< < < @p< < < @H< < < @\)< < < @zH< < < @z=q< < < @zH< < < @z=q< < < @{< < < @~{< < < @Q< < < @< < < @33< < < @< < < @\)< < < @< < < @\< < < @(< < < @p< < < @< < < @< < < @33< < < @< < < @< < < @R< < < @
< < < @< < < @{< <    	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	< A33< < < A< < < AR< < < AH< < < AR< < < AH< < < AR< < < A< < < AR< < < AR< < < AR< < < AR< < < AR< < < A< < < A< < < A\< < < A\< < < AR< < < AH< < < A< < < A
=< < < AG< < < AG< < < AG< < < A< < < Az< < < A33< < < A\< < < A=q< < < A
=< < < A< < < A=q< < < A< < < AH< < < A< < < AH< < < A< < < A< < < A< < < A\)< < AG< < < A\)< < < A\)< < < A< < < A< < < A< < < A< < < A< < < A< < < A< < < A  < < < A(< < < AR< < < A\)< < < AQ< < < A< < < AH< < < AH< < < A< < < A< < < A< < < A< < < A< < < A< < < A
< < < A  < < < A(< < < Aff< < < Az< < < Az< < < Aff< < < AQ< < < Aff< < < AH< < < A< < < A(< < < A\< < < A\< < < AR< < < A\< < < A\< < < A
=< < < Ap< < < A< < < Aff< < < AH< < < A< < < A
=< < < Ap< < < A  < < < A< < < A< < < A< < < AG< < < A< < < A< < < AH< < < A< < < A< < < A\< < < A\< < < A< < < A< < < A< < < A< < < Ap< < < A< < < A
< < < A< < < A< < < A< < < A< < < A< < < A< < < A< < < A< < < A{< < < A  < < < A{< < < A< < < AH< < < AH< < < A< < < A
< < < A  < < < A< < < A< < < A< < < Ap< < < A< < < AH< < < AH< < < A< < < < < A
=< < < A(< < < A< < < A< < < A< < < A< < < A< < < A< < < A< < < A33< < < A33< < < A33< < < A33< < < AG< < < A\)< < < AG< < < A< < < AH< < < A< < < A< < < A
=< < < A\)< < < A< < < A< < < A  < < < A=q< < < Az< < < A< < < A
=< < < AG< < < A< < < Ap< < < A\)< < < A< < < A< < < Aff< < < Aff< < < A< < < A  < < < A=q< < < A< < < A< < < A
=< < < A< < < Ap< < < A< < < Ap< < < A=q< < < A< < < A< < < A< < < A< < < AR< < < A
=< < < A33< < < A33< < < Ap< < < AG< < < A\)< < < Ap< < < A  < < < A< < < A< < < A
=< < < < < < < < < < < < < < < A< < < Aff< < < AQ< < < A(< < < A{< < < A{< < < A(< < < A< < < Aff< < < Az< < < AR< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < A
< < < A< < < A  < < < A{< < < A{< < < A(< < < A\< < < A< < < A33< < < AG< < < AG< < < AG< < < A< < < AH< < < A
=< < < A
=< < < A< < < A£< < < A\< < < AG< < < A33< < < A
< < < AĸR< < < AŅ< < < Aff< < < A  < < < A  < < < A=q< < < AQ< < < AQ< < < A=q< < < Az< < < A33< < < AǮ< < < A< < < A< < A{< < Aff< < AQ< < Aff< < Az< < A< < < A{< < < Aȏ\< < < A=q< < < A< < < Aə< < < AQ< < < Ap< < < A< < < AH< < < A< < < A\)< < < A\)< < < A< < < AH< < < A< < < A33< < < A(< < < Az< < < AG< < < AθR< < < A< < < Aυ< < < A< < < AQ< < < Aυ< < < A\)< < < Aϙ< < < AϮ< < < Aff< < < A=q< < < A=q< < < A(< < < AУ< < < A\)< < < A< < < A< < < A< < < A< < < A\)< < < Aң< < < Aң< < < Aҏ\< < < Aң< < < A33< < < AQ< < < A=q< < < A{< < < AԸR< < < A  < < < A< < < AH< < < A< < < Az< < < A
< < < A< < < A  < < < Aأ< < < Aۮ< < < A\)< < < AQ< < < A߮< < < Az< < < A߅< < < A\)< < < AG< < < A{< < < Aff< < < A\)< < < A
< < < A=q< < < A{< < < Aۙ< < < A
=< < < AڸR< < < A< < < Aٙ< < < AG< < < A\)< < < A< < < Aٙ< < < AQ< < < AQ< < < A33< < < A  < < < A
< < < A\)< < < A=q< < < AH< < < A=q< < < Aݮ< < < A< < < A  < < < A< < < A
=< < < Ap< < < A< < < Ap< < < A߮< < < A(< < < A
< < < A߮< < < Aޣ< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < A=q< < < A(< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < A=q< < < A=q< < < A< < < A< < < A=q< < < A< < < AܸR< < < Az< < < A< < < AH< < < A\)< < < A< < < AH< < < A< < < A\< < < AR< < < A
=< < < AR< < < A(< < < A< < < A{< < < A< < < A
< < < Aff< < < A< < < A߅< < < AG< < < AQ< < < A< < < Aߙ< < < A߮< < < A< < < AQ< < < A
< < < AR< < < A\)< < < A  < < < Az< < < Az< < < A癚< < < AR< < < Az< < < Aff< < < A\< < < Aޏ\< < < A{< < < A< < < A< < < A=q< < < A=q< < < A
< < < A< < < A  < < < A< < < AH< < < A  < < < A(< < < A< < < A{< < < A< < < A< < < Az< < < A
=< < < Aff< < < AQ< < < AR< < < AH< < < Ap< < < A
=< < < A< < < Aff< < < Aff< < < A< < < A< < < A(< < A< < < < < < < < AܸR< < < Aܣ< < < AH< < < Aܣ< < < AH< < < A33< < < A  < < < A
=< < < AQ< < < A< < < A\)< < < A< < < A< < < A݅< < < A\)< < < A< < < A
< < < A{< < < A(< < < A< < < Aݮ< < < A< < < Aݮ< < < Aݮ< < < Aݮ< < < A
< < < A
< < < Aޏ\< < < Aޏ\< < < Aޣ< < < Aޣ< < < A< < < A< < < A޸R< < < Aޏ\< < < Ap< < < A< < < A< < < A< < < A33< < < A
< < < A< < < A߮< < < < < A߅< < < A߅< < < A߅< < < Ap< < < A߅< < < A< < < A< < < A< < < A(< < < AQ< < < A=q< < < A=q< < < AQ< < < A< < < Az< < < A< < < AH< < < AH< < < AH< < < A< < < A33< < < Ap< < < A< < < A< < < A< < < A< < < A< < < A< < < A< < < A< < < AH< < < AH< < < A< < < A
=< < < A< < < A33< < < A
< < < A< < < Aᙚ< < < A\)< < < A33< < < A33< < < A< < < A
=< < < Ap< < < A< < < AG< < < A< < < A{< < < A< < < A< < < A< < < A< < < Aff< < < Az< < < A\< < < A< < < A
=< < < A33< < < AG< < < A33< < < Ap< < < AH< < < A{< < < A  < < < A\)< < < A< < < A< < < A< < < A(< < < A< < < Aݮ< < < A< < < A
< < < Aff< < < A=q< < < AQ< < < Aff< < < AH< < < A< < < AH< < < A< < < A< < < AH< < < Aޣ< < < A< < < A=q< < < Aݮ< < < A< < < A< < < A  < < < A< < < Aff< < < Aڏ\< < < A  < < < A
=< < < Aأ< < < A< < < A  < < < A< < < AG< < < Aݙ< < < A(< < < A=q< < < A
< < < Ap< < < A\)< < < AH< < < A܏\< < < Az< < < Aۅ< < < A< < < Aڣ< < < Aڣ< < < A
=< < < AG< < < A\)< < < A
=< < < A
=< < < AG< < < A< < < A  < < < AܸR< < < A=q< < < A< < < A< < < A{< < < AQ< < < A  < < < A
< < < A߮< < < A
=< < < A< < < Az< < < A  < < < Aݙ< < < AG< < < A=q< < < A< < < A܏\< < < Aܣ< < < A݅< < < A  < < < A< < < A
< < < A(< < < A< < < A< < < A< < < AH< < < Aff< < < AH< < < A< < < A{< < < Az< < < Aff< < < A
< < < A=q< < < Aޏ\< < < A=q< < < A< < < Ap< < < Aߙ< < < Aޏ\< < < A< < < Aݙ< < < A
=< < < Az< < < A< < < A
=< < < AH< < < A
=< < < A< < < A
< < < AG< <    	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	      	   	      	   	      	   	      	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	      	   	   	   	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	   	      	   	@@@z< @33@@< @33@33@< @@33@\< @ff@  @R< @@@< @ff@  @=q< @ff@ٙ@< @33@  @< @  @@< @ə@ə@ȣ< @@陚@< @陚@  @ff< @ff@ٙ@H< @A   @< A	@@  < AA33A
< AffA  A< A  A   AG< A33AA z< AAffA< A33AffA	< A33AAz< AA33@ff< @33@ff@Q< @  @33@z< @33@33@\)< A   @  @H< @ff@ə@Q< @ff@@  < @ff@@ff< @33@  @\)< @33@  @< @s33@`  @l(< @@@\< @L@fff@zH< @33@ff@< A   A33A< A	A33@R< A   @< @33@ff@  < @33@陚@33< @@ff@< @33@@  < @ff@ff@Q< @ff@  @< @陚@ff@\< @@33@z< @ff@ff@=q< @ə@ə@=q< @ff@ff@< @  @@\)< A@@H< @ٙ@@< @ff@33@\< @ff@@~R< @  @@< @33@33@< @33@33@< @ff@@ҏ\< @  @陚@
=< @  A@ff< @@  @(< @33@  @< @33AA\)< A33A@H< A   AA
< Aff@@=q< @陚@  @
=< @  @  @33< @ə@@
< @  @@33< @33@33@< @33@ff@tz< @s33@l@33< @ff@  @< @@33@< @33@@(< @@@< @ff@@< @33@ə@  < @ff@@< @ff@33@33< @@@< @33@33@33< @33@@p< @33@  @\)< @s33@,@(Q< @   ?  ?p< @?33@G< @   @@\)< @9@333@/\)< @9@@\< @@  @u< @33@Y@;< @fff@l@s33< @l@`  @P  < @L@@/\)< @,@333@p< @,@&ff@< @?ff@ < ?ff?ff?(< ?ff@ff@   < ?  ?ff@
p< @&ff@   @\)< @   @,@
=q< @@   @< ?  ??< @ff@@  @7
=< @&ff@33@0  < @&ff@33@JH< @@  @`  @  < @  @@  @Mp< @9@@  @Q< @@l@G< @ff@  @(< @ff@  @33< @33@AR< A   @y@)< ?ٙ?33?< ?@  @ff< @  @33@< @33@33@
< @ٙ@33@
=< @ə@  @(< @  @33@< @@33@< @@ٙ@Ӆ< @@ff@{< @  @ff@Q< @@ff@z< @陚@@< @  @  @ᙚ< @@@ٙ@@(< @  @  @p< @  @fff@{< @33@@  @jH< @ff@@  @
< @?33?}p< ?33@Fff@qG< @Y@@l< @  @`  @K< @@  @@ff< @@@< @  @  @< @y@  @xQ< @S33@Fff@~{< @33@@< @  @@}p< @y@S33@R< @?33?< ?ff??ff< @9@s33@1< @&ff@9@@  < @@  @S33@0< @33@ff?H< @ff@ff@:=q< @fff@@  @{< @33?ٙ?< ?ٙ?33?
=< @ff@333@Q< @`  @  @{< @@  @
< @33@33@ȣ< @  @ə@< @  @@\)< @@33@\< @,@L@ff< @ff@ff@=q< @33@33@< @@@< @33@@\)< @@@< @33@ff@\)< @  @@< @  @  @nR< @l@`  @R< @@  @c33< @ff@  @^R< @S33@Y@{< @33@Fff@333< @&ff?33@'< @333@  @q< @fff@,@< @333??{< ?  @33@C
< @l@ff@H< @@ff@
=< @@@R< @@ff@=q< @  @ff@Q< @@@(< @ff@@c33< @l@ff@W
=< @33@33@u< @33@s33@o\)< @  @  @q< @Y@`  @l(< @s33@`  @p< @fff@S33@A< @@  @33@y< @  @@Q< @  @l@K< @Fff@&ff@ < @   ?33?< @ff?ff?5< >?ff?< >?333@\< @333@@W< @fff@33@< @33@ff@< @  @  @< @33@ff@
=< @ə@ə@
< @@  @R< @  @  @33< @ff@  @(< @@@
< @33@ff@< @ə@33@\< @  @@\)< @@@< @33@  @x< @s33@`  @=q< @  @9@.R< @@  @Y@@< @33@ff?< ?ff?  ?z< ??ff?  < ?@   ?H< >??R< ?33    ?#
< >L?   @< @33@,@6ff< @&ff@   @H< @   @@  @_\)< @Y@@  @AG< @L@y@q< @s33@  @  < @l@  @{< @y@ff@z< @ff@@< @ff@@Q< @@  @p< @33@@< @ff@ff@{< @ff@@\< @ff@@p< @@ff@z< @@@e< @`  @`  @u< @  @@< @  @9@<< @   ?33?{< ??fff=#
< =    >< >L?33?
=< ?@33@< ?ff@   @\< @33@@Dz< @9@S33@\< @l@fff@xQ< @  @@=q< @@33@=q< @@@
< @ff@@ȣ< @33@33@{< < @\)< < @< < @\< < @w
=< < @C
< < @33< @@?< ?  ?  ?< ?ٙ@S33@l(< @fff@y@Q< @l@  @tz< @`  @@  @[< @33@@< @  @ff@\)< @33@@z< @33@33@< @@  @p< @ff@@^{< @`  @@  @%< @333< @*H< @333@S33@?\)< @@  @L@N{< @Fff@fff@dz< @33@33@z< @y@l@hQ< @fff@333@\< ?  ??.{< ?>    <     @ff?ff< ?33?333?< @ff@ff@+< @Fff@@Mp< @  @ff@Y< @9@Fff@0  < @9@&ff?{< ??ff@
p< @,@L@Mp< @Fff@L@XQ< @@  @L@i< @  @  @\< @@  @
=< @  @@33< @33@ff@< @@  @g
=< ?33@@< @?33@Q< ?ff@ff@  < @Fff@L@XQ< @fff@Y@0< @333@&ff@JH< @L@y@< @  @s33@K< @9@333@\)< @33@33@Q< @33@@6ff< @@  @Fff@3
< @9??
=< @@333@ < ?ff?  ?< ?  ??h< ?  ?33@< ?ٙ?ٙ@Q< @?  ?p< @333@s33@(< @@ff@G< @@,@
=< @S33?33@  < @33@@Fff< ?  @9@8Q< @L@333@(< @33@ff@H< @@L@\< @@ff@\)< @@  @O\)< @Y@333@\)< @&ff@&ff@)< @&ff@   @ff< ?33?33?G< ?333?L?J=q< >    <
< ?  @&ff@@  < @s33@ff@\)< @ff@33@(< @y@l@Z=q< @fff@fff@qG< @  @ff@< @l@Y@Q< @  @s33@{< @S33@ff@r\< @  @33@  < @33@ff@
< @ff@@< @y@`  @H< @S33@Fff@\< @@  @L@!G< ?33@   ?
< ?33??G< ?ff?ff?@  < ?  ?33?\< ?ff??< ?fff?ff?޸R< ?ff?   ?p< ?33?L?  < ?33?33@ff< @33@@  @5< @,@333@-p< @9@@  @8Q< @&ff??8Q< ?@ff@,@y@YAIA;33A$@  @ff@  ?33?fff?  @   ?ff?ff@@@  ?  @@>?L?fff@9@   ??  @&ff@`  @   @   @L@Y@L@s33@@y@  @@  @ff@  @33@@@L@33@ff@@@ff@33@33@33@@@@33@  @33@ff@33@ff@33@33AIA!A33@@陚@ə@ٙ@  A  AffA)A!AffAA&ffA  A  @@陚@ff@@ff@fff@&ff?ff>?333?   ?333?33@Y@  @@33A   A33A@  @ff@ff< @ff@@\)< @ff@ff@AT@`  @@  @33@陚@ff@33@@33@@33@ff@  @S33@l@&ff@l@Y@   @@`  @@@@ff@33@s33@  @33@ff@@@~{< @ff@S33@0  < @333@333@K< @`  @Y@9< @`  @S33@`< @S33@  @p< @33@y@tz< @33@y@p< @  @ff@}p< @33@33@< @@  @nR< @Y@,@\)< @33@9@z=q< @L@  @R< @s33@y@Q< @fff@S33@< @Y@&ff@G< @l@fff@5< @9@@(< @  @L@P  < @@  ?ff?\< @33@9@C33< @&ff@&ff@"\< @@   ?У< @33@,@(Q< @   @@;< @333@Fff@ff< @9@L@R\< @L@l@p  < @  @@ff< @@@{< @ff@ff@33< @33@33@(< @ff@@(< @@@H< @@@ff< @33@  @W< @`  @@  @8Q< @@  @@G< @33@33@ҏ\< @ff@333?< ?ٙ@33?˅< ?33@`  @
=< @  @  @< @33@@< @ff@33@z< @ff@  @< @@33@H< @33@Y@9< @   @y@jH< @fff@l?< @ff@   @A< @,?  @\< @33@ff@E< @@?< @ff@@ < @&ff@,@L< @Fff@,@]p< @L@333@E< @S33@@  @z< @33@   @(< @   @ff@  < @@   @%< @9@Y@333< @S33@`  @  < @  @y@p< @ff@s33@ZH< @   @   ?=q< @&ff@,@< @333@y@H< @33@  @G
=< @9@,@< @&ff@S33@\)< @33?ff?  < ?33?ٙ?(< ?ٙ@#33< @333@@  @ff@33@  @@33@\< @  @@{< @s33@33@@  < @`  @S33@aG< @`  @333@7
=< @@33@7< @33?  @(< @33@&ff@P< @Fff@L@x< @Y@Y@8Q< @,@&ff@+< @?@w
=< @y@L@`  < @L@@{< ?  ?33?\<     ?<
< >L??< ?ٙ?  ?(< ?  @Fff@/\)< ?ٙ?33@< @&ff?33?< ?fff?ff>L< ?@ff?޸R< @@33@%< @@&ff@ZH< @l@33@G< @@@< @33@y@j=q< @Y@ff@p< @  @Ahz< A0  @@p< @33@  @aG< @@  ?@{< @   ?ff?=q< @ff@s33@u< @`  ?ff@,(< @fff@&ff@.{< @,@Y@=p< @L@s33@  < @@s33@=q< @33@  @^R< @l@L@W< @S33@Y@e< @S33@@  @&ff@333@S
< @9@,@C33< @Y@l@{< @l@l@nR< @y@  @^R< @ff@  @\< @ff@  @33< @  @  @=q< @  @  @s33< @lAA\)< A@y@o\)< @33@&ff@y< @l@33@{< @ff@9@*=q< @@  ?ff?R< >=<< >@Y@< @Y@33@{< @@S33@I< @L@333?
=< ?ٙ@?G< @ff@9@7
=< @333?ff?Q< @   @S33@"\< @L@   @(< @@  @`  < ?   >L<< ?   ?  ?z< ?33>?0< ?fff??˅< ?@?{< ???< ?L?L?c
< ??ٙ?
< ?ff?33>< ?  B  AH< @ə??R< ??@33< @l>@"\< @9@33?< ?ٙ@&ff?33< ?@L@c33< @  @  @< @@  @R< @  @@33< @  @ff@H< @33@33@\< @33@,@1G< A33@@=q< @33@s33@< @@33@< @s33@33@< @33@33@e< @l@  @
=< @@@\)< @  @ff@H< @ə@@θR< @@   @(< @33@L@4z< @陚@@
< AffAffA< AffA33A < A33@陚@  < @ff@ə@< @ff@s33@G< @33@  @33< @33@  @{< A33AA{< A  A  Aff< A33AA< A33A@{< A  A  A
=q< AffAffA\)< A33@33A\)< AffA33@z< AA33A< A  A.ffA)G< AA@33< @ə@ffA< A$A8  A=q< @ff@  @Å< @ffA,A?
< AFffAdAU< AQA9A'< A&ffA)A=q< A  A333A7\)< A$AA< AffAAp< A  AffA
< AAA\< A  AA33< AAffAG< A33A  A< AffAAp< AffAAG< A&ffA33A Q< A  AA< A33A!A(Q< A$AA< A  AffA
=< AAffA#\)< A&ffAA&H< AAA< AA$A
< @  @y@(< @&ff@ff?zH< >@fff@< @ff@33@< @陚@  @ᙚ< @陚@  @  < @  @ٙ@{< @ٙ@@< @33@@< @ə@`  @qG< @@  @  @vff< @  @@G< @@ff@< @33@33@
< @  @@y< @fff@@Q< @@ff@ff< @@33@ڏ\< @ffA  A33< AffA	A< A	A33A< A  A  A
=< AAffA
< A33AffA  < AffA33A33< A	AffAff< A33A33A\< A   AAz< AA33A33< AffA  AG< AffAA< A&ffA  A(< AA33A	p< A33A  A{< A@A	G< AAffA{< A	A   @< @@ff@< @ff@33@< @@@Q< @33@ff@ff< @33@33@\)< @  @ff@< @@@ȣ< @ff@33@ڏ\< @ə@@{< @@@< @ff@  @< @ff@33@G< @ff@ə@< @@@z< @33@@
< @@  @
=< @@  @  < @@@G< @33@@H< @ə@ff@< @@  @\)< @33@  @\)< @  @y@s
< @@ff@\< @y@33@Vff< @fff@`  @AG< @`  @`  @W< @`  @  @33< @@@\< @  @@(< @  @  @< @33@  @< @@@z< @ə@33@G<             	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	B  B  B♚< B  B  B33< C  B  B33< C  C  C
 < C  C  C < B  C  C< C  C  C 3< C  C  C
f< C  C
  Cf< C  B  C < B  B  Bff< C  C  C< C  C  B< C  B  Bff< B  B  B33< C  C  C33< C   B  B33< B  C  C < B  C  B< C  C   Cf< C  C  C L< C  C   B< C  B  B< C   B  C 3< C  C  C< C  C  C
< C	  C  Cf< C  C  C3< C  C  CL< C  C  C  < C  C  C< C
  B  C< C   B  B< C  C  B33< B  B  B< B  B  B< B  B  B< B  B  Bݙ< B  B  B< B  C  < B  B  Bff< B  B  B33< B  B  B33< B  B  Bff< B  C  B33< B  B  B< B  B  C L< C  C  C < C  C  C< C  C  C < C  C  C< C  C  C  < C  C  CL< C  C  Cf< C  C  B< B  C  CL< C   C  C
  < C  C  C3< C  C
  C3< B  C  B33< B  B  B33< B  B  B< C  C  C< C  C  Cff< C  C  C< C  C  C33< C  C  Bff< C  C  C< C  C  Cff< C  C  C
ff< C	  C
  CL< C  C  C  < C  C  C3< C  C  C < C  C  C	f< C  C  C< B  C  C   < B  B  BΙ< B  B  B  < B  C  B33< B  C  C< C  C  C< C  C%  C%L< C(  C(  C(< C+  C/  C3f< C3  C=  C>  < CK  CK  C@3< CO  CU  C] < C\  CI  C. < C5  C:  C?33< CA  C=  CF< CC  C5  C/L< C'  C!  CL< C  C  Cf< C!  C7  CE < CD  CI  CQ< C_  CY  CFff< CR  CC  C5< C:  CA  CL< CN  Cf  Cf33< C_  CJ  CG3< CC  CO  C?< C=  C5  CE< CJ  C@  C=  < CP  CM  CR  < C]  CK  CXf< CZ  Ck  C&f< Cr  Cm  CY< C  C  Cf< Cw  C Cff< C C  C< C C  C@ < C  C  CL< C  C}  C < C  C{  Cgf< C^  Ca  Ce3< Ce  Cc  Ch33< Cg  C|  C< C @  BA(< Bh  C  C  < C0  C  C< C C Cs3< C  C  C@ < C  C C33< C  C C3< C  C  @7
=< C C  CY< @   C C< C      C&f< C @   >ff< C     @	< C ?  @$z< @  ?  ?h< @   ?  C  C  CL< C C C&f< C C B}ff< Bh  B  CL< BP  B  B< B  B  C!ff< C6  C#  C>< CQ  CX  CW< CT  C]  CX < CB  C  ?G< C  B   A
=< A  A  Ap< A  A  Aff< A  A`  AP(< A  A  A< A  Ap  Ao< A@  @  An{< A  A  A:\< @  C C< C C  C@ < C  C C< C  C  @L(< A  A  A< Ap  C C< C  C  CL< C C C < C Cz  C{33< C}  Cq  C]  < C_  Cf  Cc< Cf  Cp  Ckff< Ci  C`  CYf< Cc  Cb  C]  < CZ  CW  Ce3< Ce  Cf  Ck33< C~  C  C~< C}  C|  CL< C  C  C3< C  C C3< C  C C < C  C CL< C  C  C < C  C  C< C  C C< C C  Cs3< C  @  AH< A  A0  A< B$  B8  B{< B  B@  B5
=< Bd  B  Bb< B  B  B  < B  B  B< B  B  B< C  C&  C?  < C?  CU  CX  < CU  CM  CM33< CR  CQ  CP< CS  Cd  Cef< C_  Ci  Cj33< Co  Cu  Cw< C{  C  Crf< Cv  Cy  Cjf< Cl  Cg  CfL< Ca  Cc  CZ< CW  CU  CZf< CZ  Cf  Cp3< Cs  C  C  < C{  C}  Cff< C C  Cff< C C C3< C  C  CY< C  C  CY< C  C C< C  C  Cٚ< C  C  C < A  C  C9< C6  C.  C/< C5  C4  C7ff< C<  CC  CG< CE  CJ  CO< CJ  CG  C@ff< CA  CA  CL33< CM  CL  CO< CR  CO  CSff< CZ  CX  CT  < CT  CR  CQ< CP  CT  CZ< CU  C^  C]< C^  Cd  Cjf< Cm  Cr  Ck33< Cq  Cz  C|< C Ct  Cn< Ct  Cy  Cs3< C C C  < C  Cq  Cn< Cl  C  Cff< C  C  C< C  A   C3< Ap  C C< C  C Cp  < Cd  C1  C. < C4  C9  C5 < CE  CI  CKff< CA  C5  C8< CG  CI  CO< CU  CJ  COff< CL  CP  CNf< CS  CH  CNf< CJ  CB  CCL< CD  C@  CA< CA  CD  CD< CD  CE  CA< CE  CF  CH  < CM  CE  CB3< CJ  CH  CIff< CJ  CJ  CNff< CQ  CN  CL< CO  CQ  CL< CJ  CS  Ca3< Cc  C[  Cd3< Ca  CJ  CH< CN  C>  C4f< CD  CS  CL< C      C> < CI  C3  C@3< C-  C  C$< C)  C0  C< C!  C)  Cf< C  C  CL< C  C   C3< C"  C  C < C  C   C%L< C#  C%  C%< C$  C%  C%f< C)  C%  C&3< < C%< < C*< < C%L< < C/3< < C8< < C9f< CD  C0  C< B  B  Bff< B  B  B< B  B  Bff< B  B  Bq< B  B  Cf< C  C  C< C  C	  C3< C  C  Cf< C
  C
  Cf< C  C  C < C  C  C3< C  C  C< C  < CL< C  C  C  < C  C  C3< C  C)  C633< C:  CC  CL  < CA  CD  C9L< C:  CF  CBL< CP  Co  C  < C  C     <     B   B7z< B8  Bl  Bz< B$  BL  B:
=< BH  B@  B(< B  B  A{< A  B  AR< @  AP  @p<     C C3< C C C  < C C  C  < Cy  C  Cv< C{  Cy  Cw< Cz  C C < C C  Cf< C C C< C C  Cf< C @@  C< C C C&f< C C  ?  < @  A`  B*< Bt  B  BM\< B   B`  B33< B  B  B33< B  B  Bff< B  C  C < C  C)  C8 < C@  C[  Cq33< Cn  Cq  Cu  < C|  C  C< A  B8  B_z< B\  Bx  B:< B$  A  Bfz< B  B  B< B  B  B< B  C  C-3< C=  C   C3< C$  C)  C= < C/  C  C
33< C  B$  B-< B   C  B=q< B  C  CL< B  C  C	< C  B  C3< C  C"  C+< C0  C,  C+< C.  C*  C/< C3  C3  CA< CM  CU  CNf< CE  Cf  Cl  < Cw  C{  CU3< CG  C}  C< C C A(< A  A  B=q< B  B<  B8< B\  B  B#< B  B  B33< B  B  B< B  B  Bff< B  B  B  < B  B  B  < B  B  C< C  C/  C%< C0  C,  C(< C,  C3  C)< C+  CG  CO< CZ  C]  CW< CO  CY  CC< CC  CD  C?< C<  C1  C4< C+  C5  Cff< C  C#  C-f< C#  C@  CR  < CS  Cy  Cr  < Cs  C  C< C  C C< C  B   A< A  BH  BRH< B\  Bx  Bff< B  B  Bff< B  Bt  C]3< C]  C+  C  B  B  @  C  C  C C  A   A  B  C  C  C%  Bp  BT  B  B,  A  B(  B  C	  C  C]  CB  C1  B  B   B  B  B  B  B  B  B  B`  B  B  B  B  B  B  B  B  B  B  B  C  C  C  C  C+  C;  C<  CD  CT  CM  CP  CD  CW  CW  CQ  CM  CO  CP  B$  A  C Cu  CO  Ch  C^  C<  Cc  Cg  C_  Ct  Co  C  C}  C}  Cy  C  C  C}  C  C C  C A`  C C  Bl  CA  C>  C5  C[  Ct  Ca  Ch  Cd  Cc  Ce  Ce  C] < CZ  CX  C]3< C]  C\  C`  A  C%  CQ  Ci  Ct  Cs  C  C{  Cz  Cp  Cr  Cn  Cr  Cu  Cp  Cn  Cm  Ce  Cb  Cd  CY  C\  CY  CP  CO  CU  Ca  C]  Ca  Cg  Ct  Cs  Ch  Cb  < C`  Cc  Cj< C[  CS  CV  < CO  CN  CHf< CQ  CM  CZ3< CW  CX  CYff< CT  CE  C>ff< C@  C<  CO33< CK  C?  C5f< C;  CF  CE< CG  CF  C>  < C4  CB  C<33< CD  C3  C3< C-  C&  C*L< C1  C<  C8< C-  C8  C03< C3  C<  C$  < C#  C!  C!< C  C!  C&ff< C  C  C < C  C  Cff< B  C  B33< B  B  C  < B  B  Bff< C  C  C < C
  B  C< B  C  Cf< C"  C)  C'33< C#  C'  C33< C  C   C< C   C   Cff< C  C  CL< C"  C  C
L< C
  C  C < C   C  Cf< C  C  C  < C  C$  C* < C3  C   C< C  B  B< B  C!  C-L< C$  C	  C+< C  B  B33< B  A  Bz< B  Bh  BQ< B  B  B  < B  B  Bff< B  B  B33< B  B  Bf< B  B  B< B  B  B)< B  B  C  < B  C   CE3< CF  Cy  C< C  C A{< ?  C  Cs3< C C  C3< C  C C < C Ct  Cٚ< C  C  C}< C  C|  Cn33< Cj  Ce  Cb3< Ck  Cw  C< C C~  Cx33< Cc  Cp  C|  < Cw  Cw  C} < Cx  C C< C  C  C  < C  A  A)< A  B$  B< B  A  A(< A  A  B!< A  A`  BC< B  B  B< B  B  Bff< C  C  C0< C+  C3< C  C7  C9  C=  CC  C?  C9  C6ff< C>  C8  C53< C9  C:  C>  < C@  CE  C; < C=  C-  C?< CB  C6  C2f< C:  C)  C0< C7  C)  C/L< C6  C5  C8< C9  CB  CI< CF  Cf  CX< CF  A  A8z< C C  Bx
< B8  C  C< C  C  C  <     C  B  < Bx  B  B1H< B  B  B2H< BT  B,  A< A  B  Bff< B  B  BG< B  A  Cff< C9  C#  C3< CA  CD  CG3< CB  CK  CB< C:  C$  C% < C'  C*  C%L< C'  C'  C(< C%  C,  C/ < C/  ?  Bff< B  C  C!f< C-  Cm  C< C C  C< A  @  C@ < A@  B  Bp< B  C  B#< B  B  B< B  B@  Ao33< A  A  BV< B@  Bx  B< B  B  B< B  B  BǮ< B  B  B)< B  B  B  C
  C33< C!  C  C-ff< C'  C-  C&f< C3  C*  C9 < C=  C5  CF < CP  CH  CLf< CT  Ck  Cg < Cb  Cr  CxL< Cx  C{  CY< C A  BoG< B  B  B< B  C  B33< B  B  B䙚< B  C  C< C  C  B  < B  C-  A< A  A  AfH< A  A  A33< B  C C&f< C  C  Cf< @@  C CY< C  A  B< B\  B  B}Q< B  B  B33< B  B  @(< A  B`  C3< BP  C  C < C  Ce  Cf< Cz  C?  CL< C  C!  C$< C/  C4  CK< CM  CZ  CXf< CI  C6  CL< C  C  C  < C  B  C,< C  C;  C03< C3  B  B< B  C B< C+  C|  CY< C C A  < A  B  Bf< B  B  BaH< B  B  Bk< B  Bl  B(< B  Bx  B< Bx  B  Bq< B  B  Bff< B  C	  C < C C AH< A  B\  B*< BP  B  B33< B  B  B< B  B  B< B  B  B̙< B  B  Bff< B  B  Bff< B  B  Cf< C(  C  C< C  C
  C	33< C  C  C ff< C
  C	  Cff< C
  C
  C < C  C  C
< C
  C  C< B  B  B  < B  B  BG< B  B  Bh\< Bl  B  B
=< Bt  Bh  Bn< Bx  B\  BiQ< B`  BH  BB
=< BL  B<  BI< BL  B8  BI33< B<  B4  B=Q< B  B  B)
< B<  B8  A< A  B   Bp< B  B   AM< C A  Bm{< Bp  Bh  @33< C @  @\< @  B(  B'  < B,  B$  B< B$  B  B	  < B  B  Bff< B  B  B-\)< B4  B   B\)< B  A  Az< B  A  A(< A  A  Abff< A`  A  A^ff< A@  A0  A=q< A  A  A-G< @  C  @p< @  C  @G< A  C C3< C C  @< ?  C Cs3< C C C  < C C C33< C  C Cٚ< C C C3< C  C C@ < C C CL< B  B   A\)< C A  A|  < C C  C33< C  C C&f< C  C C < C  C  Cf< C C  C  < C C  C3< C C C < C  C Cٚ< C C  C< C C  C3< C  C  C< C C C  < C  C CL< C Ck  Chf< Ck  Co  Ck < Ci  Cl  Cd< Ce  C\  C[ < C^  C`  C`L< C[  C^  CZ< CW  CY  CU< CS  CV  CV < CW  CT  CV < CZ  CX  C[33< C^  CU  CRff< CO  CO  CN< CS  CT  CV  < CT  CO  CP< CS  CT  CJ< CI  CG  CG< CG  CR  CNf< CI  CM  CO3< CJ  CG  CJ< CM  C=  C>  < C=  C9  C>< C<  CD  CF3< CS  CV  C]33< C\  CD  CYf< CN  CI  C1 < CA  CE  C:< C0  CO  CI  < CJ  CL  CD33< CL  CL  CP< CQ  C9  C7f< C=  C@  C?L< CC  C@  C=3< CF  C>  C8f< C<  C?  CEL< CC  CB  C@3< C@  C?  C;< C>  C?  C?33< CA  C9  C<  < C<  C?  CH < CI  C@  C< < C>  C9  C83< C8  C8  C>33< C:  C<  CAf< CD  CB  CE  < CK  CC  CU< CL  CK  C@< CA  C6  C@< CA  C>  C<f< CD  C9  C4 < C2  C0  C.< C2  C7  C8< C7  C<  C?< CB  CA  CC33< C?  C;  C8  < C4  C6  C4ff< C:  C<  C/  <             	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < < < < < < < < < < < < < < < < < < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  < < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  < < B  B  < < B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  < < B  B  B  B  B  B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < < B  B  < <             	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	   	      	   	      	   	      	   	      	   	      	   	      	            	            	            	            	            	            	            	            	            	            	            	            	            	      	      	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                                                                                                                                                                                                                                                                                                                                    	            	                                                                                                                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	         	                           	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	                  	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	            	< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < <    	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < <    	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	< < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < < <    	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	   	A  A< < AffA\)< < AA< < A33A< < AA< < A  A(< < A  AQ< < AəA< < AffA(< < A  A  < < A  AG< < AffA=q< < A͙Aff< < A33A< < AA
=< < A33Az< < AݙAم< < AffAڏ\< < AA{< < AA33< < A  AڸR< < A  Az< < AٙAָR< < AffA
=< < AՙA{< < A  A< < AA{< < A  A
=< < A  Aϙ< < AffAQ< < AffA< < AəA{< < AffA< < AA< < A33A< < AA< < AAz< < A33A< < AA{< < AA< AřA{< < AřA(< < AA< < A33A\)< < AAH< < AA< < AA{< < A33A< < AffA< < A  Aff< < A  A< < A  A\)< < A  A< < AffA33< < AffA33< < AffA  < < A33AH< < AffA< < AA< < AA< < A33A< < A  A\)< < A33A< < A33A\< < A  A< < AA< < A33AQ< < A  A\< < AA\< < AAz< < A  A
< < A33A< < A33A=q< < A33A< < AAff< < AffA< < AffA=q< < AA< < AffA< < A33A\)< < A33Ap< < A  Aff< < AffA< < AffA
=< < AA\< < AA< < A33A=q< < A33A< < AA< < AA
< < A33A< < AA\)< < A33A< < AffA
=< < AA< < A33A< < AA
=< < A  A< < AffA< < AA{< < AffAQ< < AffA< < AffA< < A  A< < A  A< < AA< < AA
=< < AffAQ< < AffA\)< < AffA  < < AA< < AA< < AAz< < A  A< < AffAff< < AAp< < AA=q< < AffA< < A  Ap< < AA{< < A  A< < AA< < A33Ap< < AffA< < AA< < A  A< < A  A(< < AA{< < A  A
=< < A33A< < AffA\< < AAz< < AffA
< < A33AffAA< < A  A< < A33Aff< < AAR< < AAp< < AA(< < AffAz< < AffA=q< < AAH< < A  A33< < A33A< < AffA< < AA\)< < AAR< < AA< < AA< < AA
=< < AA(< < AffAG< < AffA< < A33A\)< < A  A  < < AAR< < AffA{< < AAp< < AA  < < AAz< < AA
< < AA< < A  A< < AA(< < AA< < A33A< < A33AG< < AA
=< < AffAz< < AAff< < AffA< < AffA< < A33Az< < A33Ap< < AAQ< < AA33< < AA\)< < A  A\< < AA< < AA  < < AA=q< < A33A33< < A33Az< < A33A< < A33A< < AffAp< < A33A< < AffAz< < AffA< < AffAH< < A33A
=< < AffA  < < AAz< < A33A(< < AA\)< < AffAG< < AA=q< < A  A=q< < A  A=