shipname = 'Neil Armstrong'
cruiseid = 'ar17_01'
yearbase = 2017
uhdas_dir = '/home/data/ar17_01'

# from proc_cfg.py:

## for processing
##----------------
## ship name: shipname = 'Neil Armstrong'
## at-sea "proc_cfg.py" initialized date = '2016/02/19 13:37:53'
##
## This file starts as /home/adcp/config/proc_cfg.py and
## includes the following information.  Uncomment, left-justify
## and fill these in if you are attempting to generate proc_cfg.py
## from this template.  The file must be named {cruiseid}_proc.py
## or for this example, kk1105_proc.py
##
## example values: fill in for your cruise...
#
# yearbase = 2011                  # usually year of first data logged
# uhdas_dir = '/home/data/kk1105'  # path to uhdas data directory
# shipname = 'Ka`imikai O Kanaloa' # for documentation
# cruiseid = 'kk1105'              # for titles
#
#

#======== serial inputs =========

# choose position instrument (directory and rbin message)

pos_inst = 'cnav'
pos_msg = 'gps'

# choose attitude  instruments (directory and rbin message)

pitch_inst = 'posmv'     # pitch is recorded, but NOT used in transformation
pitch_msg = 'pmv'      # disable with '' (not None)

roll_inst = 'posmv'      # roll is recorded, but NOT used in transformation
roll_msg = 'pmv'       # disable with '' (not None)

hdg_inst = 'gyro'       # reliable heading, used for beam-earth transformation
hdg_msg = 'hdg'


## heading correction
## all heading+msg pairs, for hbin files
hdg_inst_msgs = [
    ('gyro', 'hdg'),
    ('posmv', 'pmv'),
    ('gyro2', 'hdg'),
#    ('phins', 'hdg'),
]

## instrument for heading corr to ADCP data (dir and msg)
hcorr_inst = 'posmv'       # disable with '' (not None)
hcorr_msg = 'pmv'        # disable with '' (not None)
hcorr_gap_fill = 0.0   ## fallback correction for hcorr gaps
                     ## calculate hdg_inst - hcorr_inst, eg gyro - ashtech
                     ## SAME SIGN CONVENTION as cal/rotate/ens_hcorr.ang

## if there is a posmv
acc_heading_cutoff = 0.02

# =========== ADCP transformations========
# historically, values were substituted into cruise_proc.m
# now, in Python, they are used directly

# heading alignment:  nominal - (cal/watertrack)
h_align = dict(
     os150 = 58.3, ### 43.1 - (-15.2) 
      os38 = 47.5,   # 47.8 - 0.3 2016/02/20
     wh300 = 54.4,
)

# transducer depth, meters
ducer_depth = dict(
     os150 = 4,
      os38 = 4,
     wh300 = 4,
)

# velocity scalefactor
# see SoundspeedFixer in pycurrents/adcp/pingavg.py
scalefactor = dict(
     wh300 = 1.0,
   os150nb = 1.0,
   os150bb = 1.0,
    os38bb = 1.0,
    os38nb = 1.0,
)

# soundspeed
# Soundspeed is usually None, and should ALWAYS be left as None for Ocean Surveyor
# (it is remotely possible that soundspeed for a WH, BB, or NB might need to
#           bet set to a nnumber, but usually that just results in an erroneous
#           scale factor.
soundspeed = dict(
     wh300 = None,
   os150nb = None,
   os150bb = None,
    os38bb = None,
    os38nb = None,
)

# salinity
salinity = dict(
     wh300 = None,
   os150nb = None,
   os150bb = None,
    os38bb = None,
    os38nb = None,
)

#=================================================================
# =========           values for quick_adcp.py          ==========
# ========= These are set here for at-sea procesing,    ==========
# ========= but are REQUIRED in quick_adcp.py control   ==========
# =========  file for batch mode or reprocessing.       ==========

## choose whether or not to use topography for editing
## 0 = "always use amplitude to guess the bottom;
##          flag data below the bottom as bad
## -1 = "never search for the bottom"
## positive integer: Only look for the bottom in deep water
##      "deep water" defined as "topo database says greater than this"

max_search_depth = dict(
     wh300 = 500,
   os150nb = 1000,
   os150bb = 1000,
    os38bb = 2000,
    os38nb = 2000,
)

# special: weakprof_numbins
weakprof_numbins = dict(
     wh300 = None,
   os150nb = None,
   os150bb = None,
    os38bb = None,
    os38nb = None,
)

# set averaging intervals
enslength = dict(
     wh300 = 120,
   os150nb = 300,
   os150bb = 300,
    os38bb = 300,
    os38nb = 300,
)

# Estimate of offset between ADCP transducer and gps
# this has one value per instrument
# ADCP (dx=startboard, dy=fwd) meters from GPS
# specify integer values for 'xducer_dx' and 'xducer_dy' for each instrument,
#      as from cal/watertrk/guess_xducerxy

xducer_dx = dict(
     os150 = 4,
      os38 = 6,
     wh300 = 7,
)
xducer_dy = dict(
     os150 = 12,
      os38 = 12,
     wh300 = 12,
)

