# This configuration file is Python code.  You should not
# need to change it; but if you do, you need to know that
# in Python, the *indentation matters*.

# The following will normally be empty lists, like this:
#
#ignore_ADCPs = []
#ignore_other_sensors = []
#
# But if you want to run with only a subset of the ADCPs
# and/or ancillary sensors that are defined in this file,
# you can list the ones you want to ignore like this:
#
#ignore_ADCPs = ['wh300', 'os38']
#ignore_other_sensors = ['GPS']
#
# In this case, you are listing the 'instrument' field of each
# ADCP or sensor you wish to exclude.
#

ignore_ADCPs = ['']
ignore_other_sensors = ['']
#use_publishers = True
use_publishers = True


# 2-letter abbreviation for logging file prefix and constructing dbase name;
# read by procsetup.py
shipabbrev = "ar"


ADCPs = [
        { 'instrument'  :  'wh300',
          'setup'       :  'rdi_setup',
          'terminal'    :  'oswh_term',
          'defaultcmd'  :  'wh300_default.cmd',
          'commands'    :  ('CL0',),  # is required to make bottom track work?
          'datatypes'   :  ('wh300',),
          'wakeup_baud' :  9600
        },

        { 'instrument'  :  'os150',
          'setup'       :  'rdi_setup',
          'terminal'    :  'oswh_term',
          'defaultcmd'  :  'os150_default.cmd',
          'commands'    :  ('EA04500',),              #preliminary
          'datatypes'   :  ('os150bb', 'os150nb'),
          'wakeup_baud' :  9600
        },


        { 'instrument'  :  'os38',
          'setup'       :  'rdi_setup',
          'terminal'    :  'oswh_term',
          'defaultcmd'  :  'os38_default.cmd',
          'commands'    :  ('EA04500',),              #preliminary
          'datatypes'   :  ('os38bb', 'os38nb'),
          'wakeup_baud' :  9600
        },


        ]


# Do not edit the next three lines:
common_opts = '-f %s -F -m 1 -H 2 ' % (shipabbrev,)
nb_opts =   '-rlE -c -I'          # raw data, write a log file, log errors
oswh_opts = '-rlE -c -O -I'       # -O for OS/WH data format
                                  # -c for checksum, -I to initiate pinging

sensors = [


        { 'instrument'  :  'wh300',
          'device'      :  'ttyUSB0',
          'baud'        :   9600,
          'format'      :  'binary',
          'subdir'      :  'wh300',
          'ext'         :  'raw',
          'opt'         :  oswh_opts},


        { 'instrument'  :  'os150',
          'device'      :  'ttyUSB1',
          'baud'        :   19200,
          'format'      :  'binary',
          'subdir'      :  'os150',
          'ext'         :  'raw',
          'opt'         :  oswh_opts},

        { 'instrument'  :  'os38',
          'device'      :  'ttyUSB2',
          'baud'        :   19200,
          'format'      :  'binary',
          'subdir'      :  'os38',
          'ext'         :  'raw',
          'opt'         :  oswh_opts},

#        { 'instrument'  :  'PhinsIII',
#          'device'      :  'ttyUSB3',
#          'baud'        :   9600,
#          'format'      :  'ascii',
#          'subdir'      :  'phins',
#          'ext'         :  'hdg',
#          'strings'     :  ('$HEHDT',),
#          'messages'    :  ('hdg',),
#          'opt'         :  '-tc'},

        { 'instrument'  :  'POS/MV',
          'device'      :  'ttyUSB4',
          'baud'        :   9600,
          'format'      :  'ascii',
          'subdir'      :  'posmv',
          'ext'         :  'pmv',
          'strings'     :  ('$INGGA', '$PASHR'),
          'messages'    :  ('gps', 'pmv'),
          'opt'         :  '-tc'},


        { 'instrument'  :  'CNAV GPS',
          'device'      :  'ttyUSB5',
          'baud'        :   9600,
          'format'      :  'ascii',
          'subdir'      :  'cnav',
          'ext'         :  'gps',
          'strings'     :  ('$GPGGA', '$GNGGA', '$INGGA', ),  #use ('',) for all
          'messages'    :  ('gps',),
          'opt'         :  '-tc'},


        { 'instrument'  :  'Gyro-Sperry2',
          'device'      :  'ttyUSB6',
          'baud'        :   4800,
          'format'      :  'ascii',
          'subdir'      :  'gyro2',
          'ext'         :  'hdg',
          'strings'     :  ('$HEHDT',),
          'messages'    :  ('hdg',),
          'opt'         :  '-tc -s10'}  ,

        { 'instrument'  :  'Gyro-Sperry1',
          'device'      :  'ttyUSB7',   #ttyR5 for comtrol
          'baud'        :   4800,
          'format'      :  'ascii',
          'subdir'      :  'gyro',
          'ext'         :  'hdg',
          'strings'     :  ('$HEHDT',),
          'messages'    :  ('hdg',),
          'opt'         :  '-tc -s10'}  ,


#
#        { 'instrument'  :  'Gyro_dup',
#          'device'      :  'ttyS6',   #ttyR5 for comtrol
#          'baud'        :   4800,
#          'format'      :  'ascii',
#          'subdir'      :  'gyro_dup',
#          'ext'         :  'hdg',
#          'strings'     :  ('$HEHDT',),
#          'messages'    :  ('hdg',),
#          'opt'         :  '-tc -s10'}  ,
#

]



## enabling or disabling this occurs in uhdas_cfg.py
## speedlog: enabled in /home/adcp/config/uhdas_cfg.py
speedlog_config = {
    'instrument'        : 'os150',  ## wh300 is disabled
    'serial_device'     : '',     # no serial out (else: '/dev/ttyUSB1',)
    'baud'              : 9600,
    'zmq_from_bin'      : "tcp://127.0.0.1:38010",  # port to read os150 indexing
    'pub_addr'          : "tcp://127.0.0.1:38020",  # port to publish speedlog #NO SPACES
#    'heading_offset'    : xx.x,  # defaults to h_align; better would be from EA_estimator.py
    'scale'             : 1.0,     # multiplies velocity measurement
    'bins'              : (1,3),   # zero-based; input to python slice()
    'navg'              : 5,       # pings to average
}


## this section describes...
publishers = [
               {
               'subdir'      :  'cnav',
               'pub_addr'    :  'tcp://127.0.0.1:38000', # uses this port
               'sample_opts' :  '-tc -s60',
               },
             ]

#### DO NOT CHANGE the following ################

ADCPs = [A for A in ADCPs if A['instrument'] not in ignore_ADCPs]
sensors = [S for S in sensors if S['instrument'] not in ignore_ADCPs]
sensors = [S for S in sensors if S['instrument'] not in ignore_other_sensors]



if use_publishers==True:
    from uhdas.uhdas import make_publishers
    make_publishers.modify_sensors_and_publishers(sensors, publishers)
