

shipkey = 'ar'
## ship key must match shipletters in sensor_cfg.py
# shipname = 'Neil Armstrong'

# This file generated on
# date = '2016/02/19 13:37:53'

# for data acquisition (timers, paths, commands)
#================================================

# for DAS_while_cruise.py
#-------------------------
# List of paths to backup "data" subdirectories.  Within each such
# subdirectory, the cruise data directory (e.g., km0507) will
# be found.  If the active cruise is "km0507", then rsync will
# be called periodically to copy the contents of /home/data/km0507
# to data/km0507 in each path in the list.
backup_paths = [
    '/disk2/home',
]

# turns off gzipping (for R2R)
gzip_serial_files = False

# Interval in seconds between backups, usually 3600
rsync_t = 3600

# for DAS_while_logging.py
#--------------------------

# Interval in seconds between ensemble updates:  300sec
short_t = 300

# Interval in seconds between database updates:  1800sec (30min)
long_t = 900

# Working directory for calculations and intermediate products:
workdir = '/home/adcp/uhdas_tmp'

# Command string to start up the speedlog
# Empty string '' or  None to disable the speedlog.
# NOTE: only supported with NB150
speedlog_cmd = '/usr/local/currents/bin/DAS_speedlog.py'


# for web plots and quality monitoring
#=====================================

## daily.py will generate statistics on these devices
## and quality plots will go on the web site on the short_t timer
## ==> This is now derived by uhdas.uhdas.proc_setup (from values
##     in hdg_inst_msgs, in proc_cfg.py) but it can be overridden
##     here as a list of heading instruments, eg ['posmv', 'adu5']

##ocean surveyor beam statistics;
# disable is emtpy, i.e.  [], else list plot types
beamstats = [
    'scattering',
    'velocity',
]

## shallowest bin to plot
top_plotbin = dict(
     wh300 = 1,
   os150nb = 1,
   os150bb = 1,
    os38bb = 1,
    os38nb = 1,
)

## which sonar will be used for kts+dir 5-minute bridge plots?
#prioritized list of strings (sonar)
kts_dir_instrument = [
    'wh300',
    'os150bb',
    'os150nb',
    'os38bb',
    'os38nb',
]

#####################################

# for daily.py:
#--------------

# Each email "mailto" must be a list of email addresses:
#        ["et@this_ship.podunk.edu", "guru@podunk.edu"]
# An empty list (no addresses) is : []

email_comment_str = ''

tarball_mailto = [
    'uhdas@soest.hawaii.edu',
]

local_status_mailto = [
    'sssg@armstrong.whoi.edu',
]

shore_status_mailto = [
    'uhdas@hawaii.edu',
    'efiring@hawaii.edu',
    'dropbox@rvdata.us',
    'uhdas@soest.hawaii.edu',
    'fbahr@whoi.edu',
    'sssg@whoi.edu',
    'lstolp@whoi.edu',
]

##################

SMTP_server = '192.147.41.2'
mail_from = 'adcp@armstrong.whoi.edu'
use_SSL = False

