
#!/usr/bin/env python

## written by quick_mplplots.py -- edit as needed:

## cruiseid      is 'ADCP'
## dbname        is 'a_ar'
## proc_yearbase is 2017
## printformats   is 'png'

import matplotlib.pyplot as plt





from pycurrents.adcp.quick_mpl import Btplot

## other parameters that can be chosen:
##   name            default
##   ------        --------------
##   dbname           (found in ../../adcpdb)
##   titlestr         (uses ADCP
##   proc_yearbase    (first year in database)
##   load_only                  False   # no output
##   printformats               'pdf'
##   dpi                        100
##   outfilebase               'btcal'
##   ddrange                    'all'
##   step                       1
##   min_speed                  2
##   max_sig                    2.5
##   max_gap                    0.1
##   tol_dt                     0.02
##   min_depth                  25                #shallower for high freq
##   max_depth                  1500
##

BT = Btplot()
BT(btm_filename='a_ar.btm',
   ref_filename='a_ar.ref',
   cruiseid = 'ADCP',
   min_depth = 80,
   max_depth = 1800,
   printformats = 'png',
   proc_yearbase='2017')

plt.show()
