shipkey = 'we'
#shipname = "Wecoma"


# for DAS_while_cruise.py
#-------------------------
# List of paths to backup "data" subdirectories.  Within each such
# subdirectory, the cruise data directory (e.g., km0507) will
# be found.  If the active cruise is "km0507", then rsync will
# be called periodically to copy the contents of /home/data/km0507
# to data/km0507 in each path in the list.

## backup paths (mount points)
backup_paths = ['/disk2/home', '/net/vega/home']


# Interval in seconds between backups

rsync_t = 3600

# for DAS_while_logging.py
#--------------------------

# Interval in seconds between ensemble updates:

short_t = 300

# Interval in seconds between database updates:

long_t = 1800


# Working directory for calculations and intermediate products:

workdir = '/home/adcp/uhdas_tmp'

# Command string to start up the speedlog; empty string or
# None to disable the speedlog.  Do not include a trailing '&'.

speedlog_cmd = None #' /home/currents/programs/uhdas/uhdas/DAS_speedlog.py '

# for processing
#----------------
# (1) values substituted into cruise_cfg.m (for matlab)


### choose the instrument to use for heading correction.  options:
#  'gyro', 'ashtech', 'posmv', or 'seapath'
## This will be substituted into cruise_cfg.m, where matlab looks for it
hcorr_inst = 'ashtech'  ## 'gyro', 'seapath', 'ashtech', ''

pos_inst = 'gpsnav'  # pcode reciever, no pcode
pos_msg  = 'gps'

hdg_inst = 'gyro'
hdg_msg =  'hdg'

pitch_inst = 'ashtech'
pitch_msg = 'adu'

roll_inst = 'ashtech'
roll_msg = 'adu'


# (2) values substituted into cruise_proc.m  (for matlab)

# heading alignment:  nominal - (cal/watertrack)
h_align = {}
h_align['os75']  = -42.6
h_align['wh300'] = 44.6     #44.3 - (-.3) = 44.6 Oct 2008

# transducer depth, meters
ducer_depth = {}
ducer_depth['os75']   = 5
ducer_depth['wh300']  = 5

# optional: weakprof_numbins
# weakprof_numbins = {'os75bb' : 2}

# velocity scalefactor
scalefactor = {}
scalefactor['os75bb']  = 1.0     ## this should be the default
scalefactor['os75nb']  = 1.0     # then it could mostly be left out
scalefactor['wh300']   = 1.0

# soundspeed
soundspeed = {}
soundspeed['os75bb'] = None      # NOTE: use 'calculate' for NB150
soundspeed['os75nb'] = None      #    if instrument was configured that way.
soundspeed['wh300'] = None

# salinity
salinity = {}
salinity['os75bb'] = None       ## NOTE: use fixed value such as 34.5 or 35.0
salinity['os75nb'] = None       ## for NB150 if using 'calculate' for soundspeed
salinity['wh300'] = None

# (3) values for quick_adcp.py

## choose whether or not to use topography for editing
## uses smith,sandwell version from about 2004
use_topo4edit = True

# averaging interval (seconds) usually 300.  might use 120sec for wh300
enslength = {}
enslength['os75bb']  = 300
enslength['os75nb']  = 300
enslength['wh300'] = 120

# (4) values for web plots and quality monitoring

## daily.py will get statistics on these (assumes correct messages are logged)
## and quality plots will go on the web site on the long_t timer
attitude_devices = ['ashtech']    # string or list of strings

# new section, to create cruise_proc.m
# all dictionaries must be filled

## for quick_adcp.py: # initialize; # fill
## going to be top_plotbin
top_plotbin = {}
top_plotbin['os75bb'] = 1
top_plotbin['os75nb'] = 1         ## set deeper, eg 2, if instrument has ringing
top_plotbin['wh300'] = 1

# set overrides for jitter
jitter = {}
#jitter['os75bb'] = None   # use quick_adcp.py default
#jitter['os75nb'] = None   # use quick_adcp.py default
jitter['wh300']  = 40


## which virtual instrument will be used for kts+dir 5-minute bridge plots?
## going to be kt_dir_instlist ['os75nb', 'os75bb']
kts_dir_instrument = ['wh300', 'os75nb', 'os75bb']


#####################################

# for daily.py:
#--------------



# Each email "mailto" must be a list of email addresses:
#        ["et@this_ship.podunk.edu", "guru@podunk.edu"]
# An empty list (no addresses) is : []


tarball_mailto  = ["uhdas@soest.hawaii.edu"]
## to avoid mailing tarball, do it this way:
# tarball_mailto = []


# from outside, mail to:  martech@wecoma.shipops.oregonstate.edu
# includes web links on currents:
local_status_mailto   = ["martech@concord.wecoma",]


shore_status_mailto  = ["hummon@hawaii.edu", "efiring@hawaii.edu", "toby@coas.oregonstate.edu"]

SMTP_server     = "mail.wecoma"
mail_from       = "adcp@wecoma.shipops.orst.edu"


