# This configuration file is Python code.  You should not
# need to change it; but if you do, you need to know that
# in Python, the *indentation matters*.

# The following will normally be empty lists, like this:
#
#ignore_ADCPs = []
#ignore_other_sensors = []
#
# But if you want to run with only a subset of the ADCPs
# and/or ancillary sensors that are defined in this file,
# you can list the ones you want to ignore like this:
#
#ignore_ADCPs = ['wh300', 'os75']
#ignore_other_sensors = ['GPS']
#
# In this case, you are listing the 'instrument' field of each
# ADCP or sensor you wish to exclude.
#

ignore_ADCPs = []
ignore_other_sensors = []

# 2-letter abbreviation for logging file prefix and constructing dbase name;
# read by procsetup.py
shipabbrev = "we"

ADCPs = [

       { 'instrument'   :  'wh300',
          'setup'       :  'rdi_setup',
          'terminal'    :  'oswh_term',
          'defaultcmd'  :  'wh300_default.cmd',
          'commands'    :  ('EA04500',),   # Add WM*, WV*  to override default.
          'datatypes'   :  ('wh300',),
          'wakeup_baud' :  9600
        },

        { 'instrument'  :  'os75',
          'setup'       :  'rdi_setup',
          'terminal'    :  'oswh_term',
          'defaultcmd'  :  'os75_default.cmd',
          'commands'    :  ('EA-04500',),          # nominally -45deg
          'datatypes'   :  ('os75bb', 'os75nb'),
          'wakeup_baud' :  9600}


        ]

common_opts = '-f %s -F -m 1 -H 2 ' % (shipabbrev,)

# In the following list of "sensors" (which are simply serial streams
# being logged) the ADCPs must come first, and they must come in
# the same order as in the ADCPs list above; that is, there must
# be a 1:1 correspondence between the instrument fields in the
# ADCPs list and those in the first entries in the sensors list.

sensors = [

        { 'instrument'  :  'wh300',     # Passive logging of WH300
          'device'      :  'tty_dgnc_0_0',
          'baud'        :   38400,      # Some errors at 115200
          'format'      :  'binary',
          'subdir'      :  'wh300',
          'ext'         :  'raw',
          'opt'         :  '-rlE -c -O -I'}, # require -O for OS or WH


        { 'instrument'  :  'os75',       # Passive logging of OS
          'device'      :  'tty_dgnc_0_2',
          'baud'        :   38400,       # Some errors at 115200.
          'format'      :  'binary',
          'subdir'      :  'os75',
          'ext'         :  'raw',
          'opt'         :  '-rlE -c -O -I'}, # Note -I option for new ser_bin.


        { 'instrument'  :  'Gyro',
          'device'      :  'tty_dgnc_0_5',
          'baud'        :   4800,
          'format'      :  'ascii',
          'subdir'      :  'gyro',
          'ext'         :  'hdg',         ## 'hnc' if no checksum
          'strings'     :  ('$HEHDT',),
          'messages'    :  ('hdg',),      ## 'hnc' if no checksum
          'opt'         :  '-tc '},

        { 'instrument'  :  'GPS',
          'device'      :  'tty_dgnc_0_6',
          'baud'        :   4800,
          'format'      :  'ascii',
          'subdir'      :  'gpsnav',
          'ext'         :  'gps',
          'strings'     :  ('$GPGGA',),
          'messages'    :  ('gps',),
          'opt'         :  '-tc'},


       { 'instrument'  :  'Ashtech',
          'device'      :  'tty_dgnc_0_7',
          'baud'        :   4800,
          'format'      :  'ascii',
          'subdir'      :  'ashtech',
          'ext'         :  'adu',
          'strings'     :  ('$GPGGA', '$PASHR,ATT'),
          'messages'    :  ('gps', 'adu'),
          'opt'         :  '-tc'}

       ]




#### DO NOT CHANGE the following ################

ADCPs = [A for A in ADCPs if A['instrument'] not in ignore_ADCPs]
sensors = [S for S in sensors if S['instrument'] not in ignore_ADCPs]
sensors = [S for S in sensors if S['instrument'] not in ignore_other_sensors]



