CDF   R   
      pressure          +   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI404LEE_H ProfileID: 10030003     summary      oThis file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted within an inductive type conductivity cell, a platinum thermometer and silicon pressure sensor. 

The CTD temperature sensor is calibrated on the ITS-90 temperature scale against a master CTD using a controlled temperature bath. The pressure sensor is calibrated using a Druck Pressure Calibrator. The conductivity sensor is calibrated in a temperature controlled bath against seawater samples of known conductivity.

The CTD is lowered and raised by a hand winch sampling at a rate of 1.83 Hz. Data files were recorded in the downcast and upcast direction but most data is from downcasts due to higher quality. Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.    keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $7b9f1a2a-b0b4-4070-8fb0-7c015c626bd1   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      	Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'. In some cases there is a separate recording for the downcast and upcast. The downcast data were selected as priority for better quality data. In rarer cases only an upcast was available so it is used by default.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.    date_created      2012-11-07T14:58:14    
date_modified         2012-11-07T15:30:26    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.70133      geospatial_lat_max        	-12.70133      geospatial_lon_min        	125.87200      geospatial_lon_max        	125.87200      geospatial_vertical_min       03.00      geospatial_vertical_max       84.00      geospatial_vertical_units         decibars   time_coverage_start       2005-04-10T03:26:51Z   time_coverage_end         2005-04-10T03:26:51Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI404LEE_H     source_filename       100405b.dn.dat     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Falmouth Scientific    CTD_instrument_model      2-inch Micro CTD   
CTD_serial_no         1420M      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.39   CTD_MaxRawPressure        84.06      CTD_MinPressureforInterp      2.39   CTD_MaxPressureforInterp      84.06      CTD_cast_direction        Down   
CTD_scan_rate         1.83 Hz          time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        *   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        +   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    +   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        +$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        +,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        +4   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        +8   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        +<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        +D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        +H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         + @ӷ	1~K )ghI@_w+ @      @>@AKI^@      @>~.2@AKxF]@      @>~t@AKeO@      @>vaf@AK$@      @>oحV@AKs@       @>irGE8@AKC,z@"      @>h@AJW'@$      @>dS@AI(@&      @>g4m@AJc	@(      @>j)y@AKF]c@*      @>nzG@AK6z@,      @>mVl!@AK&@.      @>LwkP@AO>6z@0      @>>@AJOv`@1      @>9"`@AH*0U@2      @>$!-w2@AF@3      @>Z@AG&@4      @=.H@AHoiDg8@5      @=VϪ@ADI^5?@6      @=bM@ADL_@7      @=_F@AE*0@8      @=I^5@AD#x@9      @=H˒:@AC@:      @=TɆ@AC$@;      @=bM@ACE@<      @=
=p@AD#x@=      @=q$/@AA2W@>      @=VC-@AB:)y@?      @=JD@AA0
)@@      @=>Vu@ACa@N@@     @=7-@AB:)y@A      @=0[6@A@bM@A     @='KƧ@AAXbM@B      @=(@ABL_@B     @=-@A@TɅ@C      @=䎊@AA|@C     @=H@AA-w1@D      @=`A7L@A@
(@D     @<
qv@AA~($@E      @<qi@A?Xe,@E     @<o@AA[W>6@F      @<n.3@AB\(@F     @<\N<@ABa|Q@G      @<<쿱@AB䎊q@G     @<~T@ACm]@H      @<y7KƧ@AClC@H     @<x>BZc@ACdZ@I      @<w>6z@ACA [@I     @<vA@AC]cA@J      @<uzxl"h@ACQ@J     @<sa@O@ACC]@K      @<rsP@ACߤ@K     @<rT`d@AC=K^@L      @<p
(@AC*0U2@L     @<n1@ACa@@M      @<lC,zx@ACs@M     @<iD@ACC]@N      @<gfA@ACQ@N     @<em\@ADzxl"@O      @<d3@ADɅoi@O     @<c@AC҈@P      @<b`A@AD~($x@P@     @<a.H@AD?@P     @<`ѷX@ADL_@P     @<`{@ADI^5?@Q      @<`H@ADVϪ@Q@     @<`NU@AD*1@Q     @<`|@ADj~@Q     @<`IQ@ADj~@R      @<`n@AD,<@R@     @<`'RT`@ADm8@R     @<_o @AD3@R     @<_o@AD֡a@S      @<]C\@ADe@S@     @<]+j@AD#@S     @<]K]@AD@S     @<\1&@AD@T      @<\zxl"@ADe@T@     @<\?@AD?@T     @<\(\@AE*0@T     @<\]ce@AD>B[@U      @<[lC@AEK]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            