CDF   _   
      pressure          +   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI416LEE_H ProfileID: 10040005     summary      oThis file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted within an inductive type conductivity cell, a platinum thermometer and silicon pressure sensor. 

The CTD temperature sensor is calibrated on the ITS-90 temperature scale against a master CTD using a controlled temperature bath. The pressure sensor is calibrated using a Druck Pressure Calibrator. The conductivity sensor is calibrated in a temperature controlled bath against seawater samples of known conductivity.

The CTD is lowered and raised by a hand winch sampling at a rate of 1.83 Hz. Data files were recorded in the downcast and upcast direction but most data is from downcasts due to higher quality. Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.    keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $a18fd9c2-afe5-48e7-bac8-4aa801e49d2f   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      	Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'. In some cases there is a separate recording for the downcast and upcast. The downcast data were selected as priority for better quality data. In rarer cases only an upcast was available so it is used by default.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.    date_created      2012-09-19T16:12:02    
date_modified         2012-11-08T07:55:19    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-38.22333      geospatial_lat_max        	-38.22333      geospatial_lon_min        	140.72667      geospatial_lon_max        	140.72667      geospatial_vertical_min       03.00      geospatial_vertical_max       97.00      geospatial_vertical_units         decibars   time_coverage_start       2006-03-09T21:35:55Z   time_coverage_end         2006-03-09T21:35:55Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI416LEE_H     source_filename       090306a.dn.dat     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Falmouth Scientific    CTD_instrument_model      2-inch Micro CTD   
CTD_serial_no         1420M      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.31   CTD_MaxRawPressure        97.39      CTD_MinPressureforInterp      2.34   CTD_MaxPressureforInterp      97.39      CTD_cast_direction        Down   
CTD_scan_rate         1.83 Hz          time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        *   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        +   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    +   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        +$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        +,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        +4   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        +8   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        +<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           +   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        +D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        +H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         + @
y C@a@q 2@      @2@N@A]ce@      @2-
@Aq@      @2o hی@AVϪ@      @2-w1@AVϪ@      @2$/@A`d@       @2:S@Aԁo h@"      @2o hی@AԬ1&@$      @2X@AԹ#x@&      @2o@Am8@(      @2|Q@A~($x@*      @2ae@AԎqj@,      @2N;5@Aԇ#@.      @2hr @Aԁo h@0      @2u@Ag8}@1      @2o@A]ce@2      @2TɅo@Aԇ#@3      @2@N@AcA \@4      @2C@AcA \@5      @2D@A]ce@6      @2|@AC,zx@7      @2[W>@AI^5?@8      @2.H@A64@9      @2쿱[W@AxF@:      @2@A6@;      @2f@A^@<      @2&4K@A@=      @1)^	@AC%@>      @1C,z@AfB@?      @0ᰉ@Ap:@@      @0}w1@As@@     @0\@AR@A      @0B䎊q@A-
@A     @0Q@AƧ@B      @/Ʌoi@A@B     @/Q[W>6@Am8@C      @.`A7@As@C     @.sg@A0U2a|@D      @.u@AYJ@D     @-\)@A<쿱@E      @-@[6@A(@E     @,@4@AIQ@F      @,WXe,@An@F     @,'E84@Aa@O@G      @,;dZ@A`A7@G     @+Լj~@AR<6@H      @+%2@A	ԕ+@H     @+[=K^@A<쿱@I      @+
0
@A@I     @*qu!@Azxl"h@J      @*y@A8}H@J     @*/V@A.H@K      @*($x@A	k@K     @*}+j@AO
M@L      @*]}H@A#9@L     @*2sP@AfA@M      @)-V@A@M     @)U=@A@N      @)_F@Am8@N     @)GE85@AL_@O      @)
=p@A4֡b@O     @)
(@AN;6@P      @)]cf@Au%F@P@     @)o hی@A@4@P     @)'RT`@A@P     @)hۋq@AL/{@Q      @)7Kƨ@AGE85@Q@     @)u!@Au%F
@Q     @)˒:)@Aᰊ@Q     @)حV@A@R      @)b}V@AY@R@     @)?@A}Vm@R     @)	@Aᰊ@R     @)[6@A3@S      @)|hs@Avȴ@S@     @)H˒:@Aᰊ@S     @)|hs@Aᰊ@S     @)Ft@An@T      @)H˒:@A@T@     @)     @A@T     @)˒:)@Aݘ@T     @)حV@Aݘ@U      @)䎊r@Ag	@U@     @)NU@A ě@U     @)'RT`@A͞&@U     @)A7K@A,<@V      @)IQ@Avȴ@V@     @)4m@A ě@V     @)҈p@AY@V     @)TɅo@A}Vm@W      @):S@An@W@     @)o hی@A ě@W     @)ae@A)_@W     @)n.@AwkQ@X      @)ae@AW@X@     @)$/@AsP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    