CDF   s   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070272     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $78cd15c7-ec32-4162-b723-66d0cee4d16b   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:48    
date_modified         2012-11-07T14:05:29    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.76813      geospatial_lat_max        	-25.76813      geospatial_lon_min        	112.61149      geospatial_lon_max        	112.61149      geospatial_vertical_min       10.00      geospatial_vertical_max       124.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-16T23:39:53Z   time_coverage_end         2007-08-16T23:39:53Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       136.9      
ship_speed        6.1    source_filename       444_LEEUWIN_0272.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        8.50   CTD_MaxRawPressure        124.20     CTD_MinPressureforInterp      9.10   CTD_MaxPressureforInterp      124.20     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ 9Ĥ*@\'"0  @$      @6mO;dZ@AC,z@&      @6m-V@Aߤ@(      @6o\(@A@*      @6o;dZ@AS@,      @6p ě@A]cA@.      @6o;dZ@AF]c@0      @6p     @A@N@1      @6o\(@A"`B@2      @6pn@A]cA@3      @6p
=q@Aa@N@4      @6pěT@Atj~@5      @6pbM@AxF]@6      @6qhr @AC%@7      @6qhr @AC,z@8      @6qhr @Ajf@9      @6qhr @Aa@N@:      @6qhr @AS@;      @6q&x@AdZ@<      @6p`A7@A@=      @6q&x@Ag	l@>      @6q&x@A@?      @6qGz@A~$@@      @6p`A7@AS@@     @6p`A7@Aa@N@A      @6n+@A㕁$@A     @6o;dZ@Aߤ@B      @6nzG@A㢜wk@B     @6lI^5?@A(\@C      @6kC%@AA [@C     @6h9Xb@A#@D      @6dZ1@A֡a@D     @6]-V@A@E      @6Ql@A hۋ@E     @6LI^5?@A;dZ@F      @6J=p
@A ě@F     @6Fx@A     @G      @64j~@AGE85@G     @61R@Aꅇݘ@H      @6*=p
@Aa@O@H     @69XbN@A;5X@I      @5C%@AoiD@I     @57KƧ@A(\@J      @5$/@AC\@J     @5vȴ9X@A[W>6@K      @5\)@A͞&@K     @5š@A	@L      @5S@A҈@L     @5ěT@A\(@M      @5vȴ9@AMj@M     @5;dZ@A1@N      @5vȴ9X@A+j@N     @51&@B ҈p@O      @5vȴ@BXbM@O     @5R@BwkQ@P      @5Vu@BS@P@     @59Xb@B@P     @5S@B@P     @5M@BV@Q      @5ěT@BL_@Q@     @5hr@Bn/@Q     @5Q@Bt@Q     @5-V@B?|h@R      @5r Ĝ@B>@R@     @5;dZ@BF
L0@R     @5y+@B/w@R     @5p ě@B8Y@S      @5hr Ĝ@B+jg@S@     @5ft@Bߤ?@S     @5dS@BMj@S     @5dE@Bt@T      @5dtj@B)^@T@     @5dE@B8}H@T     @5dS@B+j@T     @5dS@Bd8@U      @5b\(@B	Gz@U@     @5a7Kƨ@B	'RTa@U     @5^Vu@B
Ov`@U     @5\j~#@B
M@V      @5YXbM@B
 ě@V@     @5W+@BnP@V     @5VE@BTɆ@V     @5Stj~@B
`A7L@W      @5Qhr @B
Vl!@W@     @5Ov@Bz@W     @5LC@Bߤ?@W     @5KƧ@Bt@X      @5J=p
@BO;d@X@     @5H\)@B|hs@X     @5Ffffff@BC@X     @5D/@BI^5@Y      @5B`A@BZc@Y@     @5@n@B~"@Y     @5>5?|@Bu%@Y     @5;lC@B$@Z      @597KƧ@BJ@Z@     @57KƧ@B?@Z     @56t@B@Z     @55$/@B!.H@[      @55?|h@Bqu"@[@     @55$/@B!.H@[     @54j~@B5Xy>@[     @51&x@B$@\      @5$/@B|Q@\@     @5"`@Bu%F@\     @5^5?|@Bp:~@\     @5/w@BF]d@]      @5Q@Be+@]@     @5O;d@BQ_@]     @5	x@Bhr @]     @4"@Bvȴ9@^      @4n@B [7@^@     @4\)@BC%@^     @4@B!-w2@^     @41'@B@_      @4
=p@Bj~