CDF      
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070274     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $c78e8ca2-ce32-4eb8-abd5-0a0a54ca64f1   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:48    
date_modified         2012-11-07T14:05:29    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.78970      geospatial_lat_max        	-25.78970      geospatial_lon_min        	112.60989      geospatial_lon_max        	112.60989      geospatial_vertical_min       04.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-16T23:51:17Z   time_coverage_end         2007-08-16T23:51:17Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       136.9      
ship_speed        9.4    source_filename       444_LEEUWIN_0274.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.60   CTD_MaxRawPressure        130.40     CTD_MinPressureforInterp      3.60   CTD_MaxPressureforInterp      130.40     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ 9)y@\'p
 @      @6gzH@AnO@      @6j=p
@Ad7@      @6kI^@AW'@      @6ilD@A@       @6i^5?}@A-@"      @6ix@A	 @$      @6i7KƧ@A&IR@&      @6i^5?}@Aa|Q@(      @6ilD@AlD@*      @6h9Xb@A)y@,      @6i7KƧ@AGE85@.      @6h9Xb@Aa|Q@0      @6jn@A\(@1      @6ix@Aⅇݘ@2      @6kI^@AZc@3      @6jn@A)y@4      @6h\)@AM@5      @6ilD@AJL@6      @6i^5?}@AGE85@7      @6jn@A#9@8      @6j~"@A1'@9      @6j=p
@AQ_@:      @6jvȴ@AQ_@;      @6kC%@A~"@<      @6kƧ@A\(@=      @6kƧ@A⩓@>      @6kƧ@Au%F
@?      @6l(\@A@4@@      @6lI^5?@Axl"h
@@     @6kƧ@Aᰊ@A      @6l1&y@AnO@A     @6lI^5?@AZc@B      @6l1&y@Ad7@B     @6i^5?}@AnP@C      @6f-@An.3@C     @6jn@AW@D      @6ix@A	@D     @6h9Xb@AJ#9@E      @6h\)@A6z@E     @6ilD@Ac	@F      @6XQ@A@F     @66fffff@AeO@G      @6;dZ@A=K^@G     @6
hr!@AZ@H      @5/@AQ@H     @5n@Ah	ԕ@I      @5tj@A84֡@I     @5 ě@AYJ@J      @5dZ@B n@J     @5bM@B|Q@K      @5+J@Bk~(@K     @5j~@B7Kƨ@L      @5nO@BlD@L     @5v@B-@M      @5nP@B$@M     @5dZ@B?@N      @5+@BV@N     @5j~@Bhr@O      @5 ě@BB@O     @51&y@Bsg@P      @5~"@BF
L0@P@     @57KƧ@Bzxl"@P     @5`A@Bw1@P     @5{dZ@B>@Q      @5vȴ9X@B@Q@     @5r-V@B\(@Q     @5p ě@Bᰉ@Q     @5nzG@B@R      @5j~"@B?@R@     @5d/@BOv_خ@R     @5`A7K@B]cf@R     @5_\(@B)^@S      @5^"@Bv@S@     @5^"@BO
M@S     @5^+@BKƧ@S     @5^vȴ9X@B.H@T      @5^5?|@B@T@     @5\(\@B	&x@T     @5Z~"@B	s@T     @5Z^5?|@B
C\@U      @5YXbM@B
~"@U@     @5XbM@B&@U     @5Vȴ9X@Btj@U     @5V+J@BlC@V      @5Vt@BL_@V@     @5U$/@B2W@V     @5R ě@BE@V     @5P`A7@B
cA @W      @5PbM@Bb}V@W@     @5O;dZ@BK]c@W     @5IlD@B^@W     @5Dtj@BC\@X      @5@n@BS&@X@     @5>vȴ9X@B~"@X     @59+@B\(@X     @52-V@Bjf@Y      @5-@B%2@Y@     @5(1&x@B?@Y     @5&x@B@Y     @5%Q@BɅoi@Z      @5"\(@BZ@Z@     @5"I^5@B(@Z     @5Q@B=K@Z     @5p
=@Bݗ@[      @5hr@Bt@[@     @5j~#@BE@[     @5n@BzG@[     @5@BE@\      @5
=p@B+J@\@     @5ȴ9X@B+@\     @5Q@B)^@\     @4tj~@B)@]      @47KƧ@B-
@]@     @4nP@B-
@]     @4+@B@]     @4lD@B@^      @4$/@Bj~@^@     @4nO@B*0@^     @4l@BF
L0@^     @41&y@Be@_      @4x@BB@_@     @4\)@BS&@_     @4=p
@Bu@_     @4r Ĝ@B*0@`      @4-@B\@`      @4zH@BS&@`@     @4-@B}H