CDF   t   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070276     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $a9bf8ad2-c80c-46d9-b3a4-f3a5df29bf3e   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:48    
date_modified         2012-11-07T14:05:29    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.75745      geospatial_lat_max        	-25.75745      geospatial_lon_min        	112.60709      geospatial_lon_max        	112.60709      geospatial_vertical_min       04.00      geospatial_vertical_max       119.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T00:44:43Z   time_coverage_end         2007-08-17T00:44:43Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       137.3      
ship_speed        8.1    source_filename       444_LEEUWIN_0276.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        1.30   CTD_MaxRawPressure        119.80     CTD_MinPressureforInterp      3.50   CTD_MaxPressureforInterp      119.80     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍƻ9>BZ@\&ڐ @      @6c33333@A^@      @6dtj@ADg8~@      @6ffffff@Ak~(@      @6glC@Ahr @       @6fx@AѷX@"      @6fx@A4֡b@$      @6fx@A#w@&      @6g
=p@APH@(      @6fȴ9X@A	k@*      @6g+I@ATɅ@,      @6fx@AN;5@.      @6htj@A7KƧ@0      @6i^5?}@A\)@1      @6j^5?|@A@@2      @6j~"@AѷX@3      @6j=p
@A{@4      @6ilD@A`A7@5      @6j=p
@Ae+@6      @6j=p
@A$tT@7      @6j=p
@AD@8      @6ilD@Ap:@9      @6j1'@A@:      @6j=p
@A҈p@;      @6jn@Aۋq
@<      @6j~"@A [7@=      @6j^5?|@A#w@>      @6i"`@A=b@?      @6i^5?}@A7KƧ@@      @6i^5?}@AႩ@@     @6j=p
@A@A      @6jn@A@A     @6j^5?|@Ae+@B      @6i7KƧ@A_p@B     @6h1&x@AGz@C      @6gzH@Ae+a@C     @6g+I@ArGE8@D      @6gzH@ADg8~@D     @6dE@Ao@E      @6dtj@As@E     @6dtj@A@F      @6b\(@AGE85@F     @6aGz@Aa|Q@G      @6]E@AL/{@G     @6["`B@AZ@H      @6Y"`@A㹌~($@H     @6VE@AC]@I      @6P`A7@Am8@I     @6>vȴ9X@Am\@J      @6!$/@A^5?}@J     @5vȴ9X@A}Vl@K      @5Ƨ@A\)@K     @5ěT@Axl"h
@L      @5E@Ag	l@L     @5(\@AoiDg8@M      @5zH@A'@M     @5@B      @N      @5`A7L@B D*@N     @5Q@B r Ĝ@O      @5S@B ѷX@O     @5S@B d8@P      @5x@B'RTa@P@     @5-@B>BZ@P     @5Q@BGE85@P     @5M@B<64@Q      @5"@B~@Q@     @51&@BeO@Q     @5"`@Bߤ@@Q     @5@B?|h@R      @5I^5?@B\N<@R@     @5C%@BAs@R     @51&x@B$tS@R     @5Gz@B
=q@S      @5`A@B	^@S@     @5o@B>BZc@S     @5~"@Bd8@S     @5~5?|@By=c@T      @5}p
=@B9Xb@T@     @5y"`@BKƧ@T     @5p`A7@BPH@T     @5kC%@B	n.@U      @5f$/@B
L/{@U@     @5c
=p@B
L/{@U     @5bM@B
G{@U     @5`ěT@B
nO@V      @5]O;dZ@B
ڹY@V@     @5ZG{@B
qiC@V     @5QR@B)^	@V     @5O-V@Ba@@W      @5Mhr!@Bݗ+k@W@     @5KƧ@B@W     @5I7KƧ@Bm8@W     @5G-@BI^5?@X      @5ES@B쿱[@X@     @5C
=p@B
w1@X     @5CnP@BFs@X     @5Al@BH@Y      @5@ěT@Bl"h	@Y@     @5AGz@Btj@Y     @5@n@BTɅ@Y     @5?|hs@BA [@Z      @5=-V@Bhr @Z@     @5<j~#@Bo@Z     @5;lC@B_o@Z     @5;S@BY}@[      @5:1'@B2W@[@     @56E@BI^5@[     @5333333@BI^5@[     @5.Vu@B3@\      @5vȴ9@B{@\@     @5m@Bu!S@\     @5	lD@Bԕ*@\     @5zG@BI^5@]      @4E@B7@]@     @4j~@BtSM@]     @4Vu@Bt@]     @4`A7L@BOv_خ