CDF   ~   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070278     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $09f628e2-b290-4cb8-941c-c9ea15dad2e3   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:49    
date_modified         2012-11-07T14:05:29    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.78628      geospatial_lat_max        	-25.78628      geospatial_lon_min        	112.60952      geospatial_lon_max        	112.60952      geospatial_vertical_min       05.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T01:40:00Z   time_coverage_end         2007-08-17T01:40:00Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       137.6      
ship_speed        9.0    source_filename       444_LEEUWIN_0278.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.50   CTD_MaxRawPressure        130.30     CTD_MinPressureforInterp      4.50   CTD_MaxPressureforInterp      130.30     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍq9Ie@\'`, @      @6i7KƧ@AႩ@      @6ilD@AA [@      @6j=p
@AA [@       @6j=p
@Ao@"      @6j=p
@Ahr @$      @6j=p
@Ak~(@&      @6j^5?|@A|Q@(      @6j=p
@A|Q@*      @6j~"@A0
)@,      @6j~"@Ae+a@.      @6jn@A=b@0      @6jn@AA [@1      @6jn@A4J@2      @6jn@A\)@3      @6j~"@A [7@4      @6j~"@A&x@5      @6j~"@ATɅo@6      @6jn@A#w@7      @6jn@ArGE8@8      @6jn@AXbM@9      @6jn@A4J@:      @6kI^@AN;5@;      @6jn@AN;5@<      @6jn@AoiD@=      @6jn@A [7@>      @6jn@A0
)@?      @6j1'@Ak~(@@      @6j=p
@AA [@@     @6jvȴ@A [7@A      @6i7KƧ@An.@A     @6hQ@Aae@B      @6gzH@A2W@B     @6gzH@Aᰉ'R@C      @6fȴ9X@Aᰉ'R@C     @6f$/@Ay@D      @6ao@Ad7@D     @6`n@A⩓@E      @6^Q@A@E     @6["`B@AQ@F      @6Qhr @A#@F     @6J=p
@An/@G      @67
=p@AKƧ@G     @6S@AsP@H      @6C@AF
L0@H     @5$/@A@@I      @5@Ag	l@I     @5$/@A=K@J      @5O;@Aaf@J     @5C@B 6@K      @5x@B4J@K     @5$/@BD@L      @55?|@Bm@L     @5hr@Bqu!@M      @5dZ@B)^	@M     @5+@B1&y@N      @5E@BA [@N     @5 ě@B0
@O      @5S@BP{@O     @5|hs@B}Vm@P      @5vȴ9X@BS&@P@     @5qhr @BƧ@P     @5i^5?}@B@P     @5ffffff@B쿱[@Q      @5d/@BC@Q@     @5d9XbN@BD@Q     @5c$@B/w@Q     @5b\(@BZ@R      @5b\(@BQ@R@     @5ao@BK]@R     @5a7Kƨ@B=K@R     @5a7Kƨ@Bw1@S      @5a$/@Bڹ@S@     @5`     @BE@S     @5_|hs@Bx@S     @5]-V@Beں@T      @5\j~#@B$tS@T@     @5[dZ@B ě@T     @5VE@B
u%F@T     @5S@B
0U2a|@U      @5Stj~@BnP@U@     @5Rm@Bs@U     @5SE@BdZ@U     @5S33333@B*0U2@V      @5R`A@Bs@V@     @5Qhr @B
m\@V     @5NO;@B4m@V     @5Fx@BU2a|@W      @5CnP@B҈p@W@     @5@n@B ѷ@W     @5>O;@B4J@W     @5;lC@BPH@X      @59^5?}@BB@X@     @581&x@B^@X     @55?|h@B~($@X     @51l@BR@Y      @5/\(@BW'@Y@     @5-hr!@BD@Y     @5,@B@Y     @5+I^@BfB@Z      @5)lD@B33333@Z@     @5(1&x@BC%@Z     @5'+I@BdZ@Z     @5&$/@B~$@[      @5%Q@BU=@[@     @5%`A7L@B`A7L@[     @5"`A@B;dZ@[     @5zG@B$tS@\      @5	x@BkP@\@     @5nP@B!-w1@\     @4-V@Bs@\     @4o@B쿱[W@]      @4dZ@B?@]@     @4R@B|@]     @4"@B\(@]     @4Q@B,zxl@^      @4t@B~@^@     @4m@Bqu!@^     @4hr @B%2@^     @4&x@BPH@_      @4Vu@Bwk@_@     @4Vu@BdZ@_     @4+@Bg	l@_     @4Vu@B~($@`      @4E@Bs@`      @4hr!@Bqu!@`@     @4C@Bq