CDF   ~   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070279     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $5f5ef968-0ed6-453c-84cb-1bb9dc16b07d   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:49    
date_modified         2012-11-07T14:05:29    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.82880      geospatial_lat_max        	-25.82880      geospatial_lon_min        	112.61208      geospatial_lon_max        	112.61208      geospatial_vertical_min       05.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T02:06:03Z   time_coverage_end         2007-08-17T02:06:03Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       136.5      
ship_speed        6.1    source_filename       444_LEEUWIN_0279.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.80   CTD_MaxRawPressure        130.30     CTD_MinPressureforInterp      4.40   CTD_MaxPressureforInterp      130.30     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍŚ+<9,<@\',QI @      @6b`A@Al"h	@      @6c
=p@AXy=@      @6dZ1@A*0@       @6dS@A}H@"      @6c
=p@A$xG@$      @6dZ1@AF]d@&      @6dS@AfA@(      @6c
=p@A     @*      @6dtj@A߮zH@,      @6dS@A@.      @6dS@AbM@0      @6dZ1@A}H@1      @6dtj@A@2      @6dZ1@ArGE9@3      @6dZ1@A1&x@4      @6dZ1@A$xG@5      @6c
=p@ANU@6      @6c
=p@A*0@7      @6c$@AU2a|@8      @6cS@AH@9      @6cS@AoiDg8@:      @6cS@A˒:*@;      @6cnP@A4m9@<      @6b`A@A-
@=      @6b`A@AU2a|@>      @6b`A@A|@?      @6bm@AeO@@      @6bM@A@@     @6_;dZ@A`A7@A      @6Stj~@A@4n@A     @6M@AY@B      @6E`A7L@A1&y@B     @6vȴ9X@A艠'RT@C      @5p
=@Av@C     @5I^5?@AF@D      @5\(@A@4n@D     @51'@AQ@E      @5E@A6C@E     @5F@Aa@O@F      @5+J@A*1@F     @5l@A
L/@G      @5fffff@B >BZc@G     @5E@B u!@H      @5\(@B ěT@H     @5I^5@B#w@I      @5Gz@BTɅo@I     @5(\@B0U2a|@J      @5$/@BC]@J     @5nO@B@K      @5-V@BC,zx@K     @5V@Bn.@L      @5~"@BU=@L     @5fffff@Bq@M      @5Z1@Bq@M     @5m@Bm]@N      @5M@B$@N     @5M@BA@O      @5o@Bm]@O     @5`A7@B$@P      @5~Q@B@P@     @5|j~#@Bwk@P     @5{"`B@B*0U2@P     @5yXbM@BMj@Q      @5wlC@BS@Q@     @5u?|h@B6@Q     @5tj~@BJ@Q     @5sE@Bn.@R      @5qhr @BQ@R@     @5o-V@BZ1@R     @5gzH@B~@R     @5ao@Bq@S      @5`A7K@B<64@S@     @5^"@Bw1@S     @5]E@B8YJ@S     @5[lC@BO;d@T      @5[dZ@BXy=@T@     @5[dZ@B	iB@T     @5ZG{@B
@T     @5Vfffff@Bu"@U      @5S@B
+a@U@     @5RnO@Bx@U     @5R ě@BO;d@U     @5Rm@B?@V      @5Ql@BlC@V@     @5KS@Bn@V     @5G+I@B0
)@V     @5B`A@B@4n@W      @5:vȴ@B@W@     @5/v@Bݘ@W     @5)7KƧ@Bo h@W     @5&+J@Bhr@X      @5" ě@Bhr@X@     @55?|@Be@X     @5XbM@Bm\@X     @5$/@BjOv@Y      @5ěT@BfA@Y@     @5Q@Bo i@Y     @5fffff@BVl!@Y     @5M@B@Z      @4|hs@BE@Z@     @4j~#@BiB@Z     @4+@Bm\@Z     @4tj~@Beں@[      @4`A7@By@[@     @4C@B@[     @4^5?}@BNU@[     @4Z1@B>BZc@\      @4S@Btj@\@     @4\(@Bu%F@\     @4M@B4m@\     @47Kƨ@B1&x@]      @45?|@B*0U@]@     @4dZ@B䎊r@]     @4@B@]     @4š@B_p@^      @4E@BW'@^@     @4+@Bs@^     @4
=p@B6z@^     @4@B&@_      @433333@Bjf@_@     @4l@BQ@_     @4hr @B|@_     @4hr @BE@`      @4hr @Bߤ@`      @4`A7@BƧ@`@     @4$/@Bߤ@