CDF   ~   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070280     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $3e6482fa-9561-4634-9394-25c224f72975   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:49    
date_modified         2012-11-07T14:05:30    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.76658      geospatial_lat_max        	-25.76658      geospatial_lon_min        	112.61694      geospatial_lon_max        	112.61694      geospatial_vertical_min       04.00      geospatial_vertical_max       129.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T03:16:39Z   time_coverage_end         2007-08-17T03:16:39Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       136.7      
ship_speed        8.4    source_filename       444_LEEUWIN_0280.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.90   CTD_MaxRawPressure        129.70     CTD_MinPressureforInterp      4.00   CTD_MaxPressureforInterp      129.70     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍȽp 9>=ć@\'{ @      @6qR@A4֡b@      @6rnO@Ae+@      @6rnO@A`A7@      @6rnO@A`A7@       @6rnO@A@"      @6r-V@A ѷ@$      @6rM@Aۋq
@&      @6rnO@A$/@(      @6rnO@A@*      @6r\(@A@@,      @6rm@A)@.      @6rm@A୫U@0      @6rm@A{@1      @6rnO@A
=q@2      @6qR@AIQ@3      @6rnO@A|@4      @6rnO@Ay=c@5      @6rnO@A@@6      @6r-V@A{@7      @6qR@ATɅ@8      @6qR@A9Xb@9      @6qR@AIQ@:      @6qhr @A@;      @6o;dZ@Aව4m@<      @6o;dZ@A@@=      @6nO;@A)^@>      @6p     @Aව4m@?      @6n+@A\)@@      @6o;dZ@A'RT@@     @6ov@AYJ@A      @6ov@A)@A     @6nQ@A@B      @6mO;dZ@A ѷ@B     @6l@A	k~@C      @6lhr@Ap:@C     @6h1&x@AႩ@D      @6bM@A:)y@D     @6`n@A@4@E      @6^"@AZc@E     @6Z^5?|@APH@F      @6O|hs@A]ce@F     @6>Vu@Al!-@G      @6'KƧ@AoiDg8@G     @6Gz@AO
M@H      @5fffff@A@H     @5vȴ9X@AA7K@I      @5Q@As@I     @5S@A;dZ@J      @5I^5@B ѷ@J     @5|hs@BoiD@K      @55?|@By@K     @5^5?|@B@L      @5KƧ@Btj~@L     @5zG@B*0U2@M      @5V@Bg8}@M     @5~"@B!R@N      @5~"@B҈p;@N     @5C%@Bߤ?@O      @5O;dZ@B4m@O     @5n@B1&x@P      @5zH@BحV@P@     @5$@B	ԕ+@P     @5M@BIQ@P     @5o@B)@Q      @57Kƨ@B	rGE@Q@     @5yXbM@B	 ѷ@Q     @5u?|h@B4֡b@Q     @5q&x@B	@N@R      @5nO;@B*0U@R@     @5j=p
@B4m9@R     @5cnP@B+@R     @5_|hs@B ě@S      @5\1&@B9Xb@S@     @5Y"`@B@S     @5WzH@B1&x@S     @5V+J@BQ@T      @5Vt@BXy=@T@     @5TE@BPH@T     @5T9XbN@B
(@T     @5T9XbN@B@U      @5TE@B
xl"h
@U@     @5WKƧ@B
ڹY@U     @5TE@B
͞&@U     @5TzG@B	@V      @5S@Bm]@V@     @5TzG@B
=p@V     @5TzG@BA [@V     @5TE@B<쿱@W      @5Q&x@Bwk@W@     @5NVu@BƧ@W     @5KƧ@B@W     @5I"`@B@X      @5Hr Ĝ@Bݗ+k@X@     @5Fx@B@X     @5ES@B
b@X     @5Dj~@B@Y      @5DZ1@B!-w1@Y@     @5CE@BrG@Y     @5CnP@BzH@Y     @5BM@BD*@Z      @5AGz@B˒:*@Z@     @5@A7K@BD@Z     @5?;dZ@B\)@Z     @5?;dZ@BěT@[      @5>Vu@B$tT@[@     @5<hr@B$/@[     @5;S@BDg8~@[     @56t@BTɅ@\      @5+I^@BϪ͟@\@     @5tj@Bx@\     @59XbN@B"`@\     @5`A7@B@]      @5-@Bu%F
@]@     @4bM@B]ce@]     @4C@BVl!@]     @4`A7L@B(@^      @4E@BR<6@^@     @4ڟvȴ@B"@^     @4ȴ9X@Bo @^     @4ӶE@Bp:@_      @433333@B+@_@     @4     @B	k~@_     @4bM@BX@_     @4Õ$@B1'@`      @4A7K@BY@`      @4"@B"`B