CDF   ~   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070281     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $297f22d4-8c45-4d92-a572-58745a9aa654   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:49    
date_modified         2012-11-07T14:05:30    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.77017      geospatial_lat_max        	-25.77017      geospatial_lon_min        	112.61923      geospatial_lon_max        	112.61923      geospatial_vertical_min       05.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T03:43:05Z   time_coverage_end         2007-08-17T03:43:05Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       135.5      
ship_speed        6.4    source_filename       444_LEEUWIN_0281.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.40   CTD_MaxRawPressure        130.50     CTD_MinPressureforInterp      4.20   CTD_MaxPressureforInterp      130.50     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ1M9)r\>@\'vݬ 	@      @6rm@A$/@      @6stj~@AC@      @6sE@A@N@       @6s$@AC@"      @6s@A4֡b@$      @6s@Aࠐ-
@&      @6ttj@A@(      @6s@A@*      @6stj~@An@,      @6s
=p@An@.      @6stj~@An@0      @6sE@AYJ@1      @6s
=p@A@2      @6s@A)@3      @6s@A
=q@4      @6s@A{@5      @6tzG@A'RT@6      @6tzG@A
(@7      @6t9XbN@A@8      @6tzG@A-
@9      @6tzG@Ad8@:      @6tzG@AěT@;      @6t9XbN@A@@<      @6t9XbN@A'RT@=      @6s@A     @>      @6s$@A
=q@?      @6stj~@A-
@@      @6s@An@@     @6sE@Au%F@A      @6sS@A'RT@A     @6stj~@A@B      @6s33333@AK]c@B     @6rM@AeO@C      @6p
=q@Al"h	@C     @6n+@AѷX@D      @6mV@AѷX@D     @6kC%@A#w@E      @6j=p
@A#w@E     @6h1&x@A-w1@F      @6b\(@AlD@F     @6YXbM@AG{@G      @6G-@A?|h@G     @6*n@A;dZ@H      @5V@AVl!@H     @5S@A:~ @I      @5 ě@An.@I     @5m@Am\@J      @5o@Ao @J     @5vȴ9X@B@K      @51&@B@4n@K     @5^5?|@BwkQ@L      @5KƧ@Bg	l@L     @5Z1@Bn.@M      @5 ě@BN;@M     @5x@B@N      @5\)@B@N     @5-@B@O      @5Q@B	k~(@O     @5S@B	@P      @5S@B	l@P@     @5S@B	l@P     @5S@B	y@P     @5I^5@B	'R@Q      @5vȴ9@B	lD@Q@     @5|1&@B	u@Q     @5w+@B	B@Q     @5i^5?}@B`A7@R      @5f$/@B
s@R@     @5bM@B	u@R     @5[S@B	-w1@R     @5Y+@B	e+a@S      @5XbM@B@@S@     @5S33333@B	hr @S     @5R ě@B
=p
@S     @5RnO@B,zxl@T      @5P`A7@Bm8@T@     @5Qhr @BSMj@T     @5Ql@BcA \@T     @5NVu@BƧ@U      @5I7KƧ@B@U@     @5GO;d@B!-w2@U     @5Fx@BFs@U     @5Ffffff@B"h	ԕ@V      @5DZ1@B<쿱@V@     @5B`A@B֡a@V     @5@ěT@B+jg@V     @5@ěT@B}Vl@W      @5@A7K@Bp:~@W@     @5@A7K@B,<@W     @5@A7K@B)^@W     @5?;dZ@B{J#:@X      @5>vȴ9X@B[6@X@     @5=-V@BD@X     @5<hr@B@X     @5;lC@B@Y      @59@B@Y@     @59XbM@By@Y     @58F@B@Y     @58F@BD@Z      @58Q@BN;6@Z@     @55\(@B^5?}@Z     @52-V@B [7@Z     @5&x@B'R@[      @5$S@BTɅo@[@     @5vȴ@B@[     @5t@B&IR@[     @5A7K@BqiC@\      @5"`B@BD@\@     @5
=p@B@\     @5hr @BeO@\     @4\(@BxF@]      @4Q@BV@]@     @4-@B(@]     @47Kƨ@BC-@]     @4ܬ1&@Bo@^      @4+@B>BZc@^@     @4և+J@B@^     @4?|h@BěT@^     @4@B:S@_      @4ϝ-V@Bae@_@     @4tj@Bu%F
@_     @4     @B'/@_     @4\(@B&@`      @4vȴ9X@B@`      @4-V@BC%@`@     @4-V@B