CDF   ~   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070285     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $17a0e2d0-1fa6-4db6-9277-68c3dc256b11   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:50    
date_modified         2012-11-07T14:05:30    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.79245      geospatial_lat_max        	-25.79245      geospatial_lon_min        	112.58963      geospatial_lon_max        	112.58963      geospatial_vertical_min       05.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T06:00:35Z   time_coverage_end         2007-08-17T06:00:35Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       139.7      
ship_speed        6.7    source_filename       444_LEEUWIN_0285.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.40   CTD_MaxRawPressure        130.50     CTD_MinPressureforInterp      4.20   CTD_MaxPressureforInterp      130.50     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ 9 ѷ@\%wd 
@      @6cS@A҈p@      @6b\(@AD*@      @6`ěT@Atj@       @6ahr @Ay=c@"      @6_vȴ9@A@$      @6_vȴ9@AIQ@&      @6_vȴ9@A|@(      @6_;dZ@A@*      @6_v@Au%F@,      @6_;dZ@An@.      @6_;dZ@A|@0      @6_;dZ@A@1      @6_v@AD*@2      @6]/w@Ay=c@3      @6\1&@AU2a|@4      @6\j~#@Atj@5      @6\1&@A˒:*@6      @6\1&@Ahۋq@7      @6[lC@AoiDg8@8      @6\(\@Al"h	@9      @6[S@AXy=@:      @6YlD@AU2a|@;      @6Y@AeO@<      @6Y+@AD*@=      @6WO;d@ANU@>      @6Vt@A|@?      @6S33333@Atj@@      @6Ql@AF@@     @6O;dZ@A^@A      @6NVu@A@A     @6KI^@A@B      @6AGz@A㕁$@B     @67lC@AJM@C      @6(tj@A秆&@C     @6Q@A҉@D      @6-@Aqu"@D     @5r Ĝ@A
(@E      @5+@A!-w1@E     @5S@A4m@F      @5=p
@AQ@F     @5KƧ@AVϫ@G      @5C@A-V@G     @5E@A*1@H      @5vȴ@A-V@H     @5XbM@A5?|@I      @5tj@Aᰉ@I     @5Q@A.2@J      @5-@AoiDg@J     @5KƧ@Al!-@K      @5+J@Afffff@K     @5j~@A1@L      @5 ě@AK]d@L     @5bM@Ao @M      @5Ƨ@AU=@M     @5     @B {@N      @5vt@BX@N     @5rI^5@B ě@O      @5mV@B	@O     @5i^5?}@Btj~@P      @5g+I@B{J#9@P@     @5fx@B5Xy@P     @5fx@BE@P     @5e`A7L@BE@Q      @5b\(@B<쿱@Q@     @5``A7@BC,zx@Q     @5`n@Bm8@Q     @5_|hs@BTɆ@R      @5^"@Bn.@R@     @5^Q@Bm8@R     @5]E@B~($x@R     @5]E@BwkP@S      @5]/w@B*1@S@     @5\j~#@B@S     @5\I^5?@Bm8@S     @5[lC@B?@T      @5[lC@BS@T@     @5Z^5?|@B2W@T     @5[I^@B@T     @5Z^5?|@B;dZ@U      @5Y@B	Dg8~@U@     @5Xtj@B
,<@U     @5WzH@BI^5?@U     @5U$/@BzG@V      @5O;dZ@Bt@V@     @5KI^@B1@V     @5Fȴ9X@B&@V     @5@     @BKƧ@W      @5=/w@B     @W@     @5<1&@B73@W     @5<1&y@B[6@W     @5;S@BU2a|@X      @5;"`B@BeO@X@     @5:1'@BحV@X     @58tj@B`A7@X     @57KƧ@BYJ@Y      @57KƧ@Bn@Y@     @57+I@BOv`@Y     @56t@B^5?}@Y     @5-E@Bu%F
@Z      @5)7KƧ@B ѷ@Z@     @5%\(@B\N@Z     @5#$@BD@Z     @5 
=q@B84֡@[      @5"`B@B.H@[@     @5"`B@BlC@[     @5@BS&@[     @4lC@Bsh@\      @4O;d@B@\@     @4m@BK]d@\     @41&x@B	@\     @4|hs@BoiDg8@]      @4lC@B@@]@     @4+@Bԕ*@]     @4
=p@B'R@]     @4և+J@BR@^      @4E@B6C@^@     @4E@BOv`@^     @4@BlD@^     @4vȴ9X@B-V@_      @4~"@BG{@_@     @4-@Bxl"h
@_     @4fffff@B@_     @4m@Ba|Q@`      @4$/@B䎊q@`      @4E@B ѷ@`@     @4(\@BfB