CDF   p   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070286     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $19050c50-9ae7-430a-8f59-d76ef4812fc8   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:50    
date_modified         2012-11-07T14:05:30    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.75078      geospatial_lat_max        	-25.75078      geospatial_lon_min        	112.58709      geospatial_lon_max        	112.58709      geospatial_vertical_min       02.00      geospatial_vertical_max       113.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T06:31:42Z   time_coverage_end         2007-08-17T06:31:42Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       139.3      
ship_speed        10.1   source_filename       444_LEEUWIN_0286.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        1.50   CTD_MaxRawPressure        113.20     CTD_MinPressureforInterp      1.60   CTD_MaxPressureforInterp      113.20     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍh 93:}@\%s @       @6g+I@A)@      @6fx@A&x@      @6fx@A\)@      @6ffffff@ArGE@      @6f-@A	k@      @6f$/@A4֡b@       @6f$/@A+@"      @6f$/@AD@$      @6f+J@AC@&      @6eQ@A@(      @6c
=p@A)^@*      @6dj~@A{@,      @6eQ@AD*@.      @6bnO@ANU@0      @6b`A@A-
@1      @6ao@A'RT`@2      @6^"@A-
q@3      @6^Q@A1&x@4      @6^5?|@Ad8@5      @6]-V@AoiDg8@6      @6]/w@AeO@7      @6\1&@A4m9@8      @6[S@AH@9      @6\(\@A:~ @:      @6[S@A1&x@;      @6ZG{@Ay=c@<      @6Z~"@A1&x@=      @6XF@ArGE9@>      @6Xtj@A:~ @?      @6XQ@A>BZc@@      @6XQ@AeO@@     @6XQ@AK]c@A      @6XQ@A
qu@A     @6Xtj@AA7K@B      @6XQ@AQ@B     @6XbM@A@C      @6WKƧ@AK]c@C     @6WKƧ@A'RT`@D      @6WKƧ@A*0@D     @6W
=p@ArGE9@E      @6V+J@AK]c@E     @6VE@A'RT`@F      @6V$/@AXy=@F     @6U\(@AH@G      @6U$/@AK]c@G     @6Tj~@ANU@H      @6S@A_p@H     @6Q&x@A@I      @6L@A~@I     @6ES@A`A7L@J      @63tj~@As@J     @6hr@AV@K      @6	^5?}@A@K     @5S@Ab}@L      @5-V@AC%@L     @5߾vȴ9@AC@M      @5ΗO;@A84֡@M     @5"@A4֡a@N      @5$@A'RT`@N     @5O;dZ@Au!S@O      @5fffff@A)y@O     @5bM@A@N@P      @5
=q@A@P@     @5-@AVϫ@P     @57Kƨ@B F@P     @5~vȴ9X@Bb}@Q      @5{C%@B~"@Q@     @5wO;d@Bݘ@Q     @5stj~@B҉@Q     @5mhr!@BS&@R      @5j=p
@B*0U2@R@     @5h1&x@BVϪ@R     @5h1&x@Btj@R     @5e@BSMj@S      @5cS@B%@S@     @5b\(@B8Y@S     @5``A7@B1.@S     @5`A7K@B8YJ@T      @5`     @BIQ@T@     @5_|hs@B@T     @5^vȴ9X@B
M;@T     @5^5?|@B1@U      @5^zG@B&@U@     @5^5?|@B	@U     @5]-V@Bu!@U     @5^5?|@B	Dg8~@V      @5`     @B	o@V@     @5^"@B
&IR@V     @5^Q@B
)y@V     @5^5?|@B
 ě@W      @5]-V@B
ڹY@W@     @5]@B
 ѷ@W     @5]/w@B
~@W     @5\hr@B
<64@X      @5Z^5?|@B
`A@X@     @5XbM@B
@4@X     @5SE@BC@X     @5S33333@B
F
L0@Y      @5RnO@B
!R@Y@     @5RnO@B
sh@Y     @5RnO@Bs@Y     @5Nvȴ9X@B%@Z      @5G-@B?@Z@     @5@ěT@B%@Z     @5>Q@B
M;@Z     @57-@B,@[      @5.zG@B͞@[@     @5)^5?}@BF]d@[     @5$S@BoiDg8@[     @5 A7K@BC@\      @5vȴ9X@Bae@\@     @5S@Bd7