CDF   |   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070287     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $97de60e7-99a5-41f4-9cc3-a164b5048cf0   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:50    
date_modified         2012-11-07T14:05:30    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.79175      geospatial_lat_max        	-25.79175      geospatial_lon_min        	112.59159      geospatial_lon_max        	112.59159      geospatial_vertical_min       07.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T06:52:34Z   time_coverage_end         2007-08-17T06:52:34Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       139.2      
ship_speed        5.2    source_filename       444_LEEUWIN_0287.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        5.80   CTD_MaxRawPressure        130.30     CTD_MinPressureforInterp      6.20   CTD_MaxPressureforInterp      130.30     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍV9ʰ ě@\%ܜM  @      @6g-@AC@       @6gzH@A@"      @6h9Xb@A_p@$      @6gzH@A	k@&      @6dj~@AXy=@(      @6cS@Ay=c@*      @6b\(@A@,      @6bM@AeO@.      @6bM@Au!@0      @6ao@AU2a|@1      @6a7Kƨ@AK]c@2      @6`A7K@Au!@3      @6_vȴ9@Aࠐ-
@4      @6_vȴ9@AU2a|@5      @6_vȴ9@A
=q@6      @6_;dZ@A4m9@7      @6^"@A_F@8      @6^Q@AH@9      @6]-V@A[6@:      @6]p
=@Ahۋq@;      @6]/w@AQ@<      @6\hr@A@=      @6\(\@AA7K@>      @6[S@AQ@?      @6[C%@AbM@@      @6["`B@AK]c@@     @6Z1'@AYJ@A      @6Y@A{@A     @6Y+@Au!@B      @6Xtj@AIQ@B     @6XbM@A@C      @6W+@A'RT`@C     @6Vȴ9X@AQ@D      @6S@A҈p@D     @6O;dZ@Au@E      @6Ix@A0U2a|@E     @6@n@AeO@F      @68bM@A`A7L@F     @6*=p
@A&@G      @6lC@A=b@G     @6Q@A!-w2@H      @5nO@Avȴ9X@H     @57KƧ@AVϫ@I      @5dZ@AGz@I     @5-V@An@J      @5n@AC@J     @5ěT@A=K@K      @5A7K@Ad8@K     @5tj@AC%@L      @5"`B@Ahr!@L     @5F@A\(@M      @5O;d@AH@M     @5KƧ@ABZc @N      @5E@Aߤ?@N     @5E@Am\@O      @5-V@Ao@O     @5$/@B >BZc@P      @5vE@BkP|@P@     @5o-V@B͞&@P     @5l1&y@BfB@P     @5j~"@BMj@Q      @5gzH@B]cA@Q@     @5dtj@Bݗ+k@Q     @5b\(@B!-w2@Q     @5a7Kƨ@BQ@R      @5a7Kƨ@BJ@R@     @5`     @Bn.@R     @5^vȴ9X@B҈@R     @5]E@BtSM@S      @5]E@B64@S@     @5]E@Bj~#@S     @5\hr@BcA \@S     @5\j~#@B+a@T      @5\1&@B@T@     @5\j~#@BO;@T     @5ZG{@BlC@T     @5Y^5?}@B	o@U      @5Xtj@B
u%F
@U@     @5XbM@B
~@U     @5VE@BQ@U     @5Qhr @B!-w@V      @5NzG@B
/w@V@     @5IlD@BtSM@V     @5F+J@B
B@V     @5D/@B
@W      @5C
=p@B
-V@W@     @5Bm@B1.@W     @5Ao@B1@W     @5Ao@BKƧ@X      @5Ao@BK]d@X@     @5A$/@B[W>@X     @5AGz@BA7K@X     @5AGz@B	ԕ+@Y      @5BI^5@Bo hی@Y@     @5AGz@B-
@Y     @5<hr@Be+a@Y     @5;dZ@B^5?}@Z      @52nO@Bn.@Z@     @5)7KƧ@BL_@Z     @5%@BI^5?@Z     @5#$@B1@[      @5-V@B+j@[@     @59XbN@Bq@[     @5$/@BA [@[     @4+@BTɆ@\      @49Xb@B@\@     @4M@Bl!-@\     @4ޗO;@BěT@\     @4j~#@BB@]      @4I^@B-@]@     @4ٙ@BI^5@]     @4bM@BB@]     @4/@BZc@^      @433333@BkP|@^@     @4bM@B ě@^     @4@B@4n@^     @4n@B@4n@_      @4`A7L@BS&@_@     @4S@Bu%@_     @4n@Bc	@_     @4;dZ@BD@`      @4Q@Bs@`      @4S@Bm@`@     @4vȴ@BnP