CDF   |   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070290     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $9228d1da-7d24-4b60-90ce-1f63fdd67ed6   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:51    
date_modified         2012-11-07T14:05:30    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.73523      geospatial_lat_max        	-25.73523      geospatial_lon_min        	112.59440      geospatial_lon_max        	112.59440      geospatial_vertical_min       03.00      geospatial_vertical_max       126.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T08:20:46Z   time_coverage_end         2007-08-17T08:20:46Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       138.1      
ship_speed        9.4    source_filename       444_LEEUWIN_0290.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        2.50   CTD_MaxRawPressure        126.00     CTD_MinPressureforInterp      2.60   CTD_MaxPressureforInterp      126.00     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍA98	@\&
L/ @      @6}p
=@Atj~@      @6}p
=@A]cA@      @6{lC@Am\@      @6{lC@A33333@      @6|(\@A~@       @6{S@A ѷ@"      @6{Ƨ@AY@$      @6{S@As@&      @6{S@An@(      @6wO;d@AI^5@*      @6uQ@AGE85@,      @6tzG@AL_@.      @6tzG@Ah	ԕ@0      @6t9XbN@A⒣S&@1      @6s@A)_@2      @6rm@A^5?|@3      @6qhr @AOv`@4      @6qhr @AZc@5      @6pbM@As@6      @6o;dZ@A=p
@7      @6o-V@AL_@8      @6o\(@A@4@9      @6o\(@A^5?|@:      @6o;dZ@AqiC@;      @6n+@AJL@<      @6nO;@AM@=      @6nVu@A)y@>      @6m@AGE85@?      @6l@A:)y@@      @6lC@A1'@@     @6lC@As@A      @6kƧ@AOv`@A     @6kƧ@A.H@B      @6kC%@AC\@B     @6kC%@A^5?|@C      @6jG{@A:)y@C     @6j~"@A3@D      @6j=p
@AY}@D     @6ilD@A"`@E      @6ilD@AGE85@E     @6i7KƧ@A.H@F      @6hr Ĝ@A_o@F     @6ffffff@A^@G      @6eQ@A_p@G     @6cnP@Aae@H      @6bM@Ao@H     @6`     @AN;6@I      @6]@Axl"h
@I     @6[lC@AڹY@J      @6Y@AW@J     @6WKƧ@A:)z@K      @6T9XbN@AA [@K     @6Q7Kƨ@AɅoi@L      @6NzG@AXy=@L     @6G+I@Ab}V@M      @6BnO@A@M     @69@An.3@N      @6.+@Al!-@N     @6"I^5@A2W@O      @6"`@A6z@O     @6-V@A\N@P      @6M@AV@P@     @5"`@AIQ@P     @5zG@A@P     @5t@A     @Q      @5C@A@Q@     @5x@AM@Q     @5S@AE@Q     @5Q@A8YK@R      @5"`B@AO
M@R@     @5t@B 	k@R     @533333@BN;6@R     @5;dZ@BS&@S      @5@BڹY@S@     @5x@BMj@S     @5fffff@BƧ@S     @5
=p@B1&y@T      @57Kƨ@Bq@T@     @5     @B쿱[@T     @5     @B@T     @5|hs@B@U      @5~"@BJM@U@     @5~"@BK]@U     @5}-V@Bu@U     @5{lC@B5Xy>@V      @5zvȴ@B!.H@V@     @5yXbM@BIQ@V     @5u`A7L@Bݗ@V     @5nzG@B!.@W      @5hr Ĝ@B hۋ@W@     @5c$@B3@W     @5`n@B73@W     @5^vȴ9X@By=c@X      @5["`B@B	 [7@X@     @5Vt@B	rGE@X     @5S@B
䎊@X     @5RnO@B
ݘ@Y      @5P`A7@B
@4@Y@     @5P`A7@B҉@Y     @5KQ@B=K^@Y     @5EQ@Bj~#@Z      @5B`A@BZ@Z@     @5@ěT@B
!.@Z     @5A$/@BK]d@Z     @5=p
=@BE84@[      @5;lC@B`A@[@     @51l@Ba@N@[     @50bM@B?@[     @52-V@BF
L0@\      @52-V@B1@\@     @52 ě@BoiDg@\     @52-V@B?@\     @50bM@Bt@]      @5.Vu@B_ح@]@     @5+Ƨ@B͞@]     @5*=p
@Bn@]     @5*=p
@B:~ @^      @5&-@B'RT`@^@     @5#
=p@BD*@^     @5!7Kƨ@BbM@^     @5      @BNU@_      @5"@B$tT@_@     @5"@B҈p@_     @5vȴ9X@B-w1