CDF   {   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070294     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $6359ebc9-65b5-4088-8678-61de32ba7a5b   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:51    
date_modified         2012-11-07T14:05:31    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.80873      geospatial_lat_max        	-25.80873      geospatial_lon_min        	112.60619      geospatial_lon_max        	112.60619      geospatial_vertical_min       08.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T11:27:14Z   time_coverage_end         2007-08-17T11:27:14Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       136.8      
ship_speed        4.9    source_filename       444_LEEUWIN_0294.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        6.80   CTD_MaxRawPressure        130.30     CTD_MinPressureforInterp      7.50   CTD_MaxPressureforInterp      130.30     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍދ0*9KI@\&$Jb @       @6nVu@A=K^@"      @6nzG@AW@$      @6mhr!@AZ@&      @6nzG@Au%F
@(      @6mO;dZ@AlD@*      @6lC@A3@,      @6kƧ@AZc@.      @6kƧ@Aa|Q@0      @6kƧ@A@1      @6lI^5?@A`A@2      @6mV@A1'@3      @6kQ@Ag	@4      @6mV@Aὥ@5      @6kƧ@A^5?|@6      @6fx@A_p@7      @6d9XbN@AeO@8      @6b`A@A_p@9      @6_vȴ9@A	ԕ+@:      @6]-V@Ahۋq@;      @6\hr@AbM@<      @6[lC@A[6@=      @6Zvȴ@A-
@>      @6Y@An@?      @6Xtj@AXy=@@      @6W
=p@AU2a|@@     @6U\(@Au!@A      @6S33333@A{@A     @6P ě@A1'@B      @6I^5?}@A%2@B     @6E@A1.@C      @6?vȴ9@A
qu@C     @66E@AC\@D      @6-@A(\@D     @6#$@AE@E      @61&@A+@E     @6\(@AO;d@F      @6I^@A>6z@F     @5Q@A-w1@G      @5ěT@AY@G     @5x@A,<@H      @5E@AZ@H     @5?|h@AQ@I      @5M@A
qv@I     @5^5?|@AO
M@J      @5O;d@A ě@J     @5t@AF]d@K      @533333@A@K     @5n@AiB@L      @5zG@A@L     @5M@Al!-@M      @5E@B $xG@M     @5O;dZ@BrGE8@N      @5r Ĝ@B=K^@N     @5-@Bm\@O      @5Z1@B!-w@O     @57Kƨ@BS@P      @5|@B2W@P@     @5xQ@Bߤ@@P     @5rnO@B#@P     @5mO;dZ@BVl!@Q      @5mhr!@B_ح@Q@     @5pA7K@B{J#:@Q     @5o-V@Br Ĝ@Q     @5nO;@BoiDg8@R      @5nzG@BѷX@R@     @5nzG@B4m@R     @5mV@BNU@R     @5j^5?|@B	Y}@S      @5jn@B	R@S@     @5kI^@B
g	@S     @5jn@B
͞&@S     @5j=p
@B
,<@T      @5ix@B
sP@T@     @5i7KƧ@B9@T     @5hr Ĝ@B6z@T     @5h1&x@B
m@U      @5g+I@B
Y@U@     @5e@B
C,@U     @5eQ@B
d7@U     @5a$/@B
<64@V      @5[lC@BPH@V@     @5Vt@Bs@V     @5U$/@BN;@V     @5SE@B1&@W      @5Qhr @BN;@W@     @5NQ@B5Xy@W     @5H9Xb@Bhr@W     @5G+I@B
Ϫ͞@X      @5GlC@B\N<@X@     @5G-@Bm\@X     @5G-@Beں@X     @5E?|h@B\(@Y      @5<j~#@BkP@Y@     @5-V@B@Y     @5/w@B)^	@Y     @5G{@Bo h@Z      @5@B`d@Z@     @5
=p@B9XbN@Z     @5$/@Bo i@Z     @5 ě@B'0@[      @5Q@B$/@[@     @5-@BiB@[     @5/@Br@[     @4"@B[W>@\      @4KƧ@B7KƧ@\@     @4nP@B|@\     @4R@Be@\     @4
=q@B.H@]      @4-V@B.H@]@     @4I^@BkP|@]     @4x@B1'@]     @4I^5@B䎊@^      @45?|@BC\@^@     @41'@B&@^     @4XbM@BF]c@^     @4Q@Bp:@_      @4׍O;d@Bu%F
@_@     @4?|h@Bᰊ@_     @4E@B~@_     @4Q@B ѷ@`      @4zG@BL/{@`      @4tj~@Bu%@`@     @4nO@B'/