CDF   y   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070295     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $ee5de05b-933e-45e0-8d23-6daa9bd2432a   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:51    
date_modified         2012-11-07T14:05:31    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.77131      geospatial_lat_max        	-25.77131      geospatial_lon_min        	112.65037      geospatial_lon_max        	112.65037      geospatial_vertical_min       04.00      geospatial_vertical_max       124.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T13:48:32Z   time_coverage_end         2007-08-17T13:48:32Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       127.3      
ship_speed        7.5    source_filename       444_LEEUWIN_0295.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        2.70   CTD_MaxRawPressure        124.50     CTD_MinPressureforInterp      3.50   CTD_MaxPressureforInterp      124.50     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ? 9ty@\)~+ @      @67Kƨ@A-V@      @67Kƨ@A#9@      @6Gz@A.H@      @6Gz@A"`@       @67Kƨ@A@"      @67Kƨ@AiB@$      @67Kƨ@A@&      @6Gz@As@(      @6hr @Aԕ*@*      @6Gz@Aὥ@,      @6$/@A"`@.      @6     @A-@0      @6A7K@A^5?}@1      @6|hs@AႩ@2      @6~vȴ9X@A)y@3      @6|hs@A>BZ@4      @6~"@Ay@5      @6~"@Aᰉ'@6      @6;dZ@AlD@7      @6     @AlD@8      @6vȴ9@Aὥ@9      @6|hs@AN;6@:      @6;dZ@Au@;      @6~vȴ9X@Al@<      @6}p
=@Au%F@=      @6|hr@AR@>      @6{lC@AY}@?      @6z=p
@Ae+a@@      @6xF@A@@     @6xbM@AD@A      @6vȴ9X@A-@A     @6w
=p@Ay@B      @6vt@Al@B     @6tE@Aԕ*@C      @6t/@A	 @C     @6tj~@A.H@D      @6tzG@A>BZ@D     @6ttj@AiB@E      @6stj~@A@E     @6s33333@A.H@F      @6rm@A_o@F     @6rm@AiB@G      @6rm@Aԕ*@G     @6rnO@AiB@H      @6rM@A-@H     @6qhr @As@I      @6pbM@A0U2a|@I     @6pbM@A3@J      @6o;dZ@A^5?|@J     @6ov@AqiC@K      @6n+@A0
@K     @6mhr!@AfB@L      @6i7KƧ@Am@L     @6^Q@A䲕@M      @6V+J@A!-w1@M     @6MO;dZ@Aa|Q@N      @6@ěT@A5Xy>@N     @6.Vu@A7KƧ@O      @6 ěT@A@O     @6$/@A.2@P      @6lC@AK]d@P@     @6\(@A6@P     @5$/@AIQ@P     @5I^@A1'@Q      @5䛥S@A"`B@Q@     @5;dZ@A9@Q     @533333@A!-w2@Q     @57KƧ@AcA @R      @5Q@A_ح@R@     @5`A@A-@R     @57Kƨ@A,@R     @5ěT@AH˒:@S      @5lC@B ѷX@S@     @5?|h@Bxl"h
@S     @5;dZ@BC%@S     @5I^@Ba@O@T      @5$/@B!-w@T@     @5$@B\@T     @5O;d@B
M;@T     @5 ě@B$tS@U      @5lC@B'RT@U@     @5S@B@U     @5S@B@U     @57Kƨ@BTɅ@V      @5{lC@B	x@V@     @5u\(@B
=p@V     @5s@Bq@V     @5s33333@BJM@W      @5r ě@B
Vl!@W@     @5r-V@B$/@W     @5ql@BIQ@W     @5o-V@Bfffff@X      @5mV@BKƧ@X@     @5i^5?}@BeO@X     @5Ql@BMj@X     @5ES@B@Y      @5CS@B
!R@Y@     @5BM@B'@Y     @5Ao@B+@Y     @5@ěT@B^5?}@Z      @5AGz@B?@Z@     @5?|hs@Bb@Z     @5=/w@B,<@Z     @5;S@B@[      @5:1'@B@[@     @59XbM@Bݗ+@[     @58F@B@[     @58bM@B{J#:@\      @57+@B	k@\@     @57O;d@B˒:)@\     @57+@B?@\     @57KƧ@B/V@]      @54zG@BrGE9@]@     @54j~@B	ԕ+@]     @549XbN@BK]c@]     @54j~@B@^      @54E@BbM@^@     @53@B+j@^     @53@B@^     @53E@B73@_      @53E@B>BZc