CDF   }   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070296     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $7c9e3df3-a9a3-445b-9114-68d7b400738d   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:52    
date_modified         2012-11-07T14:05:31    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.47228      geospatial_lat_max        	-25.47228      geospatial_lon_min        	112.40626      geospatial_lon_max        	112.40626      geospatial_vertical_min       06.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T16:15:14Z   time_coverage_end         2007-08-17T16:15:14Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       144.7      
ship_speed        5.5    source_filename       444_LEEUWIN_0296.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        5.90   CTD_MaxRawPressure        130.30     CTD_MinPressureforInterp      5.90   CTD_MaxPressureforInterp      130.30     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍW9xW
@\ )k @      @6WO;d@An@      @6V+J@A ě@       @6WKƧ@AG{@"      @6WKƧ@A{m@$      @6WO;d@A ě@&      @6WKƧ@AڹY@(      @6WlC@AY@*      @6WO;d@AfB@,      @6WO;d@AC,z@.      @6WO;d@A@0      @6WO;d@A>B@1      @6XbM@A⒣S&@2      @6XbM@A)_@3      @6XbM@A)_@4      @6XbM@A<64@5      @6XbM@AL/{@6      @6WO;d@Aⶮ}Vm@7      @6XbM@A~"@8      @6XQ@A@4@9      @6XQ@Aⅇݘ@:      @6W-@A⒣S&@;      @6WO;d@Aⶮ}Vm@<      @6WO;d@AsP@=      @6X1&x@Aⅇݘ@>      @6WO;d@A@4n@?      @6W+I@A⩓@@      @6Vȴ9X@AW'@@     @6Vfffff@A⒣S&@A      @6U$/@A:)y@A     @6TzG@Au%F
@B      @6TzG@A͞&@B     @6TzG@Au%F
@C      @6TzG@AY@C     @6TzG@Aⅇݘ@D      @6TzG@A0
@D     @6T9XbN@A~"@E      @6Rm@A䎊@E     @6LI^5?@A⟾vȴ@F      @6J=p
@A⩓@F     @6HF@AD@G      @6H1&x@AC,z@G     @6GzH@A䎊q@H      @6G+I@A'/@H     @6F-@A"`B@I      @6Dtj@Ajf@I     @6B`A@A~$@J      @6BM@A㹌~($@J     @6BM@Aa@O@K      @6B\(@AJ@K     @6B ě@A6@L      @6Ao@Atj@L     @6A7Kƨ@AQ@M      @6AGz@A\N@M     @6@ěT@A,<@N      @6@A7K@A%1@N     @6?-V@A%2@O      @6>vȴ9X@ATɆ@O     @6;"`B@A/w@P      @69^5?}@A凓ݗ@P@     @67O;d@A!.@P     @65`A7L@AYJ@P     @61l@A}Vl@Q      @6'+I@AO
M@Q@     @6E@A@Q     @6M@A&x@Q     @5"`B@AZ1@R      @5"`B@ADg8~@R@     @5I^5@AD@R     @5"@AFs@R     @5ݲ-V@Aԕ*@S      @5(\@A)^	@S@     @5ؓtj@A9XbN@S     @5Լj~@A`d@S     @5У
=q@A
=p@T      @5lD@A+j@T@     @5`A7L@B C@T     @5;dZ@B	 @T     @5Q@B~"@U      @5tj~@B$@U@     @51&y@Bݗ+k@U     @5x@BO
M@U     @5S@B?|h@V      @5`A@B.2@V@     @5S@BFs@V     @5ěT@BFs@V     @5Q@B\(@W      @51&@B$xG@W@     @5G{@B>BZc@W     @5\(@B@@W     @5hr @B	x@X      @5hr!@B
u%F@X@     @5r Ĝ@B
W@X     @5~Q@Btj@X     @5xQ@B
/w@Y      @5ov@BT@Y@     @5e@B hۋ@Y     @5]E@B
=p@Y     @5WO;d@BU=@Z      @5O\(@B4m9@Z@     @5Hr Ĝ@B
(@Z     @5Dtj@B{@Z     @5A$/@BD@[      @5=-V@B$/@[@     @5:^5?|@Bp:@[     @55?|h@B^5?}@[     @50
=q@Bg	@\      @5,C@Bh	ԕ@\@     @5#$@B@\     @5 A7K@B@\     @5Q@BC@]      @5+@BJM@]@     @5KƧ@BB@]     @5E@B(@]     @5zG@Bݗ@^      @5zG@B@^@     @5zG@B;5X@^     @5 ě@B4K@^     @5&x@B+I@_      @5
=q@B	@_@     @5 ě@BPH@_     @5&x@B&x@_     @5O;@Br Ĝ@`      @5Q@Btj@`      @5	lD@BN;5@`@     @5
~"@Bx