CDF   t   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070299     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $8b645019-46f6-4f51-811b-13a095406bad   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:52    
date_modified         2012-11-07T14:05:31    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.42044      geospatial_lat_max        	-25.42044      geospatial_lon_min        	112.38443      geospatial_lon_max        	112.38443      geospatial_vertical_min       01.00      geospatial_vertical_max       116.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T19:26:40Z   time_coverage_end         2007-08-17T19:26:40Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       147.0      
ship_speed        8.4    source_filename       444_LEEUWIN_0299.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        0.90   CTD_MaxRawPressure        116.30     CTD_MinPressureforInterp      0.90   CTD_MaxPressureforInterp      116.30     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ9k$@\If{ ?      @6Jn@A:)y@       @6GlC@Aᰉ'@      @6DS@AY}@      @6ES@Aὥ@      @6Hr Ĝ@AOv`@      @6I7KƧ@AR<6@      @6J=p
@AB@       @6J=p
@A'RTa@"      @6Jn@ADg8~@$      @6JG{@A"`@&      @6Jn@Au@(      @6Jn@A7Kƨ@*      @6KC%@A|Q@,      @6KI^@A|@.      @6KI^@Aᦵ(@0      @6KI^@Au@1      @6Jn@Ax@2      @6KƧ@A|@3      @6L@Aᰉ'R@4      @6LI^5?@Ahr @5      @6L@A^5?}@6      @6L@Al@7      @6L@AX@8      @6L@A@9      @6L@AB@:      @6MV@A|Q@;      @6MV@A7Kƨ@<      @6MO;dZ@An.@=      @6MO;dZ@An.@>      @6MO;dZ@A|@?      @6Mhr!@Aᙙ@@      @6MO;dZ@Au@@     @6MO;dZ@Al@A      @6Mp
=@A'RTa@A     @6Mhr!@AoiD@B      @6Mhr!@A|Q@B     @6MO;dZ@AGz@C      @6M@Ao@C     @6M@Aᰉ'R@D      @6M@Ab}@D     @6Mhr!@Ao@E      @6MO;dZ@A^@E     @6MO;dZ@A'RTa@F      @6M/w@AXbM@F     @6MV@AR<6@G      @6Mhr!@A|Q@G     @6ME@ADg8~@H      @6M@A4J@H     @6M}H@Aae@I      @6MO;dZ@A7KƧ@I     @6MV@Ak~(@J      @6NzG@Al@J     @6NzG@A@K      @6NO;@AoiD@K     @6NVu@AR<6@L      @6NVu@Aae@L     @6NVu@An.@M      @6N+@Ab}@M     @6NO;@Au!S@N      @6N+@Ab}@N     @6O\(@ArGE8@O      @6O\(@AGz@O     @6O\(@A&x@P      @6O\(@AႩ@P@     @6O-V@Au!S@P     @6Ovȴ9@AXbM@P     @6O;dZ@A:S@Q      @6O;dZ@A|Q@Q@     @6O;dZ@Ao hی@Q     @6O;dZ@Ab}@Q     @6O;dZ@AXbM@R      @6P ě@Aᦵ(@R@     @6O;dZ@AႩ@R     @6P ě@AX@R     @6O;dZ@A	 @S      @6N+@A3@S@     @6MO;dZ@A䎊q@S     @6MV@AD@S     @6MO;dZ@AD@T      @6L@AS@T@     @6GzH@AE@T     @6F$/@A@T     @6C
=p@As@U      @6?vȴ9@AsPH@U@     @69@ArGE@U     @6.+@AY@U     @6#$@A\(@V      @6M@A@V@     @5"`B@A%F
L@V     @5Ƨ@AfA@V     @5߾vȴ9@AiB@W      @5x@A64@W@     @5x@A\(@W     @5bM@B䎊@W     @5
=q@B*0U2@X      @5$@B(@X@     @5(\@B&I@X     @5Q@BXe@X     @5?|h@B@Y      @5&x@BK]c@Y@     @5-V@Br Ĝ@Y     @5x@B	o hی@Y     @5ěT@B
Y@Z      @5;dZ@B
͞&@Z@     @5~Q@BI^@Z     @5~vȴ9X@Bs@Z     @5~vȴ9X@B"`B@[      @5~vȴ9X@B
m\@[@     @5~vȴ9X@B&@[     @5~vȴ9X@BP{@[     @5}O;dZ@BwkP@\      @5y"`@B
zxl"h@\@     @5v+J@BBZc @\     @5l1&y@B[W>@\     @5e@BbM@]      @5^vȴ9X@BD