CDF   }   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070300     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $b6b59b30-9ca5-4580-8f48-b557048e4641   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:52    
date_modified         2012-11-07T14:05:31    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.40974      geospatial_lat_max        	-25.40974      geospatial_lon_min        	112.38183      geospatial_lon_max        	112.38183      geospatial_vertical_min       06.00      geospatial_vertical_max       130.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T19:43:32Z   time_coverage_end         2007-08-17T19:43:32Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       147.3      
ship_speed        8.0    source_filename       444_LEEUWIN_0300.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        5.80   CTD_MaxRawPressure        130.30     CTD_MinPressureforInterp      5.80   CTD_MaxPressureforInterp      130.30     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ9h{@\om @      @6L1&y@A@      @6H9Xb@AM@       @6I^5?}@Ad7@"      @6J=p
@AOv`@$      @6IlD@AI^5@&      @6J=p
@Ae+@(      @6Jn@A-V@*      @6L1&y@AOv`@,      @6KƧ@Ao@.      @6KdZ@Ae@0      @6KƧ@A>BZ@1      @6KdZ@Aᰉ'@2      @6L1&y@As@3      @6L1&y@A1'@4      @6LI^5?@Au%F@5      @6L(\@AR@6      @6L1&y@AB@7      @6LI^5?@A-@8      @6L1&y@Ao@9      @6L1&y@Ae@:      @6LC@Ao@;      @6L@A@<      @6L@AB@=      @6L1&y@Ao@>      @6LC@AX@?      @6KƧ@Ab}@@      @6KƧ@A@@     @6LC@An.@A      @6LC@An.@A     @6MO;dZ@Aᦵ(@B      @6Mhr!@A'RTa@B     @6M@Aᰉ'@C      @6ME@AႩ@C     @6M@ArGE8@D      @6M@AXbM@D     @6M@A[W>6@E      @6M@A[W>6@E     @6M@Ao@F      @6NVu@A[W>6@F     @6NO;@A^@G      @6NVu@AB@G     @6N+@Aae@H      @6Nvȴ9X@A|Q@H     @6NVu@AXbM@I      @6NVu@AXbM@I     @6NVu@Au!S@J      @6N+@AႩ@J     @6NVu@Ak~(@K      @6Nvȴ9X@ArGE8@K     @6NVu@A:S@L      @6NVu@A-w1@L     @6Nvȴ9X@AGz@M      @6NO;@AJE@M     @6NVu@Au!S@N      @6NO;@A[W>6@N     @6N+@ArGE@O      @6N+@ADg8~@O     @6Ov@ADg8~@P      @6O\(@A*0U2a@P@     @6O\(@AQ@P     @6O;dZ@Ak~(@P     @6Ovȴ9@A4J@Q      @6P     @Ak~(@Q@     @6P ě@AoiD@Q     @6PbM@A|Q@Q     @6PbM@A7Kƨ@R      @6PbM@A'RTa@R@     @6PbM@ArGE8@R     @6P
=q@A|@R     @6P
=q@Ahr @S      @6P
=q@A^5?}@S@     @6PbM@A@S     @6P ě@Aᰉ'@S     @6P ě@Aὥ@T      @6PbM@Aᙙ@T@     @6O;dZ@AC\@T     @6O\(@A:)y@T     @6O-V@AnO@U      @6O\(@AJL@U@     @6O\(@Au%F
@U     @6L1&y@A@U     @6KC%@A64@V      @6I^5?}@A俱[W?@V@     @6>zG@A@V     @6333333@A\(@V     @6-@Aj~#@W      @6)7KƧ@A$/@W@     @61&@A|@W     @6"@A{m@W     @6@AC,@X      @5"@A!R<@X@     @5㕁$@Ae+@X     @5Q@Aqj@X     @5̋C@AT@Y      @5o@B$/@Y@     @5KƧ@B0
@Y     @5lD@B2W@Y     @5j~@B1&@Z      @5Q@B
L/@Z@     @5?|h@B!.I@Z     @5E@Bv@Z     @5-V@B&@[      @5Q@BYJ@[@     @5KƧ@B	rGE@[     @5`A7L@B	o hی@[     @5Z1@B=K^@\      @5n@BwkP@\@     @5|hr@B
84֡@\     @5xF@B
+j@\     @5wKƧ@B
ᰉ@]      @5tzG@B@]@     @5ql@B;5X@]     @5i"`@B]cf@]     @5f$/@BK]d@^      @5`ěT@BH@^@     @5\C@B@^     @5YlD@BD@^     @5Vȴ9X@BIQ@_      @5O;dZ@BDg8~@_@     @5I7KƧ@B0
)@_     @5?|hs@Bu%F@_     @5<1&@B䎊q@`      @5:vȴ@B=K^@`      @58\)@B&@`@     @57
=p@B6