CDF   v   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070301     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $0451ccd7-279e-46da-a348-8a7d674fb413   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:52    
date_modified         2012-11-07T14:05:31    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.44510      geospatial_lat_max        	-25.44510      geospatial_lon_min        	112.37952      geospatial_lon_max        	112.37952      geospatial_vertical_min       04.00      geospatial_vertical_max       121.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T20:08:54Z   time_coverage_end         2007-08-17T20:08:54Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       148.5      
ship_speed        7.4    source_filename       444_LEEUWIN_0301.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        2.60   CTD_MaxRawPressure        121.60     CTD_MinPressureforInterp      3.30   CTD_MaxPressureforInterp      121.60     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍv9qs@\JAc @      @6<1&@AڹY@      @6<(\@AS&@      @6>zG@A䎊q@      @6?|hs@A⟾vȴ@       @6?vȴ9@Aᰊ@"      @6?vȴ9@AT`d@$      @6@     @AZc@&      @6@A7K@AJL@(      @6@A7K@AJL@*      @6@A7K@A@4n@,      @6@A7K@A)y@.      @6@     @A=p
@0      @6?vȴ9@A3@1      @6@     @Aⅇݘ@2      @6@ěT@AT`d@3      @6@n@A-V@4      @6@ěT@AGE85@5      @6@ěT@A0U2a|@6      @6A$/@A=p
@7      @6@ěT@Au%F
@8      @6@ěT@A3@9      @6@`A7@Ah	ԕ@:      @6AGz@Ah	ԕ@;      @6AGz@AC\@<      @6A7Kƨ@A)y@=      @6A7Kƨ@A^5?|@>      @6A7Kƨ@AGE85@?      @6A7Kƨ@AnO@@      @6A$/@A3@@     @6A$/@A@4n@A      @6@ěT@AJL@A     @6@`A7@A6C@B      @6A$/@A{m@B     @6Ao@A6C@C      @6BI^5@AC\@C     @6BI^5@As@D      @6AR@A-V@D     @6AR@A0U2a|@E      @6Ao@A#9@E     @6Ao@A>BZ@F      @6A7Kƨ@A1'@F     @6Ao@A1'@G      @6A7Kƨ@A-@G     @6Ao@A-@H      @6AGz@A@H     @6A7Kƨ@AI^5@I      @6Ahr @A䎊@I     @6BI^5@A3@J      @6B-V@A3@J     @6BI^5@Ae+@K      @6BM@A1'@K     @6BM@A6C@L      @6BM@AI^5@L     @6B\(@As@M      @6B ě@As@M     @6B\(@AT`d@N      @6BM@A0U2a|@N     @6B\(@A@4n@O      @6B`A@AI^5@O     @6B\(@A3@P      @6B\(@A6C@P@     @6B`A@A@P     @6CnP@A_o@P     @6B`A@A-@Q      @6CS@AiB@Q@     @6Ctj~@A_o@Q     @6CS@A^5?}@Q     @6C
=p@A	 @R      @6C
=p@A#9@R@     @6C
=p@A.H@R     @6CE@A@4n@R     @6C$@AwkQ@S      @6C$@A)_@S@     @6C$@Ac	@S     @6C$@As@S     @6C$@AS@T      @6B\(@AL_@T@     @6BI^5@A/{J#@T     @6Ao@Ag8}@T     @6@A7K@A!-w@U      @6>vȴ9X@A唯O
@U@     @6=p
=@Ash@U     @6<I^5?@A8YJ@U     @6;lC@A}Vl@V      @6;I^@AXe@V@     @6:1'@A+I@V     @68F@A˒:)@V     @67+@A*0U@W      @62 ě@Ap:@W@     @6^5?|@A6z@W     @6l@Atj@W     @5O;d@A.2@X      @5~"@AiDg8@X@     @5E@A\(@X     @5?|h@Azxl"@X     @5A7K@A4֡a@Y      @5Q@BY@Y@     @5hr@BL_@Y     @5j~@Bm8@Y     @5n@B@Z      @5
=p@BϪ͞@Z@     @5tE@B	R@Z     @5qhr @B)^	@Z     @5o\(@BzG@[      @5nQ@B>B[@[@     @5m-V@B
M:@[     @5lC@B
8YK@[     @5kC%@BH@\      @5i7KƧ@BXe@\@     @5gzH@B3@\     @5e@B
qu@\     @5c
=p@BNU@]      @5a7Kƨ@B_F@]@     @5Y@B@]     @5WKƧ@Bhr @]     @5U$/@B[W>6@^      @5Q&x@B	k~@^@     @5NVu@B8YJ