CDF   }   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070303     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $9e6f37cf-c318-485a-8074-4a2d7fa65329   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:53    
date_modified         2012-11-07T14:05:32    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.44426      geospatial_lat_max        	-25.44426      geospatial_lon_min        	112.37435      geospatial_lon_max        	112.37435      geospatial_vertical_min       04.00      geospatial_vertical_max       128.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T20:54:18Z   time_coverage_end         2007-08-17T20:54:18Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       149.0      
ship_speed        6.8    source_filename       444_LEEUWIN_0303.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.50   CTD_MaxRawPressure        128.60     CTD_MinPressureforInterp      3.70   CTD_MaxPressureforInterp      128.60     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍ% 9q@\Y} @      @66t@A㕁$@      @67KƧ@A9@      @67O;d@A"`B@      @67+@A=K^@       @67O;d@AC,@"      @67O;d@A҉@$      @67O;d@An@&      @68bM@AW@(      @68>BZc@AfB@*      @681&x@AY@,      @68Q@AsP@.      @68r Ĝ@A ѷ@0      @681&x@AL/{@1      @68tj@A,<@2      @68r Ĝ@A<64@3      @68Q@AsP@4      @68Q@A>B@5      @67O;d@AnP@6      @67-@A<64@7      @67+@A⟾vȴ@8      @67O;d@A>B@9      @68Q@Aⶮ}Vm@:      @689Xb@AL/{@;      @68tj@Ap:@<      @68F@A{m@=      @69+@AS&@>      @68F@A͞&@?      @69+@AL/{@@      @69XbM@AW@@     @69@Ag	@A      @69@AwkQ@A     @69x@A@B      @69@Aⶮ}Vm@B     @69XbM@AG{@C      @69@A⟾vȴ@C     @69@Aᰊ@D      @69@Ad7@D     @68F@Aⶮ}Vm@E      @68F@Axl"h
@E     @68tj@AnO@F      @69+@Axl"h
@F     @69"`@Axl"h
@G      @69@Aa|Q@G     @69XbM@Aa|Q@H      @69@AW@H     @6:1'@AS&@I      @69@A~"@I     @69+@Axl"h
@J      @69+@Ap:@J     @69+@A@4@K      @69XbM@A{m@K     @69XbM@AnO@L      @69XbM@AW'@L     @69XbM@A~"@M      @69+@A⩓@M     @69XbM@A@4@N      @69+@A⩓@N     @69@A⒣S&@O      @69@AY@O     @67O;d@AQ@P      @68tj@AP{@P@     @68tj@A1&y@P     @67lC@A%1@P     @67O;d@A쿱[@Q      @66t@A(@Q@     @64E@A帺@Q     @64zG@AIQ@Q     @649XbN@A ѷY@R      @63tj~@A'/W@R@     @61R@Ay@R     @61l@AzH@R     @61hr @A䎊r@S      @61hr @A
qu@S@     @60 ě@A|@S     @6/-V@A*0U2a@S     @6-@A>BZ@T      @6,C@A	 @T@     @6,C@AW'@T     @6,1&y@A꒣S&@T     @6)x@A=K^@U      @6$S@AM:@U@     @6hr@A,=@U     @6E@A_o@U     @6
hr!@Aae@V      @6$@AF]c@V@     @5S@Ag8}@V     @5I^5?@A@V     @5+J@A	k@W      @5tj@AR<6@W@     @5Q@As@W     @5tj@A쿱[W@W     @5 ě@B^5?}@X      @5nO@BZ1@X@     @5tj@B\@X     @5O;@B+@X     @57KƧ@B@Y      @5ěT@B+j@Y@     @5tj~@B~($@Y     @5r\(@Bzxl"@Y     @5n"@B
%F
L@Z      @5lI^5?@B
sh@Z@     @5kC%@B
C\@Z     @5jvȴ@B\N<@Z     @5j=p
@Baf@[      @5j~"@B}Vl@[@     @5ix@B'@[     @5i7KƧ@B"@[     @5hr Ĝ@Bb}V@\      @5^vȴ9X@B$/@\@     @5["`B@B{@\     @5Vȴ9X@B@\     @5TE@B~($@]      @5S33333@Bs@]@     @5Q&x@BB@]     @5O;dZ@B-@]     @5NzG@B)y@^      @5MO;dZ@BlD@^@     @5LC@Bo@^     @5Jn@BD@^     @5G+I@Bᰉ'@_      @59XbM@Bm\@_@     @52nO@BƧ@_     @5.Vu@B9XbN@_     @5,C@Bqj@`      @5,1&y@B쿱[