CDF   w   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070304     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $399b37fa-783e-4997-b393-f8ee7e0aaa86   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:53    
date_modified         2012-11-07T14:05:32    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.40761      geospatial_lat_max        	-25.40761      geospatial_lon_min        	112.37148      geospatial_lon_max        	112.37148      geospatial_vertical_min       03.00      geospatial_vertical_max       121.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T21:20:15Z   time_coverage_end         2007-08-17T21:20:15Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       148.9      
ship_speed        8.2    source_filename       444_LEEUWIN_0304.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        1.80   CTD_MaxRawPressure        121.00     CTD_MinPressureforInterp      2.20   CTD_MaxPressureforInterp      121.00     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍff9hY!@\TǏ  @      @69+@A
=p@      @68F@AdZ@      @68F@A
=p@      @6:1'@AeO@      @6:1'@AA@       @6:1'@AJ#9@"      @6:1'@AZ@$      @6:^5?|@AZ@&      @6:1'@A6z@(      @69lD@A33333@*      @69@A"`B@,      @68\)@A{J#9@.      @6:1'@Aqu!@0      @6:vȴ@A/V@1      @6:1'@AS&@2      @6:1'@A/V@3      @6:vȴ@A&@4      @6:vȴ@A'/@5      @6:n@A㋬q@6      @6;S@AdZ@7      @6;lC@A&@8      @6;S@AnP@9      @6;C%@AW>6z@:      @6;S@A,zxl@;      @6;"`B@A=K^@<      @6;dZ@A/V@=      @6<j~#@A,zxl@>      @6<1&@A9@?      @6<1&@AJ#9@@      @6<1&@A=K^@@     @6<1&@A8}H@A      @6<hr@AU=@A     @6<hr@A߱[W>@B      @6<hr@Ao@B     @6<hr@Aߊ	@C      @6=V@A_o@C     @6<1&@AO
M@D      @6<1&@Aߐ@D     @6=/w@A߃{J#:@E      @6=/w@Aߝ-V@E     @6=/w@A߆&@F      @6=/w@Aߓݗ+@F     @6=/w@Aߤ?@G      @6=/w@A|hs@G     @6=/w@AsPH@H      @6=/w@AߚkP@H     @6=/w@AAs@I      @6=/w@ART`e@I     @6=/w@AlC@J      @6=/w@Ay@J     @6=/w@AE84@K      @6=@Av@K     @6=E@A.H@L      @6=E@A
=p@L     @6=E@AC-@M      @6=E@AsPH@M     @6>5?|@A
M;@N      @6>5?|@Av_ح@N     @6>5?|@AO
M@O      @6>5?|@Ay@O     @6>5?|@ART`e@P      @6>vȴ9X@AlC@P@     @6>vȴ9X@Ao@P     @6>vȴ9X@AXe,@P     @6>vȴ9X@AsPH@Q      @6>vȴ9X@AKƧ@Q@     @6>5?|@AiDg8@Q     @6>Q@Av_ح@Q     @6>5?|@Aߓݗ+@R      @6=E@A$xG@R@     @6=-V@A'RT`@R     @6=-V@A6@R     @6=@AQ@S      @6=-V@A_F@S@     @6=-V@A-
q@S     @6=E@A-
q@S     @6>5?|@A ě@T      @6>5?|@A-
q@T@     @6>5?|@A-@T     @6>vȴ9X@A#@T     @6>vȴ9X@A4m9@U      @6>vȴ9X@A'RT`@U@     @6>Q@AD*@U     @6>5?|@A*0@U     @6>Q@A-
q@V      @6>Q@A-
q@V@     @6>5?|@A@V     @6>vȴ9X@AK]c@V     @6>5?|@A˒:*@W      @6>vȴ9X@AbM@W@     @6=/w@A@W     @6<(\@ADg8~@W     @6<(\@A'RTa@X      @6:vȴ@AQ_@X@     @68tj@AF]c@X     @65$/@AE@X     @6%`A7L@AfB@Y      @6#$@An.3@Y@     @6$/@AڹY@Y     @6Q@Asg@Y     @6^5?|@A1@Z      @69XbN@A=b@Z@     @6-@Awk@Z     @5bM@A\(@Z     @5=p
@A@[      @5p
=@Ay@[@     @5-V@AQ@[     @5̋C@A/w@[     @55?|@AiDg8@\      @5
=q@B U@\@     @5
=p@Be+a@\     @5E@BxF]@\     @5I^5?@Bm8@]      @5^5?}@BY|@]@     @51&x@Bv@]     @5-@B$/@]     @59XbN@BrGE9@^      @5|1&@B	o@^@     @5y"`@B
b