CDF   ~   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070306     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $1bbb626e-7e00-4ebd-968d-8d81be44e868   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:53    
date_modified         2012-11-07T14:05:32    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.40756      geospatial_lat_max        	-25.40756      geospatial_lon_min        	112.38935      geospatial_lon_max        	112.38935      geospatial_vertical_min       04.00      geospatial_vertical_max       129.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T22:13:14Z   time_coverage_end         2007-08-17T22:13:14Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       145.8      
ship_speed        8.3    source_filename       444_LEEUWIN_0306.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.20   CTD_MaxRawPressure        129.10     CTD_MinPressureforInterp      3.40   CTD_MaxPressureforInterp      129.10     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍA; 9hU'(c@\C, "@      @6H1&x@AL_@      @6H9Xb@AJL@      @6H1&x@AM@      @6H1&x@Ah	ԕ@       @6Hr Ĝ@As@"      @6I^5?}@A3@$      @6I^5?}@A>BZ@&      @6H\)@AR@(      @6H\)@Aԕ*@*      @6H9Xb@AGE85@,      @6I7KƧ@Aa|Q@.      @6Ix@A#9@0      @6I7KƧ@A.H@1      @6I7KƧ@A.H@2      @6I^5?}@Ae@3      @6I^5?}@A.H@4      @6I^5?}@A2W@5      @6I^5?}@As@6      @6I^5?}@A-@7      @6IlD@AlD@8      @6I^5?}@Aᰉ'@9      @6I^5?}@Aὥ@:      @6I^5?}@A@;      @6I^5?}@A.H@<      @6J=p
@A"`@=      @6IlD@Al@>      @6I^5?}@AiB@?      @6IlD@AX@@      @6J=p
@AiB@@     @6KC%@A>BZ@A      @6KC%@AiB@A     @6KdZ@A|@B      @6J~"@AR<6@B     @6Jn@Ao@C      @6Jn@Ax@C     @6J~"@A|@D      @6Jn@AX@D     @6Jn@AiB@E      @6Jn@AiB@E     @6Jn@A'RTa@F      @6Jn@Aᰉ'R@F     @6Jn@A@G      @6KC%@An.@G     @6KC%@Ab}@H      @6KC%@Aᦵ(@H     @6KI^@Ao@I      @6KI^@AN;6@I     @6KI^@An@J      @6Jn@A^5?}@J     @6KI^@Aԕ*@K      @6Jn@Ao@K     @6Jn@A|@L      @6KI^@Ay@L     @6KI^@AY}@M      @6KI^@AiB@M     @6Jn@A^5?}@N      @6Jn@A#9@N     @6KI^@Aᰉ'@O      @6KI^@Ae@O     @6KI^@A.H@P      @6Jn@A@P@     @6J~"@An@P     @6J=p
@As@P     @6J=p
@A#9@Q      @6J=p
@A0U2a|@Q@     @6J~"@A@4n@Q     @6Jn@AI^5@Q     @6J=p
@A@R      @6J=p
@AkP|@R@     @6J=p
@An@R     @6J=p
@An@R     @6J~"@Ay@S      @6J=p
@As@S@     @6J=p
@As@S     @6J=p
@A)y@S     @6J=p
@AY}@T      @6IlD@An@T@     @6IlD@AN;6@T     @6J=p
@A	 @T     @6IlD@A@U      @6J=p
@AlD@U@     @6J=p
@A.H@U     @6Jvȴ@A䎊@U     @6J=p
@A&IR@V      @6KI^@A_o@V@     @6KC%@Au%F@V     @6KI^@AX@V     @6KQ@A"`@W      @6KƧ@Au%F@W@     @6KƧ@A1'@W     @6LI^5?@AY}@W     @6LI^5?@Aⅇݘ@X      @6KC%@AF
L0@X@     @6J=p
@A
L/@X     @6H1&x@AbM@X     @6Ffffff@A4֡b@Y      @6E@Aa|Q@Y@     @6C$@Aߤ@@Y     @6?;dZ@A\N<@Y     @67KƧ@A|@Z      @65Q@A4֡b@Z@     @64E@A [7@Z     @649XbN@A^@Z     @6)7KƧ@A͞&@[      @6@A	 @[@     @5^5?}@A!R@[     @5vȴ9X@A
M;@[     @5dZ@A@\      @5hr @B `A7@\@     @5v@Bae@\     @5fffff@B'R@\     @5ȴ9X@Bd7@]      @59Xb@B
=p@]@     @5vȴ@Bzxl"h@]     @5j~@BFt@]     @5Q@B	&x@^      @59XbN@B	*0U2a@^@     @5bM@B
qiC@^     @5-V@B
)_@^     @5O;@B
䎊q@_      @5O;@BC,z@_@     @5Z1@B҈@_     @5}E@B
84֡@_     @5p
=q@B
,=@`      @5h9Xb@B
+j@`      @5a$/@B+I