CDF   {   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070310     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $642b035c-6d8f-4407-8a19-5e6d719dde3e   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:54    
date_modified         2012-11-07T14:05:32    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.40172      geospatial_lat_max        	-25.40172      geospatial_lon_min        	112.39987      geospatial_lon_max        	112.39987      geospatial_vertical_min       04.00      geospatial_vertical_max       126.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-17T23:51:52Z   time_coverage_end         2007-08-17T23:51:52Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       143.6      
ship_speed        8.5    source_filename       444_LEEUWIN_0310.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.30   CTD_MaxRawPressure        126.80     CTD_MinPressureforInterp      3.90   CTD_MaxPressureforInterp      126.80     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @ԍu 9f6&-@\xW) &@      @6Stj~@A^5?}@      @6Stj~@A7Kƨ@      @6T9XbN@AoiD@      @6TzG@A@       @6TzG@A7Kƨ@"      @6TzG@Ao@$      @6TzG@Aᰉ'R@&      @6TS@Aᦵ(@(      @6TE@Aᦵ(@*      @6TE@Ab}@,      @6UQ@Ahr @.      @6TE@A^@0      @6Tj~@A^@1      @6Tj~@Ao hی@2      @6TzG@A|Q@3      @6TzG@A'RTa@4      @6T9XbN@AX@5      @6Ttj@AX@6      @6S@Ay@7      @6S@A|Q@8      @6SE@A7Kƨ@9      @6SE@Aᙙ@:      @6SE@Ao@;      @6Stj~@A|Q@<      @6Stj~@A7KƧ@=      @6S@Ax@>      @6SE@Ak~(@?      @6SE@A-w1@@      @6Stj~@Ae+a@@     @6S@A7Kƨ@A      @6T9XbN@Ae+a@A     @6S@A@B      @6S@A&x@B     @6S@AN;5@C      @6T/@A_p@C     @6Tj~@A$/@D      @6S@A_p@D     @6S@Aae@E      @6TzG@A#w@E     @6Tj~@AGz@F      @6TE@A+@F     @6TE@A@G      @6TE@AD@G     @6TE@A_p@H      @6TE@A@H     @6TE@AQ@I      @6TE@A-w1@I     @6TE@A:S@J      @6T/@A*0U2a@J     @6TE@A^@K      @6TE@A$tT@K     @6TE@AN;5@L      @6U?|h@ArGE@L     @6TE@A*0U2a@M      @6U$/@A@M     @6U$/@A^@N      @6U\(@ArGE@N     @6Vt@A	k@O      @6U$/@APH@O     @6U$/@A=b@P      @6Vt@A#w@P@     @6U\(@A_p@P     @6U\(@A@P     @6U\(@A[W>6@Q      @6U$/@ArGE@Q@     @6Vt@A:S@Q     @6U\(@A@N@Q     @6V+J@A	k@R      @6V+J@A	k@R@     @6Vx@A4J@R     @6Vȴ9X@APH@R     @6Vȴ9X@A4֡b@S      @6W
=p@A`A7@S@     @6W
=p@A)^@S     @6W
=p@A@S     @6WO;d@A@T      @6W
=p@ArGE@T@     @6WO;d@A@T     @6WO;d@AѷX@T     @6W
=p@AD@U      @6V+J@A{@U@     @6V-@Ap:@U     @6V+J@A\)@U     @6V+J@ArGE@V      @6V+J@A	k@V@     @6Vt@AD@V     @6Vt@A4J@V     @6Vt@A&x@W      @6U?|h@A7Kƨ@W@     @6TS@AR@W     @6TE@A@W     @6TE@A&IR@X      @6TE@Au%F@X@     @6TE@AQ_@X     @6TzG@A~@X     @6T/@A@Y      @6T/@AW>6z@Y@     @6U?|h@A~@Y     @6U$/@AsP@Y     @6Vt@AxF@Z      @6U\(@AtSM@Z@     @6TE@A$tS@Z     @6P ě@ATɅo@Z     @6Ix@Ag	@[      @6Bm@Aa@@[@     @69+@A@[     @61hr @A-V@[     @6%`A7L@Au!S@\      @6 ě@A쿱[@\@     @6C@AڹZ@\     @6\(@A@\     @5O;d@A.H@]      @57KƧ@Au@]@     @5|hs@AC\@]     @5ٙ@Aa@O@]     @5V@A+I@^      @5Ƨ-@B7Kƨ@^@     @5XbM@Btj@^     @5$/@Bm\@^     @51&y@Bt@_      @5Q@B+@_@     @5hr@B
=q@_     @5F@B
=q