CDF      
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070312     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $c5864759-fdc3-4050-b4cd-e51deb2beb53   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:54    
date_modified         2012-11-07T14:05:32    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.40001      geospatial_lat_max        	-25.40001      geospatial_lon_min        	112.40444      geospatial_lon_max        	112.40444      geospatial_vertical_min       05.00      geospatial_vertical_max       139.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-18T00:45:40Z   time_coverage_end         2007-08-18T00:45:40Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       142.6      
ship_speed        8.7    source_filename       444_LEEUWIN_0312.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        3.90   CTD_MaxRawPressure        139.50     CTD_MinPressureforInterp      4.30   CTD_MaxPressureforInterp      139.50     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @Ԏ΀9fg,@\XOLn (@      @6\j~#@A\)@      @6\j~#@AěT@      @6\(\@A)@       @6\(\@A4֡b@"      @6\I^5?@AF@$      @6\(\@AD@&      @6\(\@Au%F@(      @6\(\@Ap:@*      @6\I^5?@A)@,      @6\(\@Aව4m@.      @6\(\@A-
@0      @6\(\@AYJ@1      @6[lC@A
=q@2      @6\(\@AIQ@3      @6\(\@Au%F@4      @6\(\@A9Xb@5      @6\j~#@A9Xb@6      @6\(\@A9Xb@7      @6\j~#@AIQ@8      @6[lC@Al"h	@9      @6\(\@A)@:      @6\(\@AD@;      @6\(\@A_F@<      @6\(\@Ar Ĝ@=      @6\(\@A@>      @6\(\@An@?      @6\(\@A-
@@      @6\j~#@AYJ@@     @6\(\@AD*@A      @6\1&@Al"h	@A     @6\1&@AH@B      @6\j~#@AU2a|@B     @6\hr@AbM@C      @6\1&@Au!@C     @6[lC@AQ@D      @6[S@AbM@D     @6[S@AoiDg8@E      @6[S@AeO@E     @6[lC@AK]c@F      @6[lC@A䎊r@F     @6\(\@AA7K@G      @6\(\@ANU@G     @6\(\@AK]c@H      @6\(\@AD*@H     @6\(\@A*0U@I      @6\(\@A ě@I     @6[lC@A
qu@J      @6ZG{@A_F@J     @6ZG{@AYJ@K      @6["`B@A୫U@K     @6Zn@AD*@L      @6Y"`@Ad8@L     @6Z1'@AD*@M      @6Z1'@A73@M     @6Z1'@AH@N      @6YXbM@AQ@N     @6W+@A'RT@O      @6Vȴ9X@ATɅ@O     @6V-@A)^@P      @6V-@A	k@P@     @6Vȴ9X@A+@P     @6V+J@A`A7@P     @6Vt@A@Q      @6Vt@AY}@Q@     @6Vȴ9X@Ah	ԕ@Q     @6W
=p@A~@Q     @6W
=p@A	@R      @6W
=p@AQ@R@     @6WO;d@A#@R     @6Vȴ9X@Aqi@R     @6Rm@A	@S      @6S33333@AE84@S@     @6RnO@A;dZ@S     @6NO;@A@S     @6M@AGz@T      @6N+@A邩@T@     @6Jn@A0
)@T     @6E@AZc@T     @6=E@A"`B@U      @68bM@AcA \@U@     @62 ě@AE@U     @6.Vu@A1.@U     @6$/@A1@V      @6j~@AD@V@     @5;dZ@A33333@V     @5@A#@V     @5 ě@AL_@W      @5Vu@A,=@W@     @5@AcA @W     @5I^5?@A
L/@W     @5C%@Ac	@X      @5陙@A'@X@     @5@Au%F@X     @5hr@AI^5@X     @5XbM@Au%@Y      @5fffff@A5Xy@Y@     @59XbN@A@Y     @5zG@A!R<@Y     @5n@A.H@Z      @5lC@ArG@Z@     @5I^5@Bn@Z     @5XbM@B\N@Z     @5zG@Bqu"@[      @5C%@B&I@[@     @5@BFs@[     @5r Ĝ@B@[     @5nP@B;dZ@\      @5;dZ@BNU@\@     @5/w@B)^@\     @5j~#@B	 [7@\     @5(\@B	4J@]      @5G{@B	Q@]@     @5^5?|@B	JE@]     @5XbM@B	hr @]     @5\)@B	o@^      @5F@B	~($@^@     @5zH@B	X@^     @5t@B
=p
@^     @5j~@B
M@_      @5@B
C\@_@     @5?|h@B
-V@_     @533333@B
Ov`@_     @5?|h@B
s@`      @5 ě@B
{m@`      @5nO@B
:)y@`@     @5R@B
&IR@``     @5`A7@B
qiC@`     @5 ě@B
\(@`     @5 ě@B
\(@`     @5O;@B
vȴ@`     @5O;@B
S&@a      @5zG@B
`A@a      @5zG@BPH@a@     @5zG@B҉@a`     @5O;@B
sP