CDF      
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI444LEE_M ProfileID: 10070313     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $acfdd8b1-bc9f-45f2-857e-03f72e146889   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:15:54    
date_modified         2012-11-07T14:05:32    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-25.42505      geospatial_lat_max        	-25.42505      geospatial_lon_min        	112.40699      geospatial_lon_max        	112.40699      geospatial_vertical_min       03.00      geospatial_vertical_max       136.00     geospatial_vertical_units         decibars   time_coverage_start       2007-08-18T01:22:52Z   time_coverage_end         2007-08-18T01:22:52Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI444LEE_M     water_depth       142.5      
ship_speed        8.3    source_filename       444_LEEUWIN_0313.m1    data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7294   CTD_pressure_offset       0.0    CTD_MinRawPressure        2.20   CTD_MaxRawPressure        136.10     CTD_MinPressureforInterp      2.50   CTD_MaxPressureforInterp      136.10     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        1   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1$   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1,   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        14   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        18   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1<   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1D   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1H   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1 @Ԏ֩ 9l*0@\# )@      @6R-V@A.H@      @6R-V@A_o@      @6R-V@AN;6@      @6QR@AR@      @6R-V@Au@       @6R@4n@ArGE8@"      @6RnO@A'RTa@$      @6RnO@AR<6@&      @6R\(@AR<6@(      @6RnO@Ab}@*      @6QR@Ahr @,      @6R-V@A[W>6@.      @6R-V@Ax@0      @6QR@Ax@1      @6QR@Ao hی@2      @6QR@Ae+a@3      @6QR@Ab}@4      @6QR@A[W>6@5      @6QR@AJE@6      @6RnO@AN;5@7      @6RI^5@A^@8      @6R-V@ADg8~@9      @6RnO@A^@:      @6QR@ADg8~@;      @6Qhr @A[W>6@<      @6Qhr @Ahr @=      @6P`A7@Ahr @>      @6P ě@Aὥ@?      @6P     @AB@@      @6P     @Ao@@     @6O;dZ@Ak~(@A      @6O-V@A@A     @6O\(@An.@B      @6O\(@Ao@B     @6N+@AB@C      @6N5?|@AlD@C     @6M@A.H@D      @6L@A-@D     @6LC@A=p
@E      @6L1&y@Ae+@E     @6KƧ@AC\@F      @6KC%@As@F     @6KI^@AOv`@G      @6Jn@A&IR@G     @6Jn@A&IR@H      @6J=p
@A:)y@H     @6H\)@A@4@I      @6GKƧ@A@4n@I     @6E$/@A0
@J      @6DZ1@AC,@J     @6Bm@A,<@K      @6A$/@A~$@K     @6@
=q@A㋬q@L      @6@ěT@AE@L     @6AGz@AC@M      @6BI^5@A_@M     @6BI^5@A:@N      @6B`A@A2a|@N     @6C$@Asg@O      @6C$@AfA@O     @6CS@A!R@P      @6C
=p@A5Xy>@P@     @6B\(@A捸@P     @6?\(@A\(@P     @6=-V@A@@Q      @68F@Ay@Q@     @67KƧ@Ah	ԕ@Q     @66+J@Am\@Q     @64j~@AZ@R      @63E@AJ@R@     @63$@AO
M@R     @62-V@AK]@R     @60bM@A!R@S      @6/;dZ@A8YJ@S@     @6/-V@Aaf@S     @6/-V@A4m@S     @6.vȴ9X@ArGE8@T      @6*n@A򅇓ݘ@T@     @6%Q@AS@T     @6      @A\N@T     @6lC@Aq@U      @6XbM@AɅoi@U@     @6E@AڹZ@U     @69Xb@A?@U     @5Q@AZc@V      @5\(@A*0U2@V@     @5zG@AcA @V     @5n@B bM@V     @5I^5?@B7KƧ@W      @5+@Be@W@     @5E@Btj~@W     @5v@BZ1@W     @5@B?@X      @5I^@B(@X@     @5lD@BY|@X     @5S@B2a|@X     @5`A@Bv@Y      @5M@B(@Y@     @5-V@BYJ@Y     @5-V@Bȴ9X@Y     @5hr@B@Z      @5S@B$tS@Z@     @5^5?|@B[W>@Z     @5F@BfA@Z     @5KƧ@By=c@[      @5E@B	k@[@     @5@B	|@[     @5I^5@B
W'@[     @5A7K@B
L_@\      @5fffff@B"`B@\@     @5A7K@B/{J#@\     @5{"`B@B~($x@\     @5xtj@BS@]      @5vt@B
+a@]@     @5tj~@B
Y|@]     @5s@B
O;dZ@]     @5s33333@B
p
=@^      @5stj~@B
+j@^@     @5stj~@B
Y|@^     @5rnO@B
O
@^     @5ql@B
!R@_      @5q7Kƨ@B
+j@_@     @5p
=q@B
v@_     @5q$/@B
sh@_     @5o-V@B
U=@`      @5o-V@B
@`      @5nO;@B
E@`@     @5nO;@B
-V@``     @5nzG@B
8Y@`     @5mE@B
oiDg@`     @5mV@Bt@`     @5mV@B
!.@`     @5mV@B
Ϫ͞@a      @5mV@B.2