CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI496LEE_M ProfileID: 10340008     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $70e20963-4410-4524-bf87-fda15cf2b97e   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-09-19T14:17:24    
date_modified         2012-11-15T09:45:08    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.20984      geospatial_lat_max        	-12.20984      geospatial_lon_min        	122.89400      geospatial_lon_max        	122.89400      geospatial_vertical_min       04.00      geospatial_vertical_max       169.00     geospatial_vertical_units         decibars   time_coverage_start       2011-05-28T01:28:46Z   time_coverage_end         2011-05-28T01:28:46Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI496LEE_M     water_depth       200.4      
ship_speed        7.4    source_filename       MVP_2011-05-28_012846.raw      data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        3.10   CTD_MaxRawPressure        169.50     CTD_MinPressureforInterp      3.50   CTD_MaxPressureforInterp      169.50     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1    temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1    salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1$   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1,   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        10   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1@ (kp&@^7KƧ ƨ@      @;tj@@Ʌoi@      @;tj@@hr@      @;tj@@>@      @;tj@@Z@       @;S@@L_@"      @;zG@@̈́M:@$      @;E@@ͿH˒@&      @;S@@jOv@(      @;Q@@w1@*      @;Q@@Ͳ-V@,      @;Q@@΃%@.      @;-@@Vu@0      @;lC@@v_ح@1      @;\)@@D*@2      @;I^@@	@3      @;@@Z@4      @;Z1@@a@N@5      @;t@@
=p@6      @;t@@5Xy@7      @; ě@@ڌL_@8      @;O;@@u%@9      @;=p
@@2W@:      @;`A@@{J#9@;      @;}/w@@PH@<      @;|j~#@@tj~@=      @;nO;@@\)@>      @;kƧ@@@?      @;h9Xb@@Dg8~@@      @;`ěT@@֔Fs@@     @;X\)@@־ߤ?@A      @;XbM@@ָQ@A     @;W+@@֮}Vl@B      @;WO;d@@Ϫ͟@B     @;WO;d@@)^@C      @;WKƧ@@@C     @;XbM@@As@D      @;[dZ@@˒:*@D     @;b`A@@nP@E      @;eQ@@C,z@E     @;c$@@ڶ}Vm@F      @;eQ@@%1@F     @;e@@2a|@G      @;glC@@;5X@G     @;f-@@Ov_@H      @;eQ@@ޔFs@H     @;c$@@ޚ,<@I      @;_;dZ@@Fs@I     @;^vȴ9X@@C-@J      @;^vȴ9X@@ޤT@J     @;]/w@@;5X@K      @;\hr@@ާ-@K     @;\j~#@@p:~@L      @;[S@@?@L     @;[I^@@s@M      @;h1&x@@Z1@M     @;g+I@@`A@N      @;eS@@䛥S@N     @;l@@w1@O      @;m@@$/@O     @;mp
=@@s@P      @;ffffff@@俱[W?@P@     @;[lC@@1@P     @;I7KƧ@@n/@P     @;DS@@-V@Q      @;BI^5@@1@Q@     @;>5?|@@8Y@Q     @;;dZ@@_o @Q     @;8tj@@)^@R      @;4zG@@譫U@R@     @;2 ě@@@N@R     @;*~"@@a|Q@R     @;$/@@:@S      @;$/@@=K@S@     @;%Q@@M:@S     @;%Q@@+J@S     @;"`@@Vϫ@T      @;E@@+j@T@     @;E@@'RT`@T     @;R@@     @T     @;nO@@$xG@U      @;R@@Vϫ@U@     @;
=q@@˒:*@U     @;@@#w@U     @;\(@@@4n@V      @:^5?|@@_@V@     @:9Xb@@Xe,@V     @:$/@@H˒:@V     @:ȴ9X@@D*@W      @:S@@rGE8@W@     @:     @@lD@W     @: ě@@JM@W     @:u$/@@!R@X      @:^5?|@A -
q@X@     @:Hr Ĝ@A 
=q@X     @:9@A[W>6@X     @:!o@A@4n@Y      @:j~@AC,@Y@     @:
n@Aq@Y     @:$/@AlC@Y     @9I^@AIQ@Z      @9Gz@A$/@Z@     @9XbM@A_ح@Z     @9;dZ@AKƧ@Z     @9lC@A	ԕ+@[      @9zG@A@[@     @9\(@Aݗ+@[     @9vȴ9@Ae+@[     @9\(@A
qu@\      @9x@A\)@\@     @9 ě@AbM@\     @9 ě@A@\     @9Q@A@]      @9$@A҈p@]@     @97Kƨ@A@]     @9}E@A	4J@]     @9~Q@AC@^      @9xQ@A	u@^@     @9wKƧ@A	=b@^     @9v+J@Ap:@^     @9t9XbN@A@_      @9YXbM@A
W'@_@     @9O-V@A҉@_     @9Hr Ĝ@A
@4@_     @90 ě@A?@`      @9#S@A"h	ԕ@`      @9
hr!@AD@`@     @8j~@A6z@``     @89XbN@AOv_خ@`     @8~"@A;dZ@`     @8R@A	 @`     @8~Q@A(@`     @81l@AL_@a      @8&x@AQ@a      @7M@An.3@a@     @7E@A6@a`     @7\(@AC-@a     @7B`A@A!N;6@a     @6;dZ@A"W@a     @5䛥S@A#q@a     @5
=p@A3'/@b      @4O;dZ@A3ߤ@b      @4@A4~($x@b@     @4hr!@A5(@b`     @3Vu@A9u!S@b     @3E@A:S&@b     @3}p
=@A<3@b     @3{dZ@A<JM@b     @3y+@A<cA \@c      @3ffffff@A=ce@c      @3L1&y@A>҈p;@c@     @33tj~@A?o@c`     @3 n@A@r Ĝ@c     @3v@A@9Xb@c     @3S@AA@N@c     @2j~@ACa@@c     @2]E@AE}H@d      @2GzH@AE,=@d      @2,1&y@AF
L/@d@     @1Q@AE}H@d`     @1-V@AEC\@d     @1fffff@AEXy=@d     @1S@AF6z@d     @1E@AFR<6@d     @1hr!@AF$/@e      @1=p
@AFt@e      @1}E@AF