CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350001     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $ef7003c8-11c4-4d76-9b6c-eeb41597e243   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:40    
date_modified         2013-01-24T10:32:50    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.21768      geospatial_lat_max        	-12.21768      geospatial_lon_min        	123.48221      geospatial_lon_max        	123.48221      geospatial_vertical_min       03.00      geospatial_vertical_max       155.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-30T12:08:23Z   time_coverage_end         2011-08-30T12:08:23Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       179.0      
ship_speed        7.9    source_filename       HI501_0002.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.30   CTD_MaxRawPressure        155.70     CTD_MinPressureforInterp      2.40   CTD_MaxPressureforInterp      155.70     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@`_b:(os@^܇Tw @      @:O;dZ@@fffff@      @:D/@@zG@      @:A7Kƨ@@O;@      @:2 ě@@ݗ@      @:%\(@@b@       @:\(@@%@"      @:fffff@@T@$      @: `A7@@8}H@&      @:      @@b}V@(      @9Q@@Ft@*      @9dZ@@+I@,      @9Q@@&@.      @9KƧ@@-V@0      @9t@@$tS@1      @9?|h@@@2      @9zG@@-V@3      @9E@@@4      @9hr @@3@5      @9 ě@@@6      @9+@@}H@7      @9@@Vϫ@8      @9C@@>BZc@9      @9I^5?@@;dZ@:      @9C%@@	ԕ+@;      @9陙@@rG@<      @9+@@rG@=      @9R<6@@[W>@>      @9tj@@kP@?      @9vȴ9X@@y@@      @9dZ@@v@@     @9KƧ@@/V@A      @9m@@	@A     @9&x@@&@B      @9 ě@@|hs@B     @9hr@@@C      @9wkP@@;dZ@C     @9I^5?@@#@D      @9̋C@@     @D     @9@@حV@E      @9I^5?@@Vϫ@E     @9̋C@@@@F      @9I^5?@@Vϫ@F     @9Ƨ@@rG@G      @9$@@rGE9@G     @9Ƨ@@䎊r@H      @9I^@@-@H     @9^5?|@@@I      @9
=p@@حV@I     @9ěS@@҈p;@J      @9^5?|@@fffff@J     @9j~@@"@K      @9S@@
=p@K     @9nP@@Fs@L      @9V@@$t@L     @9+I@@Vu@M      @9$/@@t@M     @9"@@$tS@N      @95?|@@Ϫ͟@N     @9^5?|@@1@O      @9zG@@_o@O     @9&x@@iDg8@P      @9Vu@@	k@P@     @9V@@vȴ9@P     @9vȴ@@#@P     @9~"@@rG@Q      @9^5?}@@>BZc@Q@     @9\)@@hۋq@Q     @9
=p@@)^@Q     @9-@@p:@R      @9-@@ۋq
@R@     @9-@@ѷX@R     @9-@@
=q@R     @9x@@7KƧ@S      @9-@@Dg8~@S@     @9{lC@@|@S     @9v+J@@y@S     @9o;dZ@@GE85@T      @9d9XbN@@s@T@     @9[Q@@"`@T     @9Ovȴ9@@~@T     @9GzH@@@4@U      @9:G{@@a@O@U@     @91&x@@&@U     @9!Gz@@a@@U     @9
vȴ@@I^5@V      @8
=p@@w1@V@     @8dZ@@@V     @8Լj~@@;dZ@V     @8ɺ^5?}@@{J#:@W      @8/@@حV@W@     @8$/@@[W>@W     @8tj~@@iDg8@W     @8$/@@|hs@X      @89Xb@Ab}@X@     @8nP@A$/@X     @8tE@A\(@X     @8_vȴ9@A@Y      @8Ffffff@AS@Y@     @8-V@A$@Y     @8`A7@A'0@Y     @7"@AS@Z      @7zG@A_ح@Z@     @7޸Q@AVu@Z     @7E@AOv_@Z     @7lC@AT@[      @7?|h@AVu@[@     @7zG{@AOv_خ@[     @7E@A
G{@[     @7=-V@Awk@\      @7:^5?|@A2W@\@     @75$/@A
~@\     @7Ƨ@A
{m@\     @6"`@A
%@]      @61&x@A@]@     @6j~#@A
O
@]     @6$/@A
!.H@]     @6|j~#@A[W>@^      @6ZG{@A
L/@^@     @5~"@A`d@^     @5sS@Aȴ9X@^     @5<I^5?@AS@_      @51'@A;dZ@_@     @57Kƨ@A2a|@_     @4tj~@A IQ@_     @4tj@A"0
@`      @4r Ĝ@A%Ϫ͞@`      @4j~#@A%5Xy>@`@     @4;dZ@A%8YK@``     @4Gz@A'rGE9@`     @4|1&@A'4֡a@`     @4qhr @A'_o@`     @4n+@A'U=@`     @4f$/@A'.H@a      @4bM@A'r@a      @4Zn@A(PH@a@     @4["`B@A(eO@a`     @4Vt@A'حV@a     @4Ov@A'U=@a     @4;lC@A)_p@a     @4|hs@A'U=@a     @3bM@A)@b      @3\)@A+Q@b      @3+J@A+@N@b@     @3lC@A+S&@b`     @38bM@A*#9@b     @2/w@A)@b     @2xQ@A1~($@b     @2^Q@A1|@b     @2XF@A2vȴ@c      @2WO;d@A1XbM@c      @22 ě@A3a@O@c@     @2j~#@A/vȴ9@c`     @19XbN@A6;5X