CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350002     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $7048eac3-0e66-4140-8003-80dbef3b394e   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:40    
date_modified         2013-01-24T10:32:50    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.16594      geospatial_lat_max        	-12.16594      geospatial_lon_min        	123.48881      geospatial_lon_max        	123.48881      geospatial_vertical_min       03.00      geospatial_vertical_max       163.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-30T12:46:31Z   time_coverage_end         2011-08-30T12:46:31Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       201.4      
ship_speed        8.6    source_filename       HI501_0003.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.80   CTD_MaxRawPressure        163.10     CTD_MinPressureforInterp      2.80   CTD_MaxPressureforInterp      163.10     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@bA(Tr2M@^HL @      @:8F@@7Kƨ@      @:7KƧ@@~($@      @:9^5?}@@7Kƨ@      @:9@@[W>6@      @:9@@C@       @:4zG@@IQ@"      @:.+@@&@$      @:"I^5@@zH@&      @:"`B@@@(      @:\(@@8Y@*      @:-@@ݗ+@,      @:/@@F]d@.      @:S@@fA@0      @:tj@@حV@1      @:䎊q@@@@2      @:M@@rGE9@3      @:o@@حV@4      @:$/@@	ԕ+@5      @: ěT@@6@6      @: n@@Vϫ@7      @:      @@KƧ@8      @9hr@@O;d@9      @9G{@@-V@:      @9"`@@4m@;      @9bM@@@<      @9KƧ@@	@=      @9+J@@RT`e@>      @9$/@@kP@?      @9?|h@@&@@      @9E@@Xe,@@     @9j~@@y@A      @9E@@4m@A     @9zG@@U=@B      @9@@4m@B     @9@@eں@C      @9@@	k@C     @9@@RT`e@D      @9$@@sPH@D     @933333@@8}H@E      @9nO@@O
M@E     @9R@@8}H@F      @9o@@+I@F     @9
=q@@Ft@G      @9hr!@@ߤ?@G     @9^5?}@@҈p;@H      @9fffff@@
L/@H     @9Gz@@+J@I      @9޸Q@@L/{J@I     @9j~#@@c	@J      @91'@@@J     @9և+J@@.2@K      @933333@@+J@K     @9`A7@@O;@L      @9Ѓn@@$t@L     @9\(@@YJ@M      @9ͥv@@YJ@M     @9(\@@E@N      @9I^@@Q@N     @91'@@vȴ9X@O      @97KƧ@@l!-@O     @9ǍO;d@@IQ@P      @9Q@@@P@     @9\(@@R<6@P     @95?|@@1@P     @9G{@@}Vl@Q      @9 ě@@Q@Q@     @97Kƨ@@Mj@Q     @9E@@af@Q     @9=p
@@E84@R      @9u?|h@@C]@R@     @9>5?|@@@R     @9$S@@R<6@R     @9ȴ9X@@}Vm@S      @9Vu@@ᰉ'@S@     @97Kƨ@@qu!@S     @8$xG@@@N@S     @8@@C%@T      @8hr@@@T@     @8
=p@@4K@T     @8;dZ@@c	@T     @85?|@@BZc @U      @8vȴ@@Vu@U@     @8Q@@z@U     @8R@@t@U     @8V@@Ϫ͟@V      @8tj@@qi@V@     @8hr!@A tj@V     @8{dZ@A	@V     @8}/w@AڹY@W      @8yx@@b}V@W@     @8Zn@A:S@W     @849XbN@Au%F@W     @8-V@A/w@X      @8+@AS@X@     @8
O;dZ@AcA \@X     @7E@Ap
=@X     @7\(@A ѷY@Y      @7ӶE@A+I@Y@     @7tj@AsPH@Y     @7`A7@A4K@Y     @7+J@A@Z      @7S@A	@N@Z@     @7}/w@A	@N@Z     @7u$/@A	'R@Z     @7rnO@A	>BZ@[      @7l1&@A@[@     @7e`A7L@A
	 @[     @7_vȴ9@A
M@[     @7G+@A	u@\      @7'-@AS@\@     @71&x@AZ@\     @6"@AlC@\     @6\)@A
v@]      @6tj~@A 'RT@]@     @6Swk@Aqi@]     @6C%@AZ@]     @5+@AH˒@^      @5$/@A@4@^@     @5j~@AU=@^     @5\(@Ay@^     @5|(\@At@_      @5Z^5?|@A!R@_@     @50`A7@An@_     @5Ƨ@A@_     @4/@A*0@`      @4E@A
M;@`      @4+@A      @`@     @47KƧ@A!(@``     @4uS@A!N;5@`     @4@     @Aߤ?@`     @3&x@A#*0U2@`     @3У
=q@A'y@`     @37Kƨ@A(4m@a      @3t@A(	k@a      @31&y@A(:~ @a@     @37Kƨ@A(:~ @a`     @3 ě@A()@a     @3&x@A)~($@a     @3tzG@A*C,@a     @3p ě@A+	@a     @3ilD@A*䎊@b      @3ao@A+lC@b      @3LC@A+=K^@b@     @3ES@A.iB@b`     @3=-V@A
fB@b     @2vt@A+C]@b     @2LI^5?@A//V@b     @2@     @A0e+@b     @2;"`B@A2I^5@c      @27+@A1l@c      @2,1&y@A'?@c@     @1+@A2c	@c`     @1+@A2qiC@c     @1-@A2Zc@c     @1+@A2~"@c     @1lD@A3@c     @1`A@A2 ѷ@d      @11&y@A2u%F@d      @1^"@A3I^@d@     @1?|hs@A3,zxl@d`     @1
@A5!R