CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350004     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $fae0d67f-0ca8-4bd8-a7f2-0f69c2364324   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:40    
date_modified         2013-01-24T10:32:51    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.30696      geospatial_lat_max        	-12.30696      geospatial_lon_min        	123.50893      geospatial_lon_max        	123.50893      geospatial_vertical_min       04.00      geospatial_vertical_max       147.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-30T13:53:08Z   time_coverage_end         2011-08-30T13:53:08Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       156.1      
ship_speed        7.2    source_filename       HI501_0005.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        3.40   CTD_MaxRawPressure        147.50     CTD_MinPressureforInterp      3.50   CTD_MaxPressureforInterp      147.50     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@e4()r\>@^O"} @      @:/\(@@jOv@      @:/;dZ@@<64@      @:/-V@@e@      @:/-V@@2a|@       @:0A7K@@Q@"      @:0 ě@@[@$      @:/-V@@/w@&      @:/-V@@Vl!@(      @:/;dZ@@!.H@*      @:.Vu@@3@,      @:*=p
@@F
L0@.      @:&R<6@@[@0      @:"nO@@[@1      @: bM@@>@2      @:"`@@?@3      @:@@Z@4      @:&x@@!.H@5      @:O;@@Z@6      @:
n@@M:@7      @:@@u"@8      @:/@@D@9      @:$@@:@:      @:M@@@;      @9p
=@@J@<      @9ȴ9X@@9XbN@=      @9O;dZ@@@>      @9x@@?@?      @9㕁$@@_@@      @9`A@@TɆ@@     @9o@@q@A      @9n@@O
M@A     @9A7K@@@B      @9A7K@@TɆ@B     @9     @@qj@C      @9߾vȴ9@@TɆ@C     @9;dZ@@e@D      @9޸Q@@Q@D     @9O;dZ@@sg@E      @9+@@L/{J@E     @9KƧ@@iB@F      @9E@@҈p;@F     @9&x@@H˒:@G      @9&x@@\(@G     @9ěT@@_o@H      @9 ě@@KƧ@H     @9+@@@I      @9@@bM@I     @9I^5?@@u%F@J      @91&y@@
=q@J     @9~"@@)@K      @9ǮzH@@\)@K     @9o@@A [@L      @9lC@@oiD@L     @9+J@@4J@M      @9;dZ@@N;6@M     @9Ƨ@@)y@N      @9Q@@s@N     @9^5?}@@s@O      @9-@@JL@O     @9`A@@ ě@P      @9l@@s@P@     @9vȴ9X@@wkP@P     @9p
=@@IQ@P     @91'@@8Y@Q      @9F@@%F
L@Q@     @9j~@@F
L0@Q     @9R@@fA@Q     @9v@@hr!@R      @9fffff@@a@N@R@     @9gKƧ@@2X@R     @9^zG@A H@R     @9Z=p
@A eO@S      @9P`A7@@-@S@     @9ES@A YJ@S     @97O;d@@p:~@S     @9tj~@A6C@T      @9      @A$@T@     @8O;dZ@A%F
L@T     @8C%@AjOv@T     @8G{@A4K@U      @8-V@AE@U@     @8vȴ9@Aqu"@U     @8`A7K@A<64@U     @8>Q@Asg@V      @8'-@A+J@V@     @8I^@A+I@V     @8-V@A@V     @7`A7@A-
@W      @7/w@A	4J@W@     @7
=q@AAs@W     @7I^5@AC%@W     @7l@A
,<@X      @7m@A
m@X@     @7j=p
@A9@X     @7NVu@A
`A@X     @7>zG@Am]@Y      @7hr@A
=p
@Y@     @6x@AC-@Y     @6
=p@Ar Ĝ@Y     @6G{@AOv_خ@Z      @6ěS@A4֡a@Z@     @6+@A҉@Z     @6\(@AC,z@Z     @6dZ@Aߤ@@[      @6KƧ@ATɆ@[@     @6S@A,<@[     @6lD@Ag	l@[     @6y@A!.H@\      @6w+I@ATɆ@\@     @6q&x@AU=@\     @6o-V@A!R<@\     @6m@A$/@]      @6j~"@A_ح@]@     @6h\)@Az@]     @6hr Ĝ@AC-@]     @6gzH@AO;@^      @6g-@AMj@^@     @6f-@AFs@^     @6eQ@AϪ͟@^     @6aGz@AO;d@_      @6Z1'@A-w1@_@     @6=O;dZ@A6@_     @6V@A/{J#@_     @6	7KƧ@Aaf@`      @6      @A*0@`      @5O;d@AC-@`@     @5t@A,<@``     @533333@AO
M@`     @5F@AIQ@`     @5vȴ9X@A*0U2@`     @57Kƨ@A\(@`     @5\(@A$tS@a      @5\)@A5Xy@a      @5~vȴ9X@AB@a@     @5Ahr @A
=p@a`     @5	lD@A!R@a     @4Ձ$/@A-V@a     @4O;d@A%'0@a     @4mO;dZ@A#a@O@a     @45?|h@A"Ov`@b      @39Xb@A(NU@b      @3ΗO;@A(u!@b@     @3`A7L@A$Z@b`     @3l1&y@A'o