CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350008     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $a9ec4270-d137-4bc6-9ba0-811095e2c2d2   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:41    
date_modified         2013-01-24T10:32:51    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.22039      geospatial_lat_max        	-12.22039      geospatial_lon_min        	123.58007      geospatial_lon_max        	123.58007      geospatial_vertical_min       03.00      geospatial_vertical_max       135.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-30T23:00:52Z   time_coverage_end         2011-08-30T23:00:52Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       151.6      
ship_speed        8.1    source_filename       HI501_0009.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.30   CTD_MaxRawPressure        135.20     CTD_MinPressureforInterp      2.40   CTD_MaxPressureforInterp      135.20     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@}_1 (pD@^ @      @:Q@@jOv@      @:I^5?@@`A7L@      @:I^5?@@M:@      @:1&y@@2a|@      @:I^5?@@?|h@       @:@@fA@"      @:j~#@@?|h@$      @:1&@@?|h@&      @:@@%F
L@(      @:I^5?@@L_@*      @:
n@@E@,      @9ȴ9X@@(@.      @9zG@@!.H@0      @97Kƨ@@*0@1      @9I^@@?@2      @9zH@@zG@3      @9nP@@SMj@4      @9o@@?@5      @97Kƨ@@7@6      @9ěT@@>B[@7      @9A7K@@L_@8      @9A7K@@+a@9      @9A7K@@F
L0@:      @9     @@Y|@;      @9     @@M:@<      @9A7K@@m\@=      @9vȴ9X@@@>      @9ڟvȴ@@Ft@?      @9XbM@@E84@@      @9x@@_o@@     @9F@@ݗ+@A      @9Q@@Vϫ@A     @9ӶE@@PH@B      @9nO@@k~(@B     @9`A7@@'R@C      @9 ě@@6C@C     @9\(@@qiC@D      @9V@@W@D     @9n@@/V@E      @97KƧ@@dZ@E     @91&x@@64@F      @9Z1@@zG@F     @9Õ$@@2a|@G      @9S@@sg@G     @9r Ĝ@@%@H      @9KƧ@@ᰉ@H     @9j~@@zG@I      @9l@@af@I     @9C@@Mj@J      @9\(@@o@J     @9S@@y@K      @9$@@&@K     @9vȴ9@A -
@L      @9M@A[W>6@L     @9 ě@A0
)@M      @9@AN;5@M     @9@A=b@N      @9O;dZ@A-w1@N     @9Q@A'RTa@O      @9r Ĝ@A-V@O     @9x@A0U2a|@P      @9fffff@A3@P@     @9-@AM@P     @9Z1@A"`B@P     @9;dZ@AZ1@Q      @9zvȴ@A#x@Q@     @9wKƧ@A[W?@Q     @9wKƧ@AE@Q     @9vfffff@AE@R      @9tj~@Asg@R@     @9r`A@A8Y@R     @9p`A7@An/@R     @9m@Au@S      @9g-@Avȴ9@S@     @9-@Ahr!@S     @9 
=q@AFs@S     @9O;@A@T      @9@AE84@T@     @8v@A	@T     @8j~#@Aݗ+@T     @8n@Aݗ+@U      @8m@AeO@U@     @8ϝ-V@A
{m@U     @8hr!@A@U     @8-@A
Ϫ͞@V      @8s@AQ@V@     @8WKƧ@A4֡b@V     @82m@ArG@V     @8.Vu@A˒:)@W      @8+"`B@A     @W@     @8F@A@W     @8 ě@Ae+@W     @7ٺ^5?}@A'/@X      @7+@Am\@X@     @7o@A]cA@X     @7nP@AS@X     @7ěT@A҈@Y      @7v@A(\@Y@     @7j~#@Aqj@Y     @7tj@Au@Y     @7n@A:@Z      @7wO;d@Ab@Z@     @7YXbM@Av@Z     @7S33333@AXy=@Z     @7@A7K@AiDg8@[      @7/v@AiDg8@[@     @7!$/@Ap:@[     @6ΗO;@AsP@[     @6$/@AL/{@\      @6u?|h@A74@\@     @6o;dZ@AL/{@\     @6ix@A䎊q@\     @6\(\@Ag	l@]      @6NVu@A@]@     @6*1'@A%2@]     @6hr @A~($@]     @6      @AQ@^      @5$/@A"h	ԕ@^@     @5Լj~@AIQ@^     @5Z1@A$/@^     @5Vu@AzH@_      @5F$/@A"@4@_@     @56+J@A!R@_     @51hr @A"qiC@_     @5#
=p@A"n@`      @5O;d@A"0
@`      @5zG@A#&@`@     @4Vu@A#MjO@``     @4v@A$g8}@`     @4@A%(@`     @4=p
@A%Xy=@`     @4S@A%n/@`     @4Q@A&O;