CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350010     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $c6eeb664-dc44-4a71-9ed6-a421a712daaf   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:42    
date_modified         2013-01-24T10:32:52    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.19594      geospatial_lat_max        	-12.19594      geospatial_lon_min        	123.57659      geospatial_lon_max        	123.57659      geospatial_vertical_min       03.00      geospatial_vertical_max       134.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-30T23:11:53Z   time_coverage_end         2011-08-30T23:11:53Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       148.8      
ship_speed        7.9    source_filename       HI501_0011.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.10   CTD_MaxRawPressure        134.70     CTD_MinPressureforInterp      2.10   CTD_MaxPressureforInterp      134.70     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@}܊
 (dR?g@^پL @      @:XbM@@>@      @:1'@@Q@      @:1'@@*0@      @:XbM@@:@      @:Q@@D@       @:+J@@E@"      @:ȴ9X@@u@$      @:ȴ9X@@u"@&      @:
=p@@u"@(      @:
=p@@hr@*      @:+J@@!.H@,      @:+J@@E@.      @:
=p@@/@0      @:O;d@@?@1      @:KƧ@@o i@2      @:+@@Ʌoi@3      @:zH@@>@4      @:
=p@@>B[@5      @:F@@@6      @:Q@@JM@7      @:O;d@@u"@8      @:KƧ@@hr@9      @:-@@!-w@:      @:+@@>B[@;      @:O;d@@*0@<      @:+@@?@=      @:+@@2a|@>      @:ȴ9X@@u@?      @:
=p@@84֡@@      @:
=p@@E@@     @:+@@*0@A      @:
=p@@qu"@A     @:
=p@@֡a@B      @:x@@(@B     @:
=p@@@C      @:j~@@e@C     @:@@>@D      @:;dZ@@`A7L@D     @:\)@@+j@E      @:-@@zxl"h@E     @:$@@F
L0@F      @9tj~@@H@F     @91&y@@IQ@G      @9lD@@&I@G     @9+J@@"@H      @9$/@@C-@H     @9Q@@O;@I      @9I^5@@Ϫ͞@I     @9dZ@@(@J      @91'@@
L/@J     @9+@@($x@K      @9t@@;5X@K     @9zG@@z@L      @9Լj~@@p:~@L     @9tj~@@IQ@M      @9nO@@$t@M     @9R@@
=p@N      @9ѩl@@p:~@N     @9`A7@@\N<@O      @9;dZ@@1@O     @9+@@m\@P      @9zG@@҈p;@P@     @9O;dZ@@!.I@P     @9I^5?@@Q@P     @9I^@@KƧ@Q      @97KƧ@@@Q@     @9\)@@Vϫ@Q     @9x@@NU@Q     @9x@@r Ĝ@R      @97KƧ@@	k@R@     @9"`@@Y}@R     @9š@@0U2a|@R     @9I^5@@G{@S      @9-V@@W@S@     @9E@@ ѷ@S     @9ěT@@n.@S     @9fffff@@YJ@T      @9j~@A )^@T@     @9S@A=b@T     @9|1&@Ag8}@T     @9vE@Aq@U      @9kI^@Aᰊ@U@     @9ffffff@Au%F@U     @9d/@A|@U     @9ao@A@4@V      @9f-@A5Xy@V@     @9d/@A@V     @9`n@A>B@V     @9Y+@A1'@W      @9[S@AS@W@     @9L1&y@A|Q@W     @9)7KƧ@A l"h	@W     @9!Gz@@Xe,@X      @9O;@A U@X@     @9hr @AN;@X     @9@AF
L0@X     @9 ě@AR<6@Y      @8
=p@Aqu"@Y@     @8`A7L@Aqi@Y     @8dzG@A
kP|@Y     @8|hs@A
ce@Z      @8     @A
b@Z@     @8
=p
@A
v@Z     @8
=p@A
jOv@Z     @7bM@A
8YK@[      @7^5?|@A@[@     @71&y@AzH@[     @7lC@AH@[     @7ěS@ATɅ@\      @7vȴ9X@A'RTa@\@     @7bM@APH@\     @7@A>B@\     @7ix@A~($x@]      @7ao@ATɆ@]@     @6zG@A˒:)@]     @61&x@A}Vl@]     @6qR@A)y@^      @6ES@AkP|@^@     @67+@An.@^     @6$@A'/W@^     @5`A7L@A8YK@_      @5-@AS&@_@     @5Q&x@A u%F@_     @5Fx@A 4m@_     @5C$@Ao @`      @5>5?|@A-@`      @5:vȴ@A 	k@`@     @57
=p@A!>BZ@``     @5.+@A"n@`     @5)x@A!'R@`     @5(1&x@A!7Kƨ@`     @5$S@A!u