CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350013     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $51f3ffa2-1bce-46c5-bf53-938259998041   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:43    
date_modified         2013-01-24T10:32:52    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.29131      geospatial_lat_max        	-12.29131      geospatial_lon_min        	123.61257      geospatial_lon_max        	123.61257      geospatial_vertical_min       03.00      geospatial_vertical_max       138.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-31T01:13:16Z   time_coverage_end         2011-08-31T01:13:16Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       148.4      
ship_speed        7.7    source_filename       HI501_0015.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.10   CTD_MaxRawPressure        138.20     CTD_MinPressureforInterp      2.10   CTD_MaxPressureforInterp      138.20     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@A(&@^4X  @      @:zG@@qj@      @:\(@@2W@      @:@@zG@      @:m@@?@      @:1&@@cA \@       @:wkP@@ߤ@@"      @:r Ĝ@@ߤ@@$      @:zH@@Q@&      @:+I@@1&y@(      @:-@@/{J#@*      @:S@@n.@,      @:`A7L@@҈@.      @:S@@a@@0      @:o@@Z@1      @9|hs@@tj@2      @9vȴ9X@@@3      @9"`B@@g@4      @9Q@@L_@5      @9nO@@tj@6      @9Q@@?@7      @9fffff@@+a@8      @9Z1@@<64@9      @9\(@@C-@:      @9o@@$t@;      @9hr@@@<      @9-@@ ě@=      @9E@@D@>      @99XbN@@D@?      @9"`B@@VϪ@@      @9ěS@@!.H@@     @9\(@@<64@A      @9l@@!.H@A     @9G{@@@B      @9E@@8YJ@B     @9+@@Ϫ͟@C      @9G{@@@C     @9zH@@!-w1@D      @9`A7L@@.H@D     @9$@@\(@E      @9hr @@KƧ@E     @9+@@KƧ@F      @9^5?|@@?@F     @91'@@@G      @9bM@@;dZ@G     @9+J@A }H@H      @9+@Au!S@H     @9=p
@An.@I      @9^5?}@AOv`@I     @9Gz@Ad7@J      @9~"@AZc@J     @9z^5?|@Aݘ@K      @9kQ@AD@K     @9KƧ@A@L      @94E@AOv`@L     @9&x@Ac	@M      @9E@ASMj@M     @8lD@A}Vl@N      @81'@Aߤ?@N     @8E@A\N<@O      @8
=q@AR<6@O     @8mV@A
u@P      @8j=p
@A
\@P@     @8j1'@A
M:@P     @8i^5?}@A
ce@P     @8jn@A
p
=@Q      @8ilD@A
!R@Q@     @8hr Ĝ@A
=K@Q     @8f-@A
@Q     @8`ěT@A?@R      @84zG@A[W>@R@     @8(r Ĝ@Ar@R     @8
=p@A-
@R     @8lC@ATɅo@S      @7zG@A4J@S@     @7E@AOv`@S     @7׍O;d@A@S     @7|hs@AC,@T      @7^5?|@AS@T@     @7r Ĝ@A(\@T     @7\)@Ag8}@T     @7\)@A\N@U      @7/@A(\@U@     @7Z1@AC,zx@U     @7S@AZ1@U     @7M@AC@V      @77Kƨ@A_@V@     @7Gz@AL_@V     @7Q@A]ce@V     @7xbM@AFt@W      @7nVu@A8YK@W@     @7\hr@Am\@W     @7EQ@A@W     @76+J@Ao @X      @7\(@Ay=c@X@     @6Q@A>BZc@X     @6Լj~@AkP|@X     @6"`@APH@Y      @6V@Aqu!@Y@     @6Q@Aa@N@Y     @6Gz@A@N@Y     @6-V@A{J#9@Z      @6hr@AJ#9@Z@     @6G{@Aߤ@Z     @6bM@A҈@Z     @6hr!@AA@[      @6~vȴ9X@Ahۋq@[@     @6ZG{@AL_@[     @6j~#@Aᰊ@[     @5`A7L@A$/@\      @5QR@A!ᰉ'@\@     @5zG@A#MjO@\     @4@A$Ʌoi@\     @4
=p@A&1@]      @4Q@A(*0@]@     @4wKƧ@A)o@]     @4kQ@A*Q_@]     @4b\(@A*s@^      @4U\(@A*@^@     @4J=p
@A+s@^     @4F$/@A+|@^     @4<j~#@A,m8@_      @4*n@A*GE85@_@     @4Z1@A-hr!@_     @3lC@A,E@_     @3G{@A-@`      @3`A@A,TɆ@`      @3;dZ@A17KƧ@`@     @3zvȴ@A1 ѷ@``     @3-V@A3Q@`     @2
=p@A2e+@`     @2׍O;d@A1X@`     @27KƧ@A5n/@`     @2cnP@A62X@a      @2Vt@A7fA@a      @2<j~#@A8@@a@     @2,1&y@A9rGE8