CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350015     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $4206246c-f478-4c1e-99a5-34877a8c79f9   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:43    
date_modified         2013-01-24T10:32:52    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.26957      geospatial_lat_max        	-12.26957      geospatial_lon_min        	123.60950      geospatial_lon_max        	123.60950      geospatial_vertical_min       03.00      geospatial_vertical_max       136.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-31T01:23:36Z   time_coverage_end         2011-08-31T01:23:36Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       146.2      
ship_speed        7.5    source_filename       HI501_0017.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.40   CTD_MaxRawPressure        136.40     CTD_MinPressureforInterp      2.40   CTD_MaxPressureforInterp      136.40     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@. (;'@^I^ @      @:(1&x@@@      @:!7Kƨ@@E@      @:!7Kƨ@@
L/@      @:!o@@E@      @:/w@@!.@       @:@@%@"      @:
=p@@H˒@$      @:fffff@@n/@&      @:\(@@ݗ@(      @:E@@v@*      @:@@\(@,      @:I^5@@@.      @:v@@?|h@0      @:
=p@@o h@1      @9j~@@a@@2      @9-@@VϪ@3      @9
=p@@o h@4      @9S@@1&@5      @9S@@K]@6      @9m@@!R@7      @9S@@@8      @9S@@x@9      @9`A@@U2a|@:      @9"@@ěT@;      @9zG@@*0U2a@<      @9hr@@@=      @9F@@M@>      @9?|h@@nO@?      @9ěT@@eO@@      @9zG@@%2@@     @9̋C@@Q@A      @9I^@@@A     @9C%@@M:@B      @9C%@@64@B     @9n@@zG@C      @9ǮzH@@?@C     @9$/@@֡a@D      @9S@@K]@D     @9š@@@E      @9š@@?@E     @9E@@o i@F      @9`A@@JM@F     @9;dZ@@o i@G      @9 ě@@\N<@G     @9C%@@v_ح@H      @9vȴ9@@8}H@H     @9Q@A tj@I      @9nP@A ҈p@I     @9vȴ9@ADg8~@J      @9|(\@A_p@J     @9w+@A@K      @9s33333@AsP@K     @9rnO@A@L      @9mhr!@A	@L     @9_vȴ9@AlD@M      @9GzH@Am\@M     @9>"@A~"@N      @9:vȴ@A@N     @96E@Axl"h
@O      @91o@Ag	@O     @9.+@A ѷ@P      @9,I^5?@AnO@P@     @9#S@AC%@P     @9p
=@AC,@P     @9
O;dZ@AP{@Q      @8vȴ9X@A*1@Q@     @8XbM@A/w@Q     @8+@AVl!@Q     @8O;d@AB@R      @8+J@AjOv@R@     @8E@A}H@R     @89XbN@A(@R     @8bM@Ab@S      @8Gz@A;dZ@S@     @8ěT@A*0U@S     @8ݲ-V@Ahۋq@S     @8j~#@A@T      @8ؓtj@A4m@T@     @8vȴ9@A	R@T     @8O;d@A	|Q@T     @8`A@A
m@U      @8Q@AS&@U@     @8/w@A{J#9@U     @81&x@A9@U     @8j~@A@V      @8@AxF]@V@     @8A7K@A"h	ԕ@V     @8xtj@AZ@V     @8lI^5?@A
@W      @8dZ1@A?@W@     @8aGz@A.2@W     @8^Q@Ap:~@W     @8["`B@Aaf@X      @8V+J@AFs@X@     @8KƧ@A3@X     @8@n@Ar@X     @81l@A>BZc@Y      @8#nP@A)@Y@     @8^5?|@A:S@Y     @8Q@A|@Y     @7=p
@A~($@Z      @7t@AQ@Z@     @7U$/@A@Z     @76+J@ArGE9@Z     @7+C%@A@[      @7"I^5@A3@[@     @7E@Am\@[     @6\(@A|Q@[     @6;dZ@A-@\      @6?|h@A6C@\@     @633333@As@\     @633333@ArGE8@\     @6"@A@]      @6C$@AMjO@]@     @6\(@A(@]     @5bM@A?@]     @5dZ@A5?|@^      @5+@A1@^@     @5I^5@A{J#:@^     @5=p
=@A!JE@^     @5"@A"M@_      @5`A7L@A$"h	ԕ@_@     @4-V@A#qu!@_     @4ٙ@A%IQ@_     @4ɺ^5?}@A%@`      @4/@A%ᰉ@`      @4@A(
qu@`@     @4vt@A(:~ @``     @4i7KƧ@A'@@`     @4<(\@A)l@`     @3zG@A+)^	@`     @3;dZ@A.z@`     @3lC@A2nO@a      @2@A4q