CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350017     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $d9860d80-3621-4a97-8346-89311f48b2a7   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:43    
date_modified         2013-01-24T10:32:53    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.24647      geospatial_lat_max        	-12.24647      geospatial_lon_min        	123.60619      geospatial_lon_max        	123.60619      geospatial_vertical_min       03.00      geospatial_vertical_max       129.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-31T01:34:21Z   time_coverage_end         2011-08-31T01:34:21Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       139.3      
ship_speed        7.9    source_filename       HI501_0019.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.40   CTD_MaxRawPressure        129.60     CTD_MinPressureforInterp      2.60   CTD_MaxPressureforInterp      129.60     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@1~K (~1P@^$Jb @      @:1hr @@lC@      @:/\(@@O
@      @:,1&y@@Ϫ͞@      @:'lC@@
qv@      @:"I^5@@(@       @:O;@@oiDg@"      @:(\@@C\@$      @:G{@@,=@&      @:7KƧ@@Xy=@(      @:KƧ@@ڹ@*      @:x@@+j@,      @:t@@S@.      @:j~@@@0      @:33333@@v@1      @: ě@@1@2      @:-@@D@3      @9;dZ@@
qv@4      @9j~#@@ݗ@5      @9S@@fA@6      @9dZ@@\@7      @9dZ@@!R@8      @9^5?|@@5Xy>@9      @9bM@@!R@:      @9t@@g8}@;      @9\(@@Q@<      @9hr!@@zxl"@=      @9=p
@@!-w@>      @9Z1@@L/{J@?      @9޸Q@@Mj@@      @9vȴ9X@@@@     @9E@@,@A      @9(\@@˒:)@A     @9G{@@ ě@B      @9XbM@@YJ@B     @9ȴ9X@@rGE@C      @9Ձ$/@@R<6@C     @9t@@y@D      @9?|h@@1'@D     @9t@@M@E      @9Ձ$/@@ڹY@E     @9`A7L@@sP@F      @9E@@}Vm@F     @99XbN@@33333@G      @9nO@@	@G     @9ѩl@@33333@H      @9У
=q@@PH@H     @9 ě@@]cA@I      @9zG@@"`B@I     @9I^5?@@~@J      @9r Ĝ@@E@J     @9ěS@@E@K      @9ěT@@lC@K     @9vȴ9X@@SMj@L      @9"`B@@zxl"h@L     @9m@@
(@M      @9S@@E84@M     @9hr @@@N      @9zG{@A 	k@N     @9vt@A C@O      @9n+@A7Kƨ@O     @9kQ@Au@P      @9kC%@AD@P@     @9ix@AR@P     @9hF@AlD@P     @9g+I@AnP@Q      @9h1&x@AwkQ@Q@     @9gzH@AY@Q     @9^5?|@A:)z@Q     @9S@A64@R      @9N+@AZ@R@     @9Dtj@A6@R     @9=-V@A#@R     @9:~"@AtSM@S      @99XbM@A%F
L@S@     @97O;d@AQ@S     @93tj~@A$/@S     @9+dZ@AzG@T      @9&fffff@A@T@     @9S@A@T     @9Z1@A䎊r@T     @8t@A>BZc@U      @8x@A)^@U@     @8E@Ae+@U     @8ٙ@A	@U     @8=p
@A	@V      @81'@A
,<@V@     @8
=q@AS&@V     @8a7Kƨ@A
m\@V     @8XQ@A
\(@W      @8H9Xb@AOv_خ@W@     @8=/w@A@W     @8+S@AF]d@W     @8(1&x@A@@X      @8!o@A˒:*@X@     @8 bM@A
=q@X     @8G{@APH@X     @833333@A@Y      @7`A@AoiD@Y@     @7KƧ@An@Y     @7@A~"@Y     @7cS@AV@Z      @7Ql@AV@Z@     @7*n@AOv_@Z     @75?|@Ao@Z     @7!l@A1@[      @7"`@A@[@     @7O;@A&@[     @7C@A@[     @7lC@Ay@\      @6tj@A	ԕ+@\@     @6S@A'RT@\     @6^5?|@A4֡b@\     @6ǮzH@A@]      @6$/@A@]@     @6E@ATɅo@]     @6Q@A.H@]     @6C@A_o@^      @6lC@Am\@^@     @5hr!@A8YK@^     @5 ě@A!N;6@^     @4t@A$?@_      @4@A%%@_@     @41&x@A&t@_     @4i7KƧ@A(e+@_     @4Mhr!@A'b}V@`      @3bM@A*#9@`      @3G{@A2xl"h
