CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350019     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $60eab3f5-c3b8-4a5d-959a-e4cf279424fb   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:44    
date_modified         2013-01-24T10:32:53    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.22336      geospatial_lat_max        	-12.22336      geospatial_lon_min        	123.60290      geospatial_lon_max        	123.60290      geospatial_vertical_min       03.00      geospatial_vertical_max       133.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-31T01:44:56Z   time_coverage_end         2011-08-31T01:44:56Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       142.8      
ship_speed        7.9    source_filename       HI501_0021.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.60   CTD_MaxRawPressure        133.10     CTD_MinPressureforInterp      2.70   CTD_MaxPressureforInterp      133.10     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@|(r\=x@^ᰊ @      @:,I^5?@@ݗ@      @:+Q@@*0@      @:%`A7L@@#x@      @:$S@@o h@      @:" ě@@_@       @: A7K@@Ʌoi@"      @:hr@@`d@$      @:r Ĝ@@TɆ@&      @:O;d@@O
M@(      @:
=p@@Z@*      @:ȴ9X@@@,      @:+J@@'0@.      @:E@@/@0      @:t@@Z@1      @:?|h@@N;@2      @:E@@E@3      @:j~@@Z@4      @: ě@@֡a@5      @:;dZ@@o i@6      @:
@@#@7      @:
hr!@@3@8      @:
n@@֡a@9      @:	x@@1&@:      @:@@zxl"@;      @:I^5@@TɆ@<      @: ěT@@#x@=      @9vȴ9@@?@>      @: A7K@@u"@?      @:      @@>B[@@      @9;dZ@@/@@     @9-V@@>@A      @91'@@JM@A     @9KƧ@@+a@B      @9\(@@B@B     @9tj~@@}H@C      @9R@@b@C     @9-V@@%@D      @9\(@@Fs@D     @9+@@fffff@E      @9O;dZ@@6z@E     @99Xb@@@F      @9zH@@Vϫ@F     @9S@@{J#:@G      @9\(@@r@G     @9vȴ9X@@iDg8@H      @9lC@@&@H     @9"`@@v_ح@I      @9ؓtj@@@I     @91&x@@r@J      @9+@@O
M@J     @9+@@fA@K      @9G{@@&x@K     @9
=p@@u!@L      @9Ձ$/@@     @L     @9
=p@@#9@M      @9nO@@)y@M     @9lD@@|@N      @9|hs@@+j@N     @9E@Ac	@O      @9\(@Ag@O     @9hr!@A@P      @9hr!@APH@P@     @9~"@AzG@P     @9p
=@A
qv@P     @9dZ@A\N<@Q      @9F@Ab@Q@     @9 ě@Ahr!@Q     @9Vu@AQ@Q     @9
=p@AQ@R      @9z^5?|@Atj@R@     @9xbM@Aj~#@R     @9qR@AڹZ@R     @9hr Ĝ@Ac	@S      @9^vȴ9X@A+j@S@     @9XQ@A@S     @9Stj~@A'0@S     @9G+I@AڹZ@T      @9BM@AM:@T@     @9'zH@AcA @T     @9|hs@Ap:~@T     @9+I@A!R<@U      @8䛥S@AFt@U@     @8dZ@Aݗ+@U     @8M@A1&x@U     @8Q@AE@V      @8Y@A5?|@V@     @8KQ@Aqi@V     @8GzH@A'@V     @8DZ1@A,<@W      @8@     @A8YJ@W@     @81&x@AH˒:@W     @8"nO@AsPH@W     @7
=p@A&@X      @7Q@A'RT`@X@     @7y"`@ArG@X     @7hr@AzG@X     @6Q@At@Y      @6KƧ@A!R<@Y@     @6n@AY}@Y     @6j~@AGE85@Y     @6qR@Ad8@Z      @6 ě@A6z@Z@     @5F@A>@Z     @5ڟvȴ@A4K@Z     @5&x@A?@[      @5yXbM@A}Vl@[@     @56E@A!b}@[     @5&fffff@A"W'@[     @5#
=p@A"e+@\      @5Q@A"xl"h
@\@     @5"`B@A"p:@\     @5^5?|@A"qiC@\     @5O;d@A"L/{@]      @5j~@A"Y@]@     @5
=q@A"ᰊ@]     @5S@A#C,z@]     @4"`@A#Ƨ@^      @4&x@A$*1@^@     @4Ƨ@A&iB@^     @4kƧ@A'>6z@^     @4#
=p@A*vȴ@_      @3E@A,64@_@     @3Ƨ@A-cA @_     @3;dZ@A/@_     @3I^5@A.iB@`      @3^vȴ9X@A0r Ĝ@`      @3CnP@A0ѷX@`@     @3#nP@A2)y@``     @3@A2)y@`     @2C%@A2S&@`     @2E@A5}H