CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350020     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $7c3f8e4a-9c7a-4ccc-ab2d-a2f55f2663f4   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:44    
date_modified         2013-01-24T10:32:53    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.21155      geospatial_lat_max        	-12.21155      geospatial_lon_min        	123.60121      geospatial_lon_max        	123.60121      geospatial_vertical_min       03.00      geospatial_vertical_max       134.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-31T01:50:18Z   time_coverage_end         2011-08-31T01:50:18Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       144.1      
ship_speed        7.9    source_filename       HI501_0022.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.50   CTD_MaxRawPressure        134.50     CTD_MinPressureforInterp      2.60   CTD_MaxPressureforInterp      134.50     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@	 (lPH@^z9 @      @:;"`B@@IQ@      @:;"`B@@+a@      @:8Q@@sg@      @:3tj~@@qj@      @:.O;@@Y|@       @:(\)@@!R@"      @:'zH@@2a|@$      @:&x@@hr@&      @:%$/@@O
M@(      @:"M@@N;@*      @:!7Kƨ@@7@,      @: ěT@@/@.      @: n@@u"@0      @: A7K@@K]@1      @:|hs@@1&@2      @:;dZ@@TɆ@3      @:p
=@@D@4      @:1&@@'0@5      @:(\@@V@6      @:S@@hr@7      @:lD@@@8      @:F@@3@9      @:9Xb@@֡a@:      @:+I@@!-w@;      @:m@@+a@<      @:\(@@84֡@=      @:
1'@@F
L0@>      @:$@@%@?      @9x@@,<@@      @9R@@_o@@     @9Q@@,@A      @99Xb@@.H@A     @9r Ĝ@@1@B      @91&x@@)^@B     @9fffff@@Xe@C      @9㕁$@@ߤ?@C     @9|hs@@)^@D      @9vȴ9X@@
M;@D     @9p
=@@
=p@E      @9j~#@@@E     @9G{@@A@F      @9F@@Fs@F     @9ȴ9X@@iDg8@G      @9E@@H˒:@G     @99XbN@@,@H      @9ѩl@@As@H     @9ѩl@@-V@I      @9У
=q@@eں@I     @9;dZ@@kP@J      @9zG@@حV@J     @9͑hr!@@     @K      @9I^5?@@K]c@K     @9I^5?@@ѷX@L      @9~"@@TɅo@L     @9r Ĝ@@s@M      @9+@@@M     @9Ƨ-@@iB@N      @9`A7L@@lD@N     @9ěT@@䎊@O      @9-V@@S&@O     @9lC@@Q_@P      @9E@@:)y@P@     @9&x@@,zxl@P     @9lD@@q@P     @9@@@Q      @99Xb@@_ح@Q@     @9A7K@@+j@Q     @9ȴ9X@A @@Q     @9O;@A7Kƨ@R      @9{lC@A 	ԕ+@R@     @9j~"@A `A7@R     @9_;dZ@A A7K@R     @9\j~#@A@S      @9c$@Axl"h
@S@     @9hr Ĝ@Ahr@S     @9h\)@AVu@S     @9U$/@AɅoi@T      @9;"`B@Aqj@T@     @9<j~#@A@T     @9;"`B@A8YK@T     @97O;d@A@U      @9-hr!@AMj@U@     @9"@AE@U     @97Kƨ@A_ح@U     @8nO@Avȴ9X@V      @8hr@AE@V@     @8\(@AD@V     @8hr!@A	#w@V     @8stj~@A
)y@W      @8^Q@An.3@W@     @8PbM@Ag@W     @8CS@AwkP@W     @83@A
d7@X      @8-V@Av@X@     @7E@A@X     @7
=p@A@4@X     @7n@AR<6@Y      @7mO;dZ@AC\@Y@     @7h1&x@Au%F@Y     @7KC%@An.3@Y     @77-@AS&@Z      @6Z1@A!.H@Z@     @6S@ANU@Z     @6wO;d@AnO@Z     @6vȴ9@AiB@[      @5-@A<쿱@[@     @5 ě@AE@[     @5"`@A>@[     @5+@A$t@\      @5+I@A$t@\@     @5v+J@A)^@\     @5rm@A&@\     @5nzG@AsPH@]      @5ffffff@AlC@]@     @5[S@ArG@]     @5M-V@A ۋq
@]     @5Jn@A ěT@^      @5B`A@A!#w@^@     @5-V@A D@^     @5;dZ@A!X@^     @41'@A#\N@_      @4ěT@A$1&@_@     @4
hr!@A(bM@_     @3Q@A-!.@_     @3
=p@A/@`      @3wKƧ@A/?@`      @3pbM@A0}H@`@     @3ix@A0_F@``     @3`ěT@A0
qu@`     @3XF@A0[6@`     @3BM@A1-w1@`     @3?vȴ9@A1 ѷ