CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350023     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $5636b14f-0a99-4b2b-9a75-d3042412dde8   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:44    
date_modified         2013-01-24T10:32:54    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.17128      geospatial_lat_max        	-12.17128      geospatial_lon_min        	123.59534      geospatial_lon_max        	123.59534      geospatial_vertical_min       03.00      geospatial_vertical_max       134.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-31T02:08:10Z   time_coverage_end         2011-08-31T02:08:10Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       146.6      
ship_speed        8.4    source_filename       HI501_0025.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.10   CTD_MaxRawPressure        134.80     CTD_MinPressureforInterp      2.30   CTD_MaxPressureforInterp      134.80     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@@y(W@^
 @      @:2m@@@      @:,I^5?@@tj~@      @: n@@(\@      @:vȴ9X@@q@      @:1&@@Mj@       @:^5?|@@`d@"      @:t@@@$      @:
O;dZ@@p
=@&      @:R@@R<6@(      @9vȴ9@@@*      @9;dZ@@qi@,      @9E@@m\@.      @9(\@@"@0      @9"`B@@1@1      @9dZ@@Xe@2      @9@@,@3      @9t@@)^@4      @9tj~@@Mj@5      @9o@@O
M@6      @9
=q@@H˒:@7      @9\(@@lC@8      @9Ƨ@@+I@9      @9=p
@@H˒:@:      @9\)@@H˒:@;      @9x@@1@<      @9S@@H˒:@=      @9     @@1@>      @9j~#@@o@?      @9=p
@@]cf@@      @9t@@z@@     @9tj~@@O;@A      @9-V@@,<@A     @9nO@@$t@B      @9щ7Kƨ@@쿱[W@B     @9ѩl@@҈p;@C      @9ϝ-V@@!.I@C     @9vȴ9X@@@D      @91&y@@!-w1@D     @97KƧ@@4֡a@E      @9fffff@@RT`e@E     @9Z1@@eں@F      @9vȴ9@@K]d@F     @9vȴ9X@@/V@G      @9/w@@qi@G     @9tj@@@H      @9/@@'RT`@H     @9KƧ@@Gz@I      @9E@@ᰊ@I     @9@@]cA@J      @9
=p@@ݗ+k@J     @9$/@@@K      @9
=p@@A [@K     @9m@@`d@L      @9nO@@VϪ@L     @9R@@6@M      @9@@6@M     @9~"@@ݗ+k@N      @9lD@@
=p@N     @9zG{@@m]@O      @9bI^5@@Z@O     @9R ě@@+a@P      @97
=p@@;5X@P@     @91&@@H˒:@P     @9+J@@͞@P     @9tj~@@حV@Q      @9I^@@@Q@     @9fffff@A :~ @Q     @8;dZ@A $xG@Q     @8+@A -
@R      @8&x@A 
(@R@     @8n@A @R     @8zH@A@R     @8Q@Aԕ*@S      @8Z1@AC\@S@     @8zG@Au%F
@S     @8@A䎊q@S     @8Q@A䎊q@T      @8Q@A@T@     @8Q@AY@T     @8/@AC,z@T     @8@AMjO@U      @8Q@A@U@     @8
=p@A=K^@U     @8o@AZ@U     @8p
=@A)^	@V      @8+@A\N@V@     @8I^@ASMj@V     @8+@A@V     @8
=q@A_@W      @8v@A:)z@W@     @8["`B@A2a|@W     @8+Q@A     @W     @8F@A	=b@X      @8	7KƧ@A
3@X@     @7+I@Ajf@X     @7߾vȴ9@A
M:@X     @7O;@A@Y      @7F@A@Y@     @77Kƨ@Ax@Y     @7}E@A@Y     @7{lC@Al@Z      @7zvȴ@A^5?}@Z@     @7w+@A_o@Z     @7r`A@A4J@Z     @7a$/@Ao hی@[      @7.zG@A?@[@     @6"@Ajf@[     @6`A7@AE@[     @6\(\@A#w@\      @6Ao@A-w1@\@     @69XbM@A(@\     @60bM@A	k~@\     @6.+@A4J@]      @6.+@AA [@]@     @6.+@A7KƧ@]     @6-hr!@AGz@]     @6,C@A#w@^      @6#
=p@A^@^@     @6vȴ9@Ab}@^     @6/w@Au@^     @6KƧ@A@_      @6m@A|@_@     @6O;@A:)y@_     @6r Ĝ@A\(@_     @6      @Axl"h
@`      @5$/@Ag	@`      @5 ě@Aq@`@     @5qhr @AlC@``     @5DS@A!.H@`     @56+J@A"䎊@`     @5$/@A"䎊@`     @4և+J@A$_