CDF      
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Leeuwin Cruise: HI500LEE_M ProfileID: 10350030     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule.The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.     keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $f655ec43-3840-4c1b-9103-e399dcaccc6d   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      :Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.

CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.     date_created      2012-11-05T10:33:45    
date_modified         2013-01-24T10:32:55    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-12.25705      geospatial_lat_max        	-12.25705      geospatial_lon_min        	123.64102      geospatial_lon_max        	123.64102      geospatial_vertical_min       03.00      geospatial_vertical_max       129.00     geospatial_vertical_units         decibars   time_coverage_start       2011-08-31T04:53:05Z   time_coverage_end         2011-08-31T04:53:05Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI500LEE_M     water_depth       138.3      
ship_speed        7.1    source_filename       HI501_0032.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        2.70   CTD_MaxRawPressure        129.00     CTD_MinPressureforInterp      2.70   CTD_MaxPressureforInterp      129.00     CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@ (ߤ@^x> @      @:1&x@@@      @:     @@b@      @:y7KƧ@@@      @:s33333@@m\@      @:mhr!@@@       @:cE@@7@"      @:^"@@qj@$      @:WzH@@_@&      @:P`A7@@#x@(      @:I@@N;@*      @:@A7K@@Fs@,      @:8Q@@֡a@.      @:4M:@@[@0      @:2-V@@Y|@1      @:/-V@@hr@2      @:-V@@'0@3      @:*~"@@@4      @:&fffff@@Q@5      @:#@@E@6      @:!4J@@!.H@7      @: A7K@@'0@8      @:vȴ9@@JM@9      @:5?|@@E@:      @:S@@1&@;      @:t@@nO@<      @:
=p@@p:@=      @9V@@6C@>      @9E@@l@?      @9@@ᰊ@@      @9S@@n@@     @9dZ@@c	@A      @9ꟾvȴ@@!-w2@A     @9	k~@@L_@B      @9zH@@,@B     @9`A7L@@}H@C      @9䛥S@@
=q@C     @9I^5@@TɅo@D      @9;dZ@@ԕ*@D     @9vȴ9X@@R@E      @9vȴ9X@@@E     @9޸Q@@:)y@F      @9޸Q@@6C@F     @95?|@@Q_@G      @95?|@@^5?|@G     @9zG@@a|Q@H      @9ݲ-V@@W'@H     @9/w@@S&@I      @9@@g	@I     @9j~#@@͞&@J      @9lC@@vȴ@J     @9lC@@S&@K      @9ۥS@@<64@K     @9dZ@@L/{@L      @9dZ@@S&@L     @9ٙ@@qiC@M      @9և+J@@d7@M     @9tj~@@n@N      @9R@@&@N     @9;dZ@@@N@O      @9ϝ-V@@	@O     @9+@@xF]@P      @9@@~($@P@     @9"`@@q@P     @9ěT@@PH@P     @9dZ@@?@Q      @9+@@#@Q@     @9Z1@@>B[@Q     @9v@@v@Q     @9I^@@H@R      @9lC@@1@R@     @9fffff@@+@R     @9Q@@1@R     @9`A@@sPH@S      @9vȴ9@@$tS@S@     @9"@A >BZc@S     @9xQ@@s@S     @9]-V@A ѷX@T      @9Q&x@A 'RT`@T@     @9E`A7L@@($x@T     @9-hr!@@eں@T     @91&@@BZc @U      @9-@@\(@U@     @8@A U@U     @89XbN@@$tS@U     @89XbN@Awk@V      @8/w@AZ@V@     @8R@AjOv@V     @8+I@A'0@V     @8hr Ĝ@A֡a@W      @8,@A
vȴ@W@     @85?|@A
	 @W     @8\)@A
b@W     @8x@ABZc @X      @7/w@Ac	@X@     @7A7K@AϪ͟@X     @77Kƨ@A}Vl@X     @7lD@A@Y      @7
=p@AFs@Y@     @7tj@A
%F
L@Y     @7tj~@AGz@Y     @7cnP@AN;5@Z      @7L@AQ@Z@     @7.O;@Aq@Z     @71&y@ANU@Z     @6$/@AU@[      @6x1&x@AZ@[@     @6*=p
@A)^@[     @6?|h@Aeں@[     @5x@AoiDg8@\      @5ȴ9X@AiB@\@     @59Xb@AMj@\     @5/@AC]@\     @5$@AI^@]      @5?|h@A=b@]@     @5^vȴ9X@Am8@]     @5$zG@AK]c@]     @4Gz@A
M;@^      @4dZ@A )^@^@     @4&x@A"0
@^     @4I^@A#=K^@^     @41&x@A")_@_      @4fffff@A$C@_@     @4|hs@A#'/@_     @4@A#	@_     @4F$/@A!iB@`      @3;dZ@A"xl"h
@`      @3\)@A1 ѷ